/***************************************************************************
    file	         : kb_ora10i.h
    copyright            : (C) 1999,2000,2001,2002,2003,2004 by Mike Richardson
			   (C) 2001,2002,2003,2004 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *     This program is licensed under the terms contained in the file      *
 *     LICENSE which is contained with the source code distribution.       *
 *                                                                         *
 ***************************************************************************/


#include 	<stdio.h>
#include 	<stdlib.h>

#include 	<qarray.h>
#include 	<qdict.h>
#include 	<qstring.h>
#include 	<qintdict.h>
#include 	<qmessagebox.h>
#include 	<qptrlist.h>
#include 	<qvariant.h>
#include 	<qdatetime.h>
#include 	<qcstring.h>


#include 	<sys/types.h>


#include 	"kb_classes.h"
#include 	"kb_type.h"
#include 	"kb_value.h"
#include 	"kb_database.h"

#include 	"kb_libloader.h"

#include 	<oci.h>


class	KBOra10i	;

class	ColumnInfo
{
	OCILobLocator	*createLobLocator ()	;
	OCIRowid	*createRowID	  ()	;
	OCIDate		*createDateTime	  ()	;

public	:

	KBOra10i	*m_pServer	;	/* Server		*/

	QString		m_colName	;	/* Colum name		*/
	KB::IType	m_colRklType	;	/* Internal Rekall type	*/
	ub2		m_colOraType	;	/* Oracle sumbolic type	*/
	ub1		m_colNullable	;	/* Column can be null	*/
	ub2		m_colDataSize	;	/* Max. data length	*/
	ub2		m_colCharSize	;	/* Maximum characters	*/
	sb2		m_colPrecision	;	/* Oracle "scale"	*/
	ub4		m_colGetType	;	/* Type for OCIDefine	*/

	char		*m_buffer	;
	int		m_dataSize	;

	sb2		m_ind		;
	OCIDefine	*m_define	;
	OCILobLocator	*m_lobLocator	;
	OCIRowid	*m_rowid	;
	OCIDate		*m_datetime	;

	dvoid		*m_valuep	;
	ub2		m_resultLen	;

	int		m_mode		;


	ColumnInfo	(KBOra10i *, OCIParam *, bool &, KBError &) ;
	~ColumnInfo	()		;

	KBValue	value	(KBType *)	;
}	;

/*  Ora10iTypeMap														*/
/*  -----------															*/
/*  Structure used to map between ODBC and internal types. The global	*/
/*  array holds all possible mappings; each time a connection is	*/
/*  opened, a driver specific map is created containing just those	*/
/*  types applicable to the server.					*/

struct	Ora10iTypeMap
{
	cchar		*m_ora9iIdent	;
	cchar		*m_ora9iCreate	;
	KB::IType	m_kbType	;
	cchar		*m_kbName	;
	uint		m_flags		;
}	TypeMap		;


/*  KBOra10iValue													*/
/*  -----------															*/
/*  When values are bound to parameters (placeholders) the buffer	*/
/*  storing the value must remain until after the query has been	*/
/*  executed. This class is used to convert the Rekall value into the	*/
/*  correct format for KBOra10i, and so hang on to it as long as is	*/
/*  needed.																*/

class	KBOra10iValue
{
	union
	{	int			m_fixed	 	;
		double			m_dbl	 	;
		uchar			m_stamp[7]	;
	}	m_d	;

	uchar		*m_alloc	;

	const void	*m_valuePtr	;
	sb4		m_valueSize	;
	ub2		m_SymbolicType	;
	sb2		m_pIndPtr	;

public:

	KBOra10iValue	(const KBValue &) ;
	~KBOra10iValue	() ;

	inline	ub2		symbolicType	() { return m_SymbolicType	; }
	inline	void		*valuePtr	() { return (void *)m_valuePtr	; }
	inline	sb4		valueSize	() { return m_valueSize		; }
	inline	dvoid		*indPtr		() { return &m_pIndPtr		; }
}	;


/*  ------------------------------------------------------------------  */

/*  KBOra10iType								*/
/*  -----------								*/
/*  This is the derived type for the Ora10i interface.		 	*/

class	KBOra10iType : public KBType
{
	ub2	m_oraType	;

public:

	KBOra10iType	(ub2, KB::IType, ub4, bool) ;

	virtual	bool    isValid      (const QString &, KBError  &, const QString & = QString::null  ) ;
	virtual	void	getQueryText (KBDataArray   *, KBShared *, KBDataBuffer  &, QTextCodec * = 0) ;
}	;

/*  ------------------------------------------------------------------  */

/*  KBOra10i								*/
/*  -------								*/
/*  Implementation class for the interface to the Oracle 9i database	*/

class KBOra10i : public KBServer
{
	bool			m_showRowID		;
	bool			m_showOra10iObjects	;
	bool			m_useTimeouts		;
#ifdef	__NOTYET
	int			m_stmtTimeout		;
#endif
	int			m_lockTimeout		;
	QString			m_connectStr		;

	void			*m_activeCookie		;
	bool			m_inTransaction		;

	void			cleanUp		() ;

	bool			doListObjects 	(KBTableDetailsList &, cchar *, cchar *, KB::TableType, uint) ;

	virtual	bool	 	doConnect    	(KBServerInfo  *) ;
	virtual	bool		doListTables 	(KBTableDetailsList &, uint = KB::IsAny) ;
	virtual	bool		doListFields 	(KBTableSpec   &) ;
	virtual	bool		doCreateTable	(KBTableSpec   &,  bool, bool = false) ;
	virtual	bool		doRenameTable	(cchar *, cchar *, bool) ;
	virtual	bool		doDropTable  	(cchar *,	   bool) ;


public	:

	KBOra10i();
	virtual~KBOra10i();

	virtual	KBSQLSelect	*qrySelect 	(bool, const QString &, bool) ;
	virtual	KBSQLUpdate	*qryUpdate 	(bool, const QString &, const QString &) ;
	virtual	KBSQLInsert	*qryInsert 	(bool, const QString &, const QString &) ;
	virtual	KBSQLDelete	*qryDelete 	(bool, const QString &, const QString &) ;

	virtual	bool		command		(bool, const QString &, uint, KBValue *, KBSQLSelect ** = 0) ;
	virtual	bool		transaction	(Transaction, void **) ;

	virtual	QString		placeHolder	(uint) ;
	virtual	QString		rekallPrefix	(const QString & = QString::null) ;
//	virtual bool		listDatabases	(QStringList &) ;
	virtual	QString		listTypes	() ;
	virtual	bool		tableExists	(const QString &, bool &) ;
//	virtual	uint 		optionFlags	() ;

//	virtual	bool		getSyntax	(QString &, KBServer::Syntax, ...) ;
	QString			getVariable	(const QString &) ;


	OCIStmt 		*prepare	(const QString &) ;
	OCIStmt			*executeQuery	(const QString &, uint, const KBValue *, const QString &) ;
	bool			executeQuery	(OCIStmt *, 	  uint, const KBValue *, int &, const QString &, const QString &) ;
	bool			objectExists	(const QString &,  KB::TableType, bool &) ;

	bool			bindParameters	(OCIStmt *, uint, const KBValue *,  QList<KBOra10iValue> &)	;
	bool 			checkOra10iOK	(sword status, const QString &where, KBError &) ;

	int errorNumber();
	QString warning();
	bool getRowCount(int&);

	QString		m_Database		;
	OCIEnv		*m_pEnvHandle		;
	OCISvcCtx	*m_pServerContextHandle	;
	OCIError	*m_pErrorHandle		;

	inline	ub2	ocimode ()
	{
		return	m_inTransaction ? OCI_DEFAULT : OCI_COMMIT_ON_SUCCESS ;
	}

	friend	class	KBOra10iQrySelect	;
}	;

/*  KBOra10iQrySelect							*/
/*  ----------------							*/
/*  Implementation class for select queries on the Oracle 9i database	*/

class KBOra10iQrySelect : public KBSQLSelect
{
	KBOra10i	*m_pServer	;
	bool		m_update	;
	OCIStmt		*m_stmt		;
	int		m_CRow		;
	ColumnInfo	**m_columns	;

	ColumnInfo 	*makeColumn	(OCIParam* pParam) ;

public:

	KBOra10iQrySelect	(KBOra10i *, bool, const QString &, bool) ;
	KBOra10iQrySelect	(KBOra10i *, bool, const QString &, OCIStmt *) ;
	virtual~KBOra10iQrySelect() ;

	virtual	bool		execute		(uint, const KBValue *) ;
	virtual	KBValue		getField	(uint, uint, KBValue::VTrans) ;
	virtual	QString		getFieldName	(uint) ;
	virtual	bool		rowExists	(uint, bool = true) ;
}	;

/*  KBOra10iQryUpdate							*/
/*  ----------------							*/
/*  Implementation class for update queries on the Oracle 9i database	*/

class	KBOra10iQryUpdate : public KBSQLUpdate
{
	KBOra10i	*m_pServer	;
	OCIStmt		*m_stmt		;

public:

	KBOra10iQryUpdate	(KBOra10i *, bool, const QString &, const QString &) ;
	virtual~KBOra10iQryUpdate() ;

	virtual	bool	execute	(uint, const KBValue *) ;
}	;

/*  KBOra10iQryInsert							*/
/*  ----------------							*/
/*  Implementation class for insert queries on the MySQL database	*/

class	KBOra10iQryInsert : public KBSQLInsert
{
public	:

	struct	RowIDResult
	{
		char	m_text[32]	;
		ub4	m_len		;
		sb2	m_ind		;
		ub2	m_rc		;
	}	;

private	:

	KBOra10i	*m_pServer		;
	OCIStmt		*m_stmt			;
	OCIStmt		*m_pIdentityStmHandle	;
	OCIBind 	*m_bind			;
	RowIDResult	m_rowid			;

	int		m_useSeq		;
	KBValue		m_newKey		;

	OCIStmt		*m_fetchKey		;
	OCIDefine	*m_pkDefine		;
	sb2		m_pkInd			;
	ub2		m_pkResultLen		;

public:

	KBOra10iQryInsert	 (KBOra10i *, bool, const QString &, const QString &) ;
	virtual~KBOra10iQryInsert () ;

	virtual	bool	execute	 (uint, const KBValue *) ;
	virtual	bool	getNewKey(const QString &, KBValue &, bool);
}	;

/*  KBOra10iQryDelete							*/
/*  ----------------							*/
/*  Implementation class for delete queries on the MySQL database	*/

class	KBOra10iQryDelete : public KBSQLDelete
{
	KBOra10i	*m_pServer	;
	OCIStmt		*m_stmt		;

public:

	KBOra10iQryDelete	(KBOra10i *, bool, const QString &, const QString &) ;
	virtual~KBOra10iQryDelete();

	virtual	bool	execute	(uint, const KBValue *) ;
};

/*  ------------------------------------------------------------------  */

static const ub1 CSID_NCHAR = SQLCS_NCHAR;

#define DYNAMIC_CHUNK_SIZE 255
#define	ora9iOK(rc) ((rc == OCI_SUCCESS) || (rc == OCI_SUCCESS_WITH_INFO))

#define	UNIMPL(op)							\
	m_lError = KBError						\
		   (KBError::Error,					\
			QString("Unimplemented: %1").arg(op),		\
			QString::null,					\
			__ERRLOCN					\
		   )	;
