/***************************************************************************
    file	         : kb_odbcadv.h
    copyright            : (C) 1999,2000,2001,2002 by Mike Richardson
			   (C) 2000,2001,2002 by theKompany.com
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *     This program is licensed under the terms contained in the file      *
 *     LICENSE which is contained with the source code distribution.       *
 *                                                                         *
 ***************************************************************************/


#include	<stdio.h>
#include	<qlabel.h>
#include	<qtabwidget.h>

#ifndef		_WIN32
#include	"kb_odbcadv.moc"
#else
#include	"kb_odbcadv.h"
#endif



/*  KBODBCAdvanced							*/
/*  KBODBCAdvanced							*/
/*		: Constructor for PgSQL advanced options object		*/
/*  (returns)	: KBODBCAdvanced	:				*/

ODBC_NS::KBODBCAdvanced::KBODBCAdvanced  ()
	:
	KBDBAdvanced ("odbc")
{
	fprintf	(stderr, "KBODBCAdvanced::KBODBCAdvanced  ()\n") ;
	m_mapCRLF	= false ;
	m_showSysTables	= false ;
	m_mapExpressions= false ;
}

/*  KBODBCAdvanced							*/
/*  ~KBODBCAdvanced							*/
/*		: Destructor for PgSQL advanced options object		*/
/*  (returns)	:		:					*/

ODBC_NS::KBODBCAdvanced::~KBODBCAdvanced ()
{
}

/*  KBODBCAdvanced							*/
/*  load	: Load settings from DOM element			*/
/*  driverElem	: QDomElement &	: DOM element				*/
/*  (returns)	: void		:					*/

void	ODBC_NS::KBODBCAdvanced::load
	(	const QDomElement &driverElem
	)
{
	m_mapCRLF	= driverElem.attribute ("mapcrlf"	).toUInt() ;
	m_showSysTables	= driverElem.attribute ("showsystables" ).toUInt() ;
	m_mapExpressions= driverElem.attribute ("mapexpressions").toUInt() ;
	m_odbcType	= driverElem.attribute ("odbctype"	) ;
}

/*  KBODBCAdvanced							*/
/*  save	: Save settings from DOM element			*/
/*  driverElem	: QDomElement &	: DOM element				*/
/*  (returns)	: void		:					*/

void	ODBC_NS::KBODBCAdvanced::save
	(	QDomElement	&driverElem
	)
{
	driverElem.setAttribute ("mapcrlf", 	   m_mapCRLF	   ) ;
	driverElem.setAttribute ("showsystables",  m_showSysTables ) ;
	driverElem.setAttribute ("mapexpressions", m_mapExpressions) ;
	driverElem.setAttribute ("odbctype", 	   m_odbcType	   ) ;
}

/*  KBODBCAdvanced							*/
/*  setupDialog	: Set up advanced options dialog			*/
/*  tabWidget	: RKTabWidget *	: Tab widget to which to attach pages	*/
/*  (returns)	: void		:					*/

void	ODBC_NS::KBODBCAdvanced::setupDialog
	(	QTabWidget	*tabWidget
	)
{
	fprintf	(stderr, "KBODBCAdvanced::setupDialog  ()\n") ;

	QWidget		*advWidget	= new QWidget	  (tabWidget) ;
	QGridLayout	*advLayout	= new QGridLayout (advWidget) ;

	tabWidget->addTab (advWidget, "ODBC") ;

	m_cbMapCRLF		= new QCheckBox (advWidget) ;
	m_cbMapCRLF->setText 	      (TR("Map CR/LF in strings" )) ;
	m_cbMapCRLF->setChecked	      (m_mapCRLF	      ) ;

	m_cbShowSysTables	= new QCheckBox (advWidget) ;
	m_cbShowSysTables ->setText   (TR("Show system tables"   )) ;
	m_cbShowSysTables ->setChecked(m_showSysTables) ;

	m_cbMapExpressions 	= new QCheckBox (advWidget) ;
	m_cbMapExpressions->setText   (TR("Wrap names with [...]")) ;
	m_cbMapExpressions->setChecked(m_mapExpressions) ;

	QLabel	*lOdbcType	= new QLabel	(advWidget) ;
	m_cbOdbcType	 	= new QComboBox (advWidget) ;
	lOdbcType	  ->setText   (TR("Underlying database"  )) ;

	m_cbOdbcType	  ->insertItem(""     ) ;
	m_cbOdbcType	  ->insertItem("MySQL") ;
	m_cbOdbcType	  ->insertItem("Jet"  ) ;

	if	(m_odbcType == "MySQL") m_cbOdbcType->setCurrentItem(1) ;
	else if	(m_odbcType == "Jet"  ) m_cbOdbcType->setCurrentItem(2) ;
	else				m_cbOdbcType->setCurrentItem(0) ;

	advLayout  ->addWidget  (m_cbMapCRLF,	     0, 1) ;
	advLayout  ->addWidget  (m_cbShowSysTables,  1, 1) ;
	advLayout  ->addWidget  (m_cbMapExpressions, 2, 1) ;
	advLayout  ->addWidget  (lOdbcType,	     3, 0) ;
	advLayout  ->addWidget  (m_cbOdbcType,	     3, 1) ;

	advLayout  ->setRowStretch (4, 1) ;
}

/*  KBODBCAdvanced							*/
/*  saveDialog	: Save results from dialog				*/
/*  (returns)	: void		:					*/

void	ODBC_NS::KBODBCAdvanced::saveDialog ()
{
	m_mapCRLF 	= m_cbMapCRLF	    ->isChecked  () ;
	m_showSysTables	= m_cbShowSysTables ->isChecked  () ;
	m_mapExpressions= m_cbMapExpressions->isChecked  () ;
	m_odbcType	= m_cbOdbcType      ->currentText() ;
}

/*  KBODBCAdvanced							*/
/*  copy	: Replicate this object					*/
/*  (returns)	: KBODBCAdvanced * : Replicated object			*/

KBDBAdvanced
	*ODBC_NS::KBODBCAdvanced::copy ()
{
	KBODBCAdvanced	*copy	= new KBODBCAdvanced () ;

	copy->m_mapCRLF	      = m_mapCRLF	 ;
	copy->m_showSysTables = m_showSysTables  ;
	copy->m_mapExpressions= m_mapExpressions ;
	copy->m_odbcType      = m_odbcType	 ;

	return	copy	;
}
