/***************************************************************************
    file	         : kb_odbc.h
    copyright            : (C) 1999,2000,2001 by Mike Richardson
			   (C) 2000,2001 by theKompany.com
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *     This program is licensed under the terms contained in the file      *
 *     LICENSE which is contained with the source code distribution.       *
 *                                                                         *
 ***************************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<sys/types.h>
#include	<time.h>

#ifdef		UNICODE
#undef		UNICODE
#endif

#ifdef		_UNICODE
#undef		_UNICODE
#endif

#ifndef 	_WIN32
#include 	<sql.h>
#include 	<sqltypes.h>
#include	<unistd.h>
#include	<pwd.h>
#else
#include	<windows.h>
#include	<odbcinst.h>
#endif

#include 	<sqlext.h>

#include	<qarray.h>
#include	<qdict.h>
#include	<qstring.h>
#include	<qintdict.h>

#ifndef	SQLTables_TABLE_NAME
#define	SQLTables_TABLE_NAME		(3)
#endif
#ifndef	SQLTables_TABLE_TYPE
#define	SQLTables_TABLE_TYPE		(4)
#endif
#ifndef	SQLTables_REMARKS
#define	SQLTables_REMARKS		(5)
#endif
#ifndef	SQLColumns_COLUMN_NAME
#define	SQLColumns_COLUMN_NAME		(4)
#endif
#ifndef	SQLColumns_DATA_TYPE
#define	SQLColumns_DATA_TYPE		(5)
#endif
#ifndef	SQLColumns_TYPE_NAME
#define	SQLColumns_TYPE_NAME		(6)
#endif
#ifndef	SQLColumns_COLUMN_SIZE
#define	SQLColumns_COLUMN_SIZE		(7)
#endif
#ifndef	SQLColumns_DECIMAL_DIGITS
#define	SQLColumns_DECIMAL_DIGITS	(9)
#endif
#ifndef	SQLColumns_NULLABLE
#define	SQLColumns_NULLABLE		(11)
#endif
#ifndef	SQLColumns_COLUMN_DEF
#define	SQLColumns_COLUMN_DEF		(13)
#endif

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_serverinfo.h"

#include	"kb_odbcval.h"

#define		GETBUFSIZ	(2048)
#define		MAGIC		(0x1a2b3c4d)

#include	"kb_libloader.h"

namespace	ODBC_NS
{

/*  ODBCTypeMap								*/
/*  -----------								*/
/*  Structure used to map between ODBC and internal types. The global	*/
/*  array holds all possible mappings; each time a connection is	*/
/*  opened, a driver specific map is created containing just those	*/
/*  types applicable to the server.					*/

struct	ODBCTypeMap
{
	SQLSMALLINT	odbcType	;
	char		odbcName[64]	;

	KB::IType	kbType		;
	cchar		*kbName		;

	uint		flags		;
}	;




/*  ------------------------------------------------------------------  */

/*  KBODBCType								*/
/*  -----------								*/
/*  This is the derived type for the ODBC interface. 			*/

class	KBODBCType : public KBType
{
	SQLSMALLINT	m_odbcType	;

public	:

	KBODBCType (SQLSMALLINT, uint, bool) ;

	virtual	bool    isValid      (const QString &, KBError  &, const QString & = QString::null) ;
	virtual	void	getQueryText (KBDataArray   *, KBShared *, KBDataBuffer  &, QTextCodec * = 0) ;
}	;


/*  ------------------------------------------------------------------  */

class	KBODBC	;

/*  ODBCDriverExtn							*/
/*  --------------							*/
/*  There is information and functionality that cannot be accessed or	*/
/*  used without specific driver knowledge. This stucture is used where	*/
/*  we can provide such additional stuff ....				*/

struct	ODBCDriverExtn
{
	/* QRegExp style regular pattern, to be matched agains the	*/
	/* driver description returned by ODBC.				*/
	cchar		*match	;

	/* Wrappers functions for construction of the four query types.	*/
	/* Typically they would instantiate driver-specific objects.	*/
	KBSQLSelect	*(*qrySelect)	(KBODBC *, bool, const QString &, bool) ;
	KBSQLUpdate	*(*qryUpdate)	(KBODBC *, bool, const QString &, const QString &) ;
	KBSQLInsert	*(*qryInsert)	(KBODBC *, bool, const QString &, const QString &) ;
	KBSQLDelete	*(*qryDelete)	(KBODBC *, bool, const QString &, const QString &) ;

	/* Wrapper for field listing. Called after standard list-fields	*/
	/* method to garner additional information, like auto-increment	*/
	bool		(*doListFields)	(KBODBC *, KBTableSpec   &, KBError &) ;

	/* Syntax element functions. Can be null of the extension does	*/
	/* not treat this specially.					*/
	QString		(*limitOffset)	(int, int) ;

	/* Miscellaneous flags describing driver functionality. If used	*/
	/* then the top bit should be set, otherwise they will be	*/
	/* ignored.							*/
	uint		flags	;
}	;

#define	ODBC_FLAGS_COLDEF	0x00000001	/* Columns have default	*/
#define	ODBC_FLAGS_USED		0x80000000	/* Flags are used	*/


/*  ------------------------------------------------------------------  */

/*  KBODBC								*/
/*  -------								*/
/*  Implementation class for the interface to the PostgreSQL database	*/

class	KBODBC : public KBServer
{
	SQLHENV			m_envHandle	;
	SQLHDBC			m_conHandle	;
	bool			m_connected	;
	QIntDict<ODBCTypeMap>	m_typeDict	;

	QStringList		m_autoTypes	;

	bool			m_mapCRLF	;
	bool			m_showSysTables	;
	bool			m_mapExpressions;
	bool			m_readOnly	;
	QString			m_odbcType	;

	QString			m_primaryType	;
	QString			m_textType	;
	QString			m_integerType	;
	QString			m_blobType	;

	SQLUSMALLINT		m_caseMapping	;
	bool			m_keepsCase	;
	ODBCDriverExtn		*m_driverExtn	;

	QString			getAvailableType(int, ...) ;
	bool			getTypeInfo	() ;
	bool			execSQL		(const QString &, cchar *) ;
	void			findDataSource	() ;

	bool			doListTables	(KBTableDetailsList &, const QString &, bool, uint) ;

	virtual	bool	 	doConnect    	(KBServerInfo   *) ;
	virtual	bool		doListTables	(KBTableDetailsList &, uint = KB::IsAny) ;
	virtual	bool		doListFields 	(KBTableSpec    &) ;
	virtual	bool		doCreateTable	(KBTableSpec    &,  bool, bool = false) ;
	virtual	bool		doRenameTable	(cchar *, cchar *,  bool) ;
	virtual	bool		doDropTable  	(cchar *,	    bool) ;

public	:

	KBODBC		() ;
	virtual	~KBODBC () ;


	virtual	KBSQLSelect	*qrySelect	(bool, const QString &, bool) ;
	virtual	KBSQLUpdate	*qryUpdate	(bool, const QString &, const QString &) ;
	virtual	KBSQLInsert	*qryInsert	(bool, const QString &, const QString &) ;
	virtual	KBSQLDelete	*qryDelete	(bool, const QString &, const QString &) ;

	virtual	bool		command		(bool, const QString &, uint, KBValue *, KBSQLSelect **) ;

	virtual bool		listDatabases	(QStringList &) ;
	virtual	QString		listTypes 	() 	  ;
	virtual	QString		mapExpression	(const QString &) ;
	virtual	bool		tableExists	(const QString &,  bool &) ;
	virtual	bool		getSyntax	(QString &, KBServer::Syntax, ...) ;

	bool			getStatement	(SQLHSTMT &) ;
	bool			bindParameters	(SQLHSTMT, uint, const KBValue *, QList<KBODBCValue> &, QTextCodec *) ;
	bool			checkRCOK	(SQLHSTMT, SQLRETURN, cchar *, SQLSMALLINT = SQL_HANDLE_STMT) ;
	bool			checkDataOK	(SQLHSTMT, SQLRETURN, cchar *) ;
	bool			getRowCount	(SQLHSTMT, int &) ;

	inline	bool		mapCRLF		() { return m_mapCRLF ; }

	virtual	bool		keepsCase  	() ;
}	;


/*  KBODBCQrySelect							*/
/*  ----------------							*/
/*  Implementation class for select queries on the MySQL database	*/

class	KBODBCQrySelect : public KBSQLSelect
{
	KBODBC			*m_pServer  ;
	SQLHSTMT		m_stmHandle ;

	int			m_CRow	    ;	/* Current loaded row	*/
	QValueList<SQLSMALLINT>	m_dbTypes   ;	/* Database types	*/
	QValueList<SQLSMALLINT>	m_cTypes    ;	/* C types		*/
	QStringList		m_colNames  ;	/* Column names		*/

public	:

	KBODBCQrySelect (KBODBC *, bool, const QString &, bool) ;
virtual~KBODBCQrySelect () ;

	KBODBCQrySelect	(KBODBC *, SQLHSTMT, bool, const QString &, bool &) ;

	virtual	bool	execute	 	(uint, const KBValue *) ;
	virtual	KBValue	getField 	(uint, uint, KBValue::VTrans) ;
	virtual	QString	getFieldName	(uint) ;
	virtual	bool	rowExists	(uint, bool = true) ;
}	;


/*  KBODBCQryUpdate							*/
/*  ----------------							*/
/*  Implementation class for update queries on the MySQL database	*/

class	KBODBCQryUpdate : public KBSQLUpdate
{
protected :

	KBODBC		*m_pServer	;
	SQLHSTMT	m_stmHandle	;

public	:
	KBODBCQryUpdate (KBODBC *, bool, const QString &, const QString &) ;
virtual~KBODBCQryUpdate () ;

	virtual	bool	execute	 (uint, const KBValue * ) ;
}	;

/*  KBODBCQryInsert							*/
/*  ----------------							*/
/*  Implementation class for insert queries on the MySQL database	*/

class	KBODBCQryInsert : public KBSQLInsert
{
	QString		m_autocol	;

protected :

	KBODBC		*m_pServer	;
	SQLHSTMT	m_stmHandle	;

public	:
	KBODBCQryInsert (KBODBC *, bool, const QString &, const QString &) ;
virtual~KBODBCQryInsert () ;

	virtual	bool	execute	   (uint, const KBValue *) ;
	virtual	bool	getNewKey  (const QString &, KBValue &, bool) ;
}	;

/*  KBODBCQryDelete							*/
/*  ----------------							*/
/*  Implementation class for delete queries on the MySQL database	*/

class	KBODBCQryDelete : public KBSQLDelete
{
protected :

	KBODBC		*m_pServer	;
	SQLHSTMT	m_stmHandle	;

public	:
	KBODBCQryDelete (KBODBC *, bool, const QString &, const QString &) ;
virtual~KBODBCQryDelete () ;

	virtual	bool	execute	 (uint, const KBValue * ) ;
}	;

}

/*  ------------------------------------------------------------------  */

#define	ODBCOK(rc) ((rc == SQL_SUCCESS) || (rc == SQL_SUCCESS_WITH_INFO))

#define	UNIMPL(op) \
	m_lError = KBError						\
		   (	KBError::Error,					\
			QString("Unimplemented: %1").arg(op),		\
			QString::null,					\
			__ERRLOCN					\
		   )	;

