/***************************************************************************
    file	         : kb_db2cli.h
    copyright            : (C) 1999,2000,2001 by Mike Richardson
			   (C) 2000,2001 by theKompany.com
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *     This program is licensed under the terms contained in the file      *
 *     LICENSE which is contained with the source code distribution.       *
 *                                                                         *
 ***************************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	<time.h>
#include	<stdarg.h>

#ifndef 	_WIN32
#include	<unistd.h>
#include	<pwd.h>
#else
#include	<ctype.h>
#include	<memory.h>
#endif

#include	<sys/types.h>

#include	<qarray.h>
#include	<qdict.h>
#include	<qstring.h>
#include	<qintdict.h>
#include	<qmap.h>

#ifdef 		UNICODE
#undef 		UNICODE
#endif

#include	<sqlcli1.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_databuffer.h"
#include	"kb_database.h"

#include 	"kb_odbcval.h"

#define		GETBUFSIZ	(2048)
#define		MAGIC		(0x1a2b3c4d)

#include	"kb_libloader.h"



/*  DB2CLITypeMap														*/
/*  -----------															*/
/*  Structure used to map between ODBC and internal types. The global	*/
/*  array holds all possible mappings; each time a connection is		*/
/*  opened, a driver specific map is created containing just those		*/
/*  types applicable to the server.										*/

struct	DB2CLITypeMap
{
	SQLSMALLINT	symbolicType;
	char		db2CliName[64];
	KB::IType	kbType;
	const char*	kbName;
	uint		flags;				// Various flags
}	TypeMap;


/*  ------------------------------------------------------------------  */
/*																		*/
/*  KBDB2CLIType														*/
/*  -----------															*/
/*  This is the derived type for the DB2CLI interface. 					*/
/*																		*/
/*  ------------------------------------------------------------------  */

class 	KBDB2CLIType : public KBType
{
	SQLSMALLINT	m_dbcliType;
public:

	KBDB2CLIType	(SQLSMALLINT, uint, bool) ;

	virtual	bool 	isValid
		(	const QString	&,
			KBError		&,
			const QString	& = QString::null
		)	;
	virtual	void 	getQueryText
		(	KBDataArray	*,
			KBShared	*,
			KBDataBuffer	&,
			QTextCodec	* = 0
		)	;
}	;


/*  ------------------------------------------------------------------  */
/*																		*/
/*  KBDB2CLI															*/
/*  --------															*/
/*  Implementation class for the interface to the DB2 database			*/
/*																		*/
/*  ------------------------------------------------------------------  */

class	KBDB2CLI : public KBServer
{
	
	QString		m_Database	;
	bool		m_readOnly	;
	SQLHANDLE	m_EnvHandle	;
	SQLHANDLE	m_ConHandle	;
	bool		m_Connected	;

	QMap<QString,QString>
			m_identities	;

	QString	getAvailableType(int, ...);

	bool		doListTables
			(	KBTableDetailsList	&,
				bool			,
				const QString		&, 
				uint 			= KB::IsAny
			)	;

	virtual bool 	doConnect		(KBServerInfo *) ;
	virtual	bool 	doListTables		(KBTableDetailsList &, uint = KB::IsAny) ;
	virtual	bool 	doListFields		(KBTableSpec  &) ;
	virtual	bool 	doCreateTable		(KBTableSpec  &,   bool, bool = false) ;
	virtual	bool 	doRenameTable		(cchar *, cchar *, bool) ;
	virtual	bool 	doDropTable		(cchar *, bool) ;

public:

	KBDB2CLI();
	virtual~KBDB2CLI();

	bool 			execSQL		(const QString &, cchar*) ;

	virtual	KBSQLSelect	*qrySelect	(bool, const QString &, bool) ;
	virtual	KBSQLUpdate	*qryUpdate	(bool, const QString &, const QString &) ;
	virtual	KBSQLInsert	*qryInsert	(bool, const QString &, const QString &) ;
	virtual	KBSQLDelete	*qryDelete	(bool, const QString &, const QString &) ;
	virtual	KBSQLCursor	*qryCursor	(bool, const QString &, const QString &) ;

	virtual	bool		command		(bool, const QString &, uint, KBValue *, KBSQLSelect **) ;
	virtual	bool		transaction	(Transaction, void **) ;

	bool 			getIdentityCols	(const QString &,  QStringList &) ;
	virtual	QString		rekallPrefix	(const QString & = QString::null) ;
	virtual	QString		listTypes	() ;
	virtual	bool		tableExists	(const QString &,  bool &) ;
	virtual	bool		keepsCase	();
	virtual	bool		getSyntax	(QString &, KBServer::Syntax, ...) ;

	bool 			getStatement	(SQLHSTMT &);
	bool			bindParameters	(SQLHSTMT, uint, const KBValue *, QList<KBODBCValue> &, QTextCodec *) ;
	bool			checkRCOK	(SQLHSTMT, SQLRETURN, cchar *, SQLSMALLINT = SQL_HANDLE_STMT) ;
	bool 			checkDataOK	(SQLHSTMT, SQLRETURN, cchar *) ;
	void 			describeParams	(SQLHSTMT, QValueList<SQLSMALLINT> &) ;


	/* Methods used to maintain the table/identity mappings. See	*/
	/* the ::loadTypeInfo() code and comments for an explanation of	*/
	/* this.							*/
	inline	void	clearIdentity
		(	const QString	&table
		)
	{
		m_identities.remove (table) ;
	}
	inline	void	setIdentity
		(	const QString	&table,
			const QString	&column
		)
	{
		m_identities.insert (table, column) ;
	}
	inline	QString	&findIdentity
		(	const QString	&table
		)
	{
		return	m_identities[table] ;
	}

	virtual SQLHANDLE 	connectionHandle()
	{
		return	m_ConHandle ;
	}

	inline bool mapCRLF	()
	{
		return	false	;
	}
}	;

/*  ------------------------------------------------------------------  */
/*									*/
/*  KBSQLTypeInfo							*/
/*  -------------							*/
/*  Object used to handle query type retrieval. Split out as it is used	*/
/*  in the select and cursor objects					*/
/*									*/
/*  ------------------------------------------------------------------  */


class	KBSQLTypeInfo
{
public	:

	KBDB2CLI		*m_kbServer	;
	KBType			**&m_kbTypes	;

	QValueList<SQLSMALLINT>	m_dbTypes	; /* Database types	*/
	QValueList<SQLSMALLINT>	m_cTypes	; /* C types		*/
	QStringList		m_colNames	; /* Column names	*/

	inline	KBSQLTypeInfo
		(	KBDB2CLI	*kbServer,
			KBType		**&kbTypes
		)
		:
		m_kbServer	(kbServer),
		m_kbTypes	(kbTypes)
	{
	}

	bool	loadTypeInfo
		(	SQLHSTMT	,
			uint		,
			KBError		&
		)	;
}	;

/*  ------------------------------------------------------------------  */
/*									*/
/*  KBDB2CLIQrySelect							*/
/*  ----------------							*/
/*  Implementation class for select queries on the DB2 database		*/
/*									*/
/*  ------------------------------------------------------------------  */


class	KBDB2CLIQrySelect : public KBSQLSelect, KBSQLTypeInfo
{
	KBDB2CLI		*m_pServer	;
	SQLHSTMT		m_stmHandle	;
	int			m_CRow		; /* Current loaded row	*/

public:

	KBDB2CLIQrySelect (KBDB2CLI*, bool, const QString &) ;
	virtual~KBDB2CLIQrySelect () ;

	virtual	bool		execute		(uint, const KBValue*) ;
	virtual	KBValue		getField 	(uint, uint, KBValue::VTrans) ;
	virtual	QString		getFieldName	(uint) ;
	virtual bool 		rowExists	(uint, bool = true) ;
}	;

/*  ------------------------------------------------------------------  */
/*									*/
/*  KBDB2CLIQryUpdate							*/
/*  ----------------							*/
/*  Implementation class for update queries on the DB2 database		*/
/*									*/
/*  ------------------------------------------------------------------  */

class	KBDB2CLIQryUpdate : public KBSQLUpdate
{
	KBDB2CLI	*m_pServer	;
	SQLHSTMT	m_stmHandle	;

public:

	KBDB2CLIQryUpdate (KBDB2CLI *, bool, const QString &, const QString &) ;
	virtual~KBDB2CLIQryUpdate ()	;

	virtual	bool	execute	(uint, const KBValue *) ;
}	;

/*  ------------------------------------------------------------------  */
/*																		*/
/*  KBDB2CLIQryInsert													*/
/*  ----------------													*/
/*  Implementation class for insert queries on the MySQL database		*/
/*																		*/
/*  ------------------------------------------------------------------  */

class	KBDB2CLIQryInsert : public KBSQLInsert
{
	KBDB2CLI	*m_pServer		;
	SQLHSTMT	m_stmHandle		;
	SQLHSTMT	m_IdentityStmHandle	;

	QValueList<SQLSMALLINT>	m_paramTypes	;

	int		m_useIdentityCol	;
	KBValue		m_lastIdentity		;

	bool		getLastIdentity	()	;

public:

	KBDB2CLIQryInsert (KBDB2CLI*, bool, const QString &, const QString &) ;
	virtual~KBDB2CLIQryInsert () ;

	virtual	bool	execute		(uint, const KBValue *) ;
	virtual	bool	getNewKey	(const QString &, KBValue &, bool) ;
}	;

/*  ------------------------------------------------------------------  */
/*																		*/
/*  KBDB2CLIQryDelete													*/
/*  ----------------													*/
/*  Implementation class for delete queries on the MySQL database		*/
/*																		*/
/*  ------------------------------------------------------------------  */

class	KBDB2CLIQryDelete : public KBSQLDelete
{
	KBDB2CLI	*m_pServer	;
	SQLHSTMT	m_stmHandle	;

public:

	KBDB2CLIQryDelete (KBDB2CLI*, bool, const QString &, const QString &) ;
	virtual~KBDB2CLIQryDelete	() 	;

	virtual	bool	execute		(uint, const KBValue *) ;
}	;

/*  ------------------------------------------------------------------  */
/*																		*/
/*  KBDB2CLIQryCursor							*/
/*  ----------------							*/
/*  The KBDB2CLIQryCursor class is used for DB2CLI cursors		*/
/*																		*/
/*  ------------------------------------------------------------------  */

class	KBDB2CLIQryCursor : public KBSQLCursor, KBSQLTypeInfo
{
	KBDB2CLI		*m_pServer	;
	SQLHSTMT		m_stmHandle	;

public	:

	KBDB2CLIQryCursor (KBDB2CLI *, bool, const QString &, const QString &) ;
	virtual ~KBDB2CLIQryCursor ()	;

	virtual	bool	execute	(uint, const KBValue   *) ;
	virtual	bool	fetch	(uint, KBValue *, bool &) ;
	virtual	bool	close	()			  ;
}	;

/*  ------------------------------------------------------------------  */

#define	db2cliOK(rc) (SQL_SUCCEEDED(rc))

#define	UNIMPL(op)							\
	m_lError = KBError						\
		   (	KBError::Error,					\
			QString("Unimplemented: %1").arg(op),		\
			QString::null,					\
			__ERRLOCN					\
		   )	;

