#!/bin/sh

LIB=$LIB';c:\Program Files\HTML Help Workshop\lib'

clean=$1
debug=

(
	cd libs/tkwidgets
	echo Building libs/tkwidgets
	qmake -spec win32-icc tkwidgets${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

#(
#	cd libs/release
#	echo Building libs/release
#	qmake -spec win32-icc release${debug}.pro
#	nmake $clean || exit 1
#)	|| exit 1

(
	cd libs/tkkde
	echo Building libs/tkkde
	qmake -spec win32-icc tkkde${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd libs/el32
	echo Building libs/el32
	qmake -spec win32-icc el32${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd libs/common
	echo Building libs/common
	qmake  -spec win32-icc common${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd libs/kbase
	echo Building libs/kbase
	qmake  -spec win32-icc kbase${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd libs/kbase
	echo Building libs/kbase runtime
	qmake  -spec win32-icc -o MakefileRT kbaseRT${debug}.pro
	nmake -f MakefileRT $clean || exit 1
)	|| exit 1

(
	cd libs/wizard
	echo Building libs/wizard
	qmake  -spec win32-icc wizard${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd libs/app
	echo Building libs/app
	qmake  -spec win32-icc app${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd libs/app
	echo Building libs/app runtime
	qmake  -spec win32-icc -o MakefileRT appRT${debug}.pro
	nmake -f MakefileRT $clean || exit 1
)	|| exit 1

(
	cd libs/extra
	echo Building libs/extra
	qmake  -spec win32-icc extra${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd libs/extra
	echo Building libs/extra runtime
	qmake  -spec win32-icc -o MakefileRT extraRT${debug}.pro
	nmake -f MakefileRT $clean || exit 1
)	|| exit 1

(
	cd drivers/xbase
	echo Building xbase library
	qmake  -spec win32-icc xbase${debug}.pro
	echo Running nmake.... || exit 1
	nmake $clean || exit 1
)	|| exit 1

(
	cd drivers/xbsql
	echo Building xbsql wrapper
	qmake  -spec win32-icc xbsql${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd db/xbase
	echo Building xbase plug-in
	qmake  -spec win32-icc xbase${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd db/mysql
	echo Building mysql plug-in
	qmake  -spec win32-icc mysql${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd db/pgsql
	echo Building pgsql plug-in
	qmake  -spec win32-icc pgsql${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd db/odbc
	echo Building odbc plug-in
	qmake  -spec win32-icc odbc${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd parts/table2
	echo Building table part
	qmake  -spec win32-icc table${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd parts/table2
	echo Building runtime table part
	qmake  -spec win32-icc -o MakefileRT tableRT${debug}.pro
	nmake -f MakefileRT $clean || exit 1
)	|| exit 1

(
	cd parts/form
	echo Building form part
	qmake  -spec win32-icc form${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd parts/form
	echo Building runtime form part
	qmake  -spec win32-icc -o MakefileRT formRT${debug}.pro
	nmake -f MakefileRT $clean || exit 1
)	|| exit 1

(
	cd parts/report
	echo Building report part
	qmake  -spec win32-icc report${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd parts/report
	echo Building runtime report part
	qmake  -spec win32-icc -o MakefileRT reportRT${debug}.pro
	nmake -f MakefileRT $clean || exit 1
)	|| exit 1

(
	cd parts/editor
	echo Building editor part
	qmake  -spec win32-icc editor${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd parts/query
	echo Building query part
	qmake  -spec win32-icc query${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd parts/query
	echo Building runtime query part
	qmake  -spec win32-icc -o MakefileRT queryRT${debug}.pro
	nmake -f MakefileRT $clean || exit 1
)	|| exit 1

(
	cd parts/copier
	echo Building copier part
	qmake  -spec win32-icc copier${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd parts/component
	echo Building components part
	qmake  -spec win32-icc comp${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd parts/macro
	echo Building macro part
	qmake  -spec win32-icc macro${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	cd sip/siplib
	echo Building siplib
	qmake  -spec win32-icc siplib${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	echo Building kb_pystub
	cd script/python/stub
	qmake  -spec win32-icc stub${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	echo Building runtime kb_pystub
	cd script/python/stub
	qmake  -spec win32-icc -o MakefileRT stubRT${debug}.pro
	nmake -f MakefileRT $clean || exit 1
)	|| exit 1

(
	echo Building python scripting
	cd script/python/lib
	qmake  -spec win32-icc script${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	echo Building runtime python scripting
	cd script/python/lib
	qmake  -spec win32-icc -o MakefileRT scriptRT${debug}.pro
	nmake -f MakefileRT $clean || exit 1
)	|| exit 1

(
	echo Building executable
	cd kbase
	qmake  -spec win32-icc rekall${debug}.pro
	nmake $clean || exit 1
)	|| exit 1

(
	echo Building runtime executable
	cd kbase
	qmake  -spec win32-icc -o MakefileRT rekallRT${debug}.pro
	nmake -f MakefileRT $clean || exit 1
)	|| exit 1
