/***************************************************************************
    file	         : pybase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>

#include	"kb_python.h"


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_object.h"
#include	"kb_database.h"
#include	"kb_location.h"
#include	"kb_callback.h"

#include	"pybase.h"

extern	long		pyCookie	;

PyKBBase::PyKBBase
	(	long		_cookie,
		long		_ptr,
		const char	*_name
	)
{
	name	= _name	;

	if (_cookie != pyCookie)
	{
		PyErr_SetString
		(	PyExc_ValueError,
			"Invalid call to internal object constructor"
		)	;
		ptr	= 0 ;
		return	;
	}

	ptr	= (void *)_ptr	;
	inherit	= 0		;
}

bool	PyKBBase::isValid ()
{
	if (ptr == 0)
	{
		PyErr_SetString
		(	PyExc_ValueError,
			"Validity check failed on internal object"
		)	;
		return	false	;
	}

	return	true	;
}

cchar	*PyKBBase::decodeError
	(	const KBError	&error
	)
{
	static  QString	aQString ;
	const	QString	&details = error.getDetails() ;

	aQString = error.getMessage() ;

	if (!details.isEmpty())
	{	aQString += ": "    ;
		aQString += details ;
	}

	return	aQString ;
}

cchar	*PyKBBase::lastError
	(	KBSQLQuery	*query
	)
{
	return	query  == 0 ? "" : decodeError (query ->lastError()) ;
}

cchar	*PyKBBase::lastError
	(	KBObject	*object
	)
{
	return	object == 0 ? "" : decodeError (object->lastError()) ;
}

void	PyKBBase::super
	(	unsigned int	argc,
		KBValue		*argv
	)
{
	if (inherit == 0)
	{
		fprintf
		(	stderr,
			"PyKBBase::super: called with no inheritance\n"
		)	;
		return	;
	}

	KBValue	resval	;
	KBError	error	;
	inherit->doExecute (resval, argc, argv, error) ;
}
