#!/usr/bin/python

import	sys
import	string
import	re
import	xml.dom.minidom

from	xml.dom.ext.reader.Sax2	import FromXmlStream
from	xml.dom.ext.reader.Sax2	import FromXml
from	xml.xpath		import Evaluate
from	xml.dom.ext		import Print
from	xml.dom.ext		import PrettyPrint


doc	 = FromXmlStream (sys.stdin)

def myGetAttribute (node, name) :

    for a in node.attributes :
        if   a.name == name : return a.value

    return ""

methdict = {}
methlist = Evaluate ("/classes/class/method", doc)

for method in methlist :
    mname = myGetAttribute (method, "name")
    cname = myGetAttribute (method.parentNode, "name")
    if not methdict.has_key(mname) :
        methdict[mname] = []
    methdict[mname].append (method)

text	= "<?xml version='1.0'?>\n"
text	= text + '<dictionary>\n'

for methname in methdict.keys() :

    text = text + '  <attribute element="__PythonMethod" name="' + methname + '">\n'
    text = text + '    <description><![CDATA[\n'

    for method in methdict[methname] :

        retlist = method.getElementsByTagName("return")
        arglist = method.getElementsByTagName("arg")
        argcnt  = 0
        optcnt  = 0

        text = text + '      <nobr>'
        text = text + '<i>' + myGetAttribute(retlist[0], "type") + ' ' + myGetAttribute(method.parentNode, "name") + '</i>'
        text = text + '.' + methname + ' ('

        for arg in arglist :

            if argcnt > 0 : text = text + ' '

            if myGetAttribute (arg, "opt") == "Yes" :
                if argcnt > 0 :
                    text   = text + ' [, '
                    optcnt = optcnt + 1
                else :
                    text   = text + '['
            else :
                if argcnt > 1 :
                   text = text + ', '

            text = text +  '<i>' + myGetAttribute (arg, "type") + '</i>'
            text = text + ' <b>' + myGetAttribute (arg, "name") + '</b>'

            argcnt = argcnt + 1

        text = text + ')</nobr>\n'

    text = text + '    ]]></description>\n'
    text = text + '  </attribute>\n'

text	= text + '</dictionary>\n'

print	text
