/***************************************************************************
    file	         : tkc_pyfunclist.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_python.h"

#include	<qapp.h>

#include	"tkc_pydebugbase.h"
#include	"tkc_pyfunclist.h"

/*  TKCPyFuncList							*/
/*  TKCPyFuncList							*/
/*		: Constructor for debugger function list view		*/
/*  parent	: QWidget *	     : Parent widget			*/
/*  debug	: TKCPyDebugWidget * : Parent				*/
/*  (returns)	: TKCPyFuncList      :					*/

TKCPyFuncList::TKCPyFuncList
	(	QWidget		 *parent,
		TKCPyDebugWidget *debug
	)
	:
	TKCPyValueList (parent, debug)
{
}

/*  TKCPyFuncList							*/
/*  showObject	: Check whether to display object			*/
/*  pyObj	: PyObject *	: Object				*/
/*  (returns)	:		:					*/

bool	TKCPyFuncList::showObject
	(	PyObject	*pyObj
	)
{
	if (pyObj != 0)
		switch (TKCPyDebugBase::getPythonType(pyObj)->typeCode)
		{
			case TKCPyType::CFunction :
			case TKCPyType::Class	  :
			case TKCPyType::Dict	  :
			case TKCPyType::Function  :
			case TKCPyType::Instance  :
			case TKCPyType::Method	  :
			case TKCPyType::Module	  :
				return	true ;

			default	:
				break	;
		}

	return	false	;
}
