/***************************************************************************
    file	         : pyslot.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYSLOT_H
#define	__KB_PYSLOT_H

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"pybase.h"

class	PyKBSlot : public PyKBBase
{
public	:

	inline	PyKBSlot
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBBase (_cookie, _ptr, _name)
	{
	}

	inline	void	call
		(	KBObject	*caller,
			cchar		*event,
			unsigned int	argc,
			KBValue		*argv
		)
	{
		fprintf
		(	stderr,
			"PyKBSlot::call: v=%d c=%p argc=%d\n",
			isValid(),
			(void *)caller,
			argc
		)	;
		if (!isValid ()) return ;

		KB::ScriptRC rc = KB::ScriptOK ;
		((KBSlot *)ptr)->eventSignal
				 (	caller,
				 	event,
				 	argc,
				 	argv,
				 	rc
				 )	;
	}
}	;

#endif	// __KB_PYSLOT_H
