/***************************************************************************
    file	         : kb_filterdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>


#include	"kb_classes.h"
#include	"kb_tableinfo.h"

#include	"tk_messagebox.h"

#ifndef		_WIN32
#include	"kb_filterdlg.moc"
#else
#include	"kb_filterdlg.h"
#endif

#include	"kb_tablefilterdlg.h"


/*  KBFilterDlg								*/
/*  KBFilterDlg	: Constructor for outer filter dialog			*/
/*  tableSpec	: KBTableSpec & : Table specification			*/
/*  tableInfo	: KBTableInfo *	: Current table information		*/
/*  (returns)	: KBFilterDlg	:					*/

KBFilterDlg::KBFilterDlg
	(	KBTableSpec	&tableSpec,
		KBTableInfo	*tableInfo
	)
	:
	_KBDialog (TR("Filtering"), true),

	m_sortGroup	(1, Qt::Vertical, TR("Sorting"), this),
	m_selectGroup	(1, Qt::Vertical, TR("Select" ), this),
	m_viewGroup	(1, Qt::Vertical, TR("Columns"), this),

	m_sortNames	(&m_sortGroup   ),
	m_sortWidget	(&m_sortGroup   ),

	m_selectNames	(&m_selectGroup ),
	m_selectWidget	(&m_selectGroup ),

	m_viewNames	(&m_viewGroup   ),
	m_viewWidget	(&m_viewGroup   ),

	m_sortEdit	(&m_sortWidget  ),
	m_sortNew	(&m_sortWidget  ),
	m_sortDelete	(&m_sortWidget  ),

	m_selectEdit	(&m_selectWidget),
	m_selectNew	(&m_selectWidget),
	m_selectDelete	(&m_selectWidget),

	m_viewEdit	(&m_viewWidget  ),
	m_viewNew	(&m_viewWidget  ),
	m_viewDelete	(&m_viewWidget  ),

#if	! __KB_EMBEDDED
	m_bClose	(this),
#endif
	m_tableSpec	(tableSpec),
	m_tableInfo	(tableInfo)
{
	QVBoxLayout	*layMain   = new QVBoxLayout (this) ;

	layMain->addWidget (&m_sortGroup  ) ;
	layMain->addWidget (&m_selectGroup) ;
	layMain->addWidget (&m_viewGroup  ) ;
#if	! __KB_EMBEDDED
	layMain->addWidget (&m_bClose     ) ;
#endif
	QVBoxLayout *laySortButt   = new QVBoxLayout (&m_sortWidget) ;
	laySortButt  ->addWidget (&m_sortEdit  ) ;
	laySortButt  ->addWidget (&m_sortNew   ) ;
	laySortButt  ->addWidget (&m_sortDelete) ;

	QVBoxLayout *laySelectButt = new QVBoxLayout (&m_selectWidget) ;
	laySelectButt->addWidget (&m_selectEdit  ) ;
	laySelectButt->addWidget (&m_selectNew   ) ;
	laySelectButt->addWidget (&m_selectDelete) ;

	QVBoxLayout *layViewButt   = new QVBoxLayout (&m_viewWidget) ;
	layViewButt  ->addWidget (&m_viewEdit  ) ;
	layViewButt  ->addWidget (&m_viewNew   ) ;
	layViewButt  ->addWidget (&m_viewDelete) ;

	m_sortEdit    .setText (TR("Edit"  )) ;
	m_sortNew     .setText (TR("New"   )) ;
	m_sortDelete  .setText (TR("Delete")) ;

	m_selectEdit  .setText (TR("Edit"  )) ;
	m_selectNew   .setText (TR("New"   )) ;
	m_selectDelete.setText (TR("Delete")) ;

	m_viewEdit    .setText (TR("Edit"  )) ;
	m_viewNew     .setText (TR("New"   )) ;
	m_viewDelete  .setText (TR("Delete")) ;

#if	! __KB_EMBEDDED
	m_bClose      .setText (TR("Close" )) ;
#endif
	loadSortList	() ;
	loadSelectList	() ;
	loadViewList	() ;

	connect	(&m_sortEdit,     SIGNAL(clicked()), SLOT(slotEditSort    ())) ;
	connect	(&m_sortNew,      SIGNAL(clicked()), SLOT(slotNewSort     ())) ;
	connect	(&m_sortDelete,   SIGNAL(clicked()), SLOT(slotDeleteSort  ())) ;

	connect	(&m_selectEdit,   SIGNAL(clicked()), SLOT(slotEditSelect  ())) ;
	connect	(&m_selectNew,    SIGNAL(clicked()), SLOT(slotNewSelect   ())) ;
	connect	(&m_selectDelete, SIGNAL(clicked()), SLOT(slotDeleteSelect())) ;

	connect	(&m_viewEdit,	  SIGNAL(clicked()), SLOT(slotEditView    ())) ;
	connect	(&m_viewNew,	  SIGNAL(clicked()), SLOT(slotNewView     ())) ;
	connect	(&m_viewDelete,   SIGNAL(clicked()), SLOT(slotDeleteView  ())) ;

#if	! __KB_EMBEDDED
	connect	(&m_bClose,	  SIGNAL(clicked()), SLOT(slotClickClose  ())) ;
#endif

	connect
	(	&m_sortNames,
		SIGNAL(highlighted  (int)), 
		SLOT  (slotHiliteSort  ())
	)	;
	connect
	(	&m_sortNames,
		SIGNAL(doubleClicked   (QListBoxItem *)),
		SLOT  (slotEditSort    ())
	)	;

	connect
	(	&m_selectNames,
		SIGNAL(highlighted  (int)), 
		SLOT  (slotHiliteSelect())
	)	;
	connect
	(	&m_selectNames,
		SIGNAL(doubleClicked   (QListBoxItem *)),
		SLOT  (slotEditSelect  ())
	)	;

	connect
	(	&m_viewNames,
		SIGNAL(highlighted  (int)), 
		SLOT  (slotHiliteView  ())
	)	;
	connect
	(	&m_viewNames,
		SIGNAL(doubleClicked   (QListBoxItem *)),
		SLOT  (slotEditView    ())
	)	;


	if (m_sortNames  .count() == 0)
	{	m_sortEdit    .setEnabled (false) ;
		m_sortDelete  .setEnabled (false) ;
	}
	else	m_sortNames   .setCurrentItem (0) ;

	if (m_selectNames.count() == 0)
	{
		m_selectEdit  .setEnabled (false) ;
		m_selectDelete.setEnabled (false) ;
	}
	else	 m_selectNames.setCurrentItem (0) ;

	if (m_viewNames  .count() == 0)
	{
		m_viewEdit    .setEnabled (false) ;
		m_viewDelete  .setEnabled (false) ;
	}
	else	m_viewNames  .setCurrentItem(0) ;

#if	__KB_EMBEDDED
	showMaximized   () ;
#else
	m_sortNames  .setMinimumWidth (200) ;
	m_selectNames.setMinimumWidth (200) ;
	m_viewNames  .setMinimumWidth (200) ;
#endif
}

/*  KBFilterDlg								*/
/*  loadSortList: Load list of sort filter names			*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::loadSortList ()
{
	QStringList sortList ;
	m_tableInfo->sortList (sortList) ;

	m_sortNames  .clear () ;
	m_sortNames  .insertStringList (sortList  ) ;
}

/*  KBFilterDlg								*/
/*  loadSelectList							*/
/*		: Load list of filter (select) filter names		*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::loadSelectList ()
{
	QStringList selectList ;
	m_tableInfo->selectList (selectList) ;

	m_selectNames.clear () ;
	m_selectNames.insertStringList (selectList) ;
}

/*  KBFilterDlg								*/
/*  loadViewList: Load list of view filter names			*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::loadViewList ()
{
	QStringList viewList ;
	m_tableInfo->viewList (viewList) ;

	m_viewNames  .clear () ;
	m_viewNames  .insertStringList (viewList  ) ;
}

/*  KBFilterDlg								*/
/*  slotEditSort: Edit selected sort filter				*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotEditSort ()
{
	int idx = m_sortNames.currentItem() ;
	if (idx < 0) return ;

	KBTableSort *sort = m_tableInfo->getSort(m_sortNames.currentText()) ;
	if (sort == 0) return ;

	KBTableSortDlg	tsDlg (m_tableSpec, m_tableInfo, sort) ;

	if (tsDlg.exec ())
	{
		loadSortList () ;
		m_tableInfo->setChanged () ;
	}
}

/*  KBFilterDlg								*/
/*  slotEditSelect							*/
/*		: Edit selected select filter				*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotEditSelect ()
{
	int idx = m_selectNames.currentItem() ;
	if (idx < 0) return ;

	KBTableSelect *select = m_tableInfo->getSelect(m_selectNames.currentText()) ;
	if (select == 0) return ;

	KBTableSelectDlg tsDlg (m_tableSpec, m_tableInfo, select) ;

	if (tsDlg.exec ())
	{
		loadSelectList () ;
		m_tableInfo->setChanged () ;
	}
}

/*  KBFilterDlg								*/
/*  slotEditView: Edit selected view filter				*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotEditView ()
{
	int idx = m_viewNames.currentItem() ;
	if (idx < 0) return ;

	KBTableView *view = m_tableInfo->getView(m_viewNames.currentText()) ;
	if (view == 0) return ;

	KBTableViewDlg tsDlg (m_tableSpec, m_tableInfo, view) ;

	if (tsDlg.exec ())
	{
		loadViewList () ;
		m_tableInfo->setChanged () ;
	}
}

/*  KBFilterDlg								*/
/*  slotNewSort	: Add a new sort filter					*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotNewSort ()
{
	KBTableSort	*sort = 0 ;
	KBTableSortDlg	tsDlg (m_tableSpec, m_tableInfo, sort) ;

	if (tsDlg.exec ())
	{
		loadSortList () ;
		m_tableInfo->setChanged () ;
	}
}

/*  KBFilterDlg								*/
/*  slotNewSelect							*/
/*		: Add a new select filter				*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotNewSelect ()
{
	KBTableSelect    *select = 0 ;
	KBTableSelectDlg tsDlg   (m_tableSpec, m_tableInfo, select) ;

	if (tsDlg.exec ())
	{
		loadSelectList () ;
		m_tableInfo->setChanged () ;
	}
}

/*  KBFilterDlg								*/
/*  slotNewView	: Add a new view filter					*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotNewView ()
{
	KBTableView	*view = 0 ;
	KBTableViewDlg	tsDlg (m_tableSpec, m_tableInfo, view) ;

	if (tsDlg.exec ())
	{
		loadViewList () ;
		m_tableInfo->setChanged () ;
	}
}

/*  KBFilterDlg								*/
/*  slotDeleteSort							*/
/*		: Delete a sort filter					*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotDeleteSort ()
{
	int	idx	= m_sortNames.currentItem() ;
	if (idx < 0) return ;

	QString	name	= m_sortNames.currentText() ;
	if (TKMessageBox::questionYesNo
		(	0,
			QString(TR("Definitely delete %1")).arg(name),
			TR("Delete sort")
		) != TKMessageBox::Yes)
		return	;

	m_tableInfo->dropSort  (name) ;
	m_sortNames.removeItem (idx ) ;

	m_sortEdit    .setEnabled (m_sortNames.currentItem() > 0) ;
	m_sortDelete  .setEnabled (m_sortNames.currentItem() > 0) ;
}

/*  KBFilterDlg								*/
/*  slotDeleteSelect							*/
/*		: Delete a select filter				*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotDeleteSelect ()
{
	int	idx	= m_selectNames.currentItem() ;
	if (idx < 0) return ;

	QString	name	= m_selectNames.currentText() ;
	if (TKMessageBox::questionYesNo
		(	0,
			QString(TR("Definitely delete %1")).arg(name),
			TR("Delete filter")
		) != TKMessageBox::Yes)
		return	;

	m_tableInfo->dropSelect  (name) ;
	m_selectNames.removeItem (idx ) ;

	m_selectEdit    .setEnabled (m_selectNames.currentItem() > 0) ;
	m_selectDelete  .setEnabled (m_selectNames.currentItem() > 0) ;
}

/*  KBFilterDlg								*/
/*  slotDeleteView							*/
/*		: Delete a view filter					*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotDeleteView ()
{
	int	idx	= m_viewNames.currentItem() ;
	if (idx < 0) return ;

	QString	name	= m_viewNames.currentText() ;
	if (TKMessageBox::questionYesNo
		(	0,
			QString(TR("Definitely delete %1")).arg(name),
			TR("Delete view")
		) != TKMessageBox::Yes)
		return	;

	m_tableInfo->dropView  (name) ;
	m_viewNames.removeItem (idx ) ;

	m_viewEdit    .setEnabled (m_viewNames.currentItem() > 0) ;
	m_viewDelete  .setEnabled (m_viewNames.currentItem() > 0) ;
}

/*  KBFilterDlg								*/
/*  slotHiliteSort							*/
/*		: User hightlights a sort filter			*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotHiliteSort ()
{
	m_sortEdit    .setEnabled (true) ;
	m_sortDelete  .setEnabled (true) ;
}

/*  KBFilterDlg								*/
/*  slotHiliteSelect							*/
/*		: User hightlights a select filter			*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotHiliteSelect ()
{
	m_selectEdit  .setEnabled (true) ;
	m_selectDelete.setEnabled (true) ;
}

/*  KBFilterDlg								*/
/*  slotHiliteView							*/
/*		: User hightlights a view filter			*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotHiliteView ()
{
	m_viewEdit    .setEnabled (true) ;
	m_viewDelete  .setEnabled (true) ;
}

/*  KBFilterDlg								*/
/*  slotClickClose							*/
/*		: User clicks close button				*/
/*  (returns)	: void		:					*/

void	KBFilterDlg::slotClickClose ()
{
	done	(1) ;
}

