/***************************************************************************
    file	         : kb_reportlist.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include 	<qcursor.h>
#include 	<qpopupmenu.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_dbinfo.h"
#include	"kb_listitem.h"
#include	"kb_viewer.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"

#ifndef 	_WIN32
#include	"kb_reportlist.moc"
#else
#include	"kb_reportlist.h"
#endif

#include	"kb_reportviewer.h"

#if		! __KB_RUNTIME
#include	"kb_wizreport.h"
#endif


/*  KBReportList							*/
/*  KBReportList: Constructor for report list widget			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  dbInfo	: KBDBInfo *	: Database information object		*/
/*  (returns)	: KBReportList	:					*/

KBReportList::KBReportList
	(	QWidget		*parent,
		KBDBInfo	*dbInfo
	)
	:
	KBFileList
	(	parent,
		dbInfo,
		"Create new report",
		"report",
		"report",
		"Report name"
	)
{
	enableWizard () ;
}

/*  KBReportList							*/
/*  ~KBReportList: Destructor for report list widget			*/
/*  (returns)	 :		:					*/

KBReportList::~KBReportList ()
{
}

/*  KBReportList								*/
/*  showServerMenu : Show popup menu for server entries			*/
/*  (returns)	   : void	:					*/

void	KBReportList::showServerMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertSeparator () ;
	pop.insertItem (TR("&Reload report list"), this, SLOT(reloadServer())) ;
#if	! __KB_RUNTIME
	pop.insertItem (TR("&Copy to server ..."), this, SLOT(copyToServer())) ;
#endif
	pop.exec       (QCursor::pos()) ;
}

/*  KBFormList								*/
/*  showObjectMenu : Show popup menu for server entries			*/
/*  (returns)	   : void	:					*/

void	KBReportList::showObjectMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertItem (TR("&Data view"),     this, SLOT(showAsData  ())) ;
#if	! __KB_RUNTIME
	pop.insertItem (TR("D&esign view"),   this, SLOT(showAsDesign())) ;
#endif
#if	! __KB_EMBEDDED
	pop.insertItem (TR("&Print report"),  this, SLOT(reportView  ())) ;
#endif
#if	! __KB_RUNTIME
	pop.insertItem (TR("&Rename report"), this, SLOT(renameReport())) ;
	pop.insertItem (TR("De&lete report"), this, SLOT(deleteReport())) ;
	pop.insertItem (TR("&Save to file"),  this, SLOT(saveToFile  ())) ;
#endif
	pop.exec       (QCursor::pos()) ;
}

/*  KBReportList							*/
/*  printView	: Print report						*/
/*  (returns)	: void		:					*/

void	KBReportList::reportView ()
{
	showObjectAs (m_curItem, KB::ShowAsReport) ;
}

#if	! __KB_RUNTIME

/*  KBReportList								*/
/*  createByWizard							*/
/*		: Handle request to create object using a wizard	*/
/*  item	: KBListItem *	: Selected item				*/
/*  (returns)	: void		:					*/

void	KBReportList::createByWizard
	(	KBListItem	*item
	)
{
	QString		server	= item->parent()->text(0) ;
	KBLocation	dummy	(m_dbInfo, "report", server, "") ;

	KBWizardReport	wizReport (dummy, server) ;
	if (!wizReport.exec()) return ;

	KB::ShowAs	showAs	;
	QString		name	;
	QString		report	= wizReport.create (name, showAs) ;
	if (report.isEmpty ()) return ;

	KBError	   error	;
	KBLocation location	(m_dbInfo, "report", server, name) ;

	if (!location.save
		(	QString::null,
			QString::null,
			report,
			error
		))
	{
		error.DISPLAY()	;
		return	;	;
	}

	QDict<QString>	empty	 ;
	KBCallback	*cb	= KBAppPtr::getCallback() ;
	if (cb->openObject (location, showAs, empty, error) == KB::ShowRCError)
		error.DISPLAY () ;
}
#endif

/*  KBReportList							*/
/*  renameReport: Rename a report					*/
/*  (returns)	: void		:					*/

void	KBReportList::renameReport ()
{
	rename	(m_curItem) ;
}

/*  KBReportList							*/
/*  deleteReport: Delete a report					*/
/*  (returns)	: void		:					*/

void	KBReportList::deleteReport ()
{
	delobj	(m_curItem) ;
}
