/***************************************************************************
    file	         : kb_reportbase.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_REPORTBASE_H
#define	__KB_REPORTBASE_H

#include	"kb_libloader.h"
#include	"kb_objbase.h"
#include	"kb_report.h"

class KBReportViewer;

class	KBReportBase : public KBObjBase
{
	Q_OBJECT

	KBReport	*m_docRoot	;
	KBReportViewer	*m_viewer	;

private slots :

	void	widgetClosing () ;

public	:

	KBReportBase	(QObject *) ;
	virtual		~KBReportBase () ;

	virtual	bool		build
		(		KBLocation &,
				bool,
				KBError &
		) ;

	virtual	KB::ShowRC	show
		(		KB::ShowAs		,
				const QDict<QString>	&,
				QWidget 		*,
				KBError			&,
				const KBValue		& = KBValue(),
				QDict<QString>		* = 0
		) ;

	virtual QString		def		() ;

	KB::ShowRC		doPrintReport
		(		const QDict<QString>	&,
				const KBValue		&,
				KBWriter		*,
				int
		) ;
}	;

#ifndef	_WIN32
KBPARTFACTORY(KBReportFactory,"reportviewer")
#else

class KBReportFactory : public KBPartFactory
{
public:
	
	inline	KBReportFactory() : KBPartFactory ()
	{
	}
	virtual	QObject	*create(QObject* = 0, const char* = 0, const char* = 0, 
		const QStringList &	= QStringList());
	virtual	const char *ident	() ;
};

#endif

#endif	// __KB_REPORTBASE_H
