/***************************************************************************
    file	         : kb_formbuilder.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>

#include	<qstring.h>
#include	<qlist.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_attrdict.h"
#include	"kb_node.h"
#include	"kb_table.h"

#include	"kb_wizform.h"
#include	"kb_wizfields.h"
#include	"kb_builder.h"

#include	"kb_locator.h"
#include	"kb_component.h"
#include	"kb_config.h"



static	QString	fieldsSingleRow
	(	KBLocation			&location,
		KBTableInfo			*tabInfo,
		QList<KBFieldSpec>		&fields,
		uint				&width,
		uint				&height,
		KBBuildFieldInfo		&info
	)
{
	uint	x	= 0	;
	uint	y	= 0	;

	QString	text	;

	for (uint idx = 0 ; idx < fields.count() ; idx += 1)
	{
		KBFieldSpec	*fieldSpec = fields.at(idx)	;
		const QString	&fieldName = fieldSpec->m_name	;
		KBAttrDict	labelAttr  ;
		KBAttrDict	fieldAttr  ;
		int		w	   =  0 ;
		int		h	   = 20 ;

		labelAttr.addValue ("x",	x		) ;
		labelAttr.addValue ("y",	y		) ;
		labelAttr.addValue ("w",	100		) ;
		labelAttr.addValue ("h",	20		) ;
		labelAttr.addValue ("text",	fieldName	) ;
		text	+= labelAttr.print ("KBLabel", true, 4	) ;

		text	+= builderMakeField
			   (	location,
				tabInfo,
				fieldSpec,
				x + 100 + 20,
				y,
				w,
				h,
				idx + 1,
				4,
				info
			   )	;

		y	+= 30 ;

		if (x + 100 + 20 + w + 20 > width)
			width	= x + 100 + 20 + w + 20 ;
	}

	height	= y	;
	return	text	;
}

static	QString	fieldsMultipleRows
	(	KBLocation			&location,
		KBTableInfo			*tabInfo,
		QList<KBFieldSpec>		&fields,
		uint				&width,
		uint				&height,
		KBBuildFieldInfo		&info
	)
{
	uint	x	= 0	;
	uint	y	= 0	;

	QString	text	;

	for (uint idx = 0 ; idx < fields.count() ; idx += 1)
	{
		KBFieldSpec	*fieldSpec = fields.at(idx)	;
		const QString	&fieldName = fieldSpec->m_name	;
		KBAttrDict	labelAttr  ;
		KBAttrDict	fieldAttr  ;
		int		w	   = builderFieldWidth (fieldSpec) ;
		int		h	   = 20 ;

		labelAttr.addValue ("x",	x	 ) ;
		labelAttr.addValue ("y",	y	 ) ;
		labelAttr.addValue ("w",	w	 ) ;
		labelAttr.addValue ("h",	20	 ) ;
		labelAttr.addValue ("text",	fieldName) ;
		text	+= labelAttr.print ("KBLabel", true, 4) ;

		if ( (fieldSpec->m_typeIntl == KB::ITFixed) ||
		     (fieldSpec->m_typeIntl == KB::ITFloat) )
		{
			labelAttr.addValue ("align", Qt::AlignRight) ;
		}

		text	+= builderMakeField
			   (	location,
				tabInfo,
				fieldSpec,
				x,
				y + 30,
				w,
				h,
				idx + 1,
				4,
				info
			   )	;

		x += w + 20 ;
	}

	width	= x - 20 ;
	height	= y + 20 + 10 * 30 ;
	return	text	 ;
}

QString	addButton
	(	uint		&x,
		uint		&y,
		uint		&width,
		uint		&height,
		cchar		*name
	)
{
	QString	source	= locateFile
			  (	"appdata", 
				QString("stock/component/py/Buttons/%1.cmp").arg(name)
			  )	;

	if (source.isEmpty())
	{
		KBError::EError
		(	QString(TR("Cannot location '%1' button component")).arg(name),
			QString::null,
			__ERRLOCN
		)	;
		return	QString::null	;
	}

	QFile		file	(source) ;
	if (!file.open (IO_ReadOnly))
	{
		KBError::EError
		(	QString(TR("Cannot open '%1' button component")).arg(name),
			source,
			__ERRLOCN
		)	;
		return	QString::null	;
	}

	KBError		error	;
	QByteArray	xml	= file.readAll () ;
	if (xml.count() == 0)
	{
		KBError::EError
		(	QString(TR("'%1' button component is empty")).arg(name),
			source,
			__ERRLOCN
		)	;
		return	QString::null	;
	}

	KBLocation	locn	;
	KBComponent	*comp	= KBOpenComponentText (locn, xml, error) ;
	if (comp == 0)
	{
		error.DISPLAY()		;
		return	QString::null	;
	}

	QList<KBConfig>	configSet  	;
	uint		w	= 80	;
	uint		h	= 20	;

	comp ->findAllConfigs (configSet, QString::null) ;

	LITER
	(	KBConfig,
		configSet,
		config,

		QString	attr	= config->attrib() ;

		if	(attr == "x")
		{
			config->setValue (QString::number(x)) ;
		}
		else if (attr == "y")
		{
			config->setValue (QString::number(y)) ;
		}
		else if (attr == "w")
		{
			w	= config->value().toUInt() ;
		}
		else if (attr == "h")
		{
			h	= config->value().toUInt() ;
		}

		config->substitute (false) ;
		if (!config->user()) delete config ;
	)

	QString	text	;

	LITER
	(	KBNode,
		comp->getChildren(),
		node,

		node->printNode	(text, 4) ;
	)

	
	x	+= w	;
	if (x > width ) width  = x ;
	if (h > height) height = h ;

	delete	comp	;
	return	text	;
}

QString	addMoveButtons
	(	uint		&x,
		uint		&y,
		uint		&width,
		uint		&height
	)
{

	QString	text	;

	text	+= addButton (x, y, width, height, "First"   ) ;
	text	+= addButton (x, y, width, height, "Previous") ;
	text	+= addButton (x, y, width, height, "Next"    ) ;
	text	+= addButton (x, y, width, height, "Last"    ) ;

	return	text	;
}

QString	addUpdateButtons
	(	uint		&x,
		uint		&y,
		uint		&width,
		uint		&height
	)
{
	QString	text	;

	text	+= addButton (x, y, width, height, "Add"     ) ;
	text	+= addButton (x, y, width, height, "Save"    ) ;
	text	+= addButton (x, y, width, height, "Delete"  ) ;

	return	text	;
}

QString	kbFormBuilder
	(	KBLocation			&location,
		bool				preview,
		KBWizardForm			&wizard
	)
{
	QString		formText	;
	QString		fieldText	;
	QString		buttonText	;
	QString		queryTag	= "KBQryNull"	;
	uint		fldWidth	= 0 ;
	uint		fldHeight	= 0 ;
	uint		btnWidth	= 0 ;
	uint		btnHeight	= 0 ;
	uint		btnX		= 0 ;
	uint		btnY		= 0 ;
	KBTableInfo	*tabInfo	= 0 ;

	bool		oneRow		= wizard.layout	   () == 0 ;
	int		scroll		= wizard.scroll	   () ;
	QString		sourceName	= wizard.sourceName() ;

	QList<KBFieldSpec>	fieldList	;
	wizard.fieldList (fieldList)		;

	KBBuildFieldInfo	info		;
	info.setFromWizard (wizard)		;

	static	cchar	*showBar[]	=
	{	"No",
		"Yes",
		"Scrollbar",
		"MiniNav"
	}	;

	if (wizard.sourceType() == KBWizardCtrlDataSource::Table)
		tabInfo = location.dbInfo->findTableInfo
				(	location.docLocn,
					sourceName
				)	;

	if (oneRow)
		fieldText = fieldsSingleRow	(location, tabInfo, fieldList, fldWidth, fldHeight, info) ;
	else	fieldText = fieldsMultipleRows	(location, tabInfo, fieldList, fldWidth, fldHeight, info) ;

	if (wizard.move  ())
	{
		buttonText += addMoveButtons	(btnX, btnY, btnWidth, btnHeight) ;
	}
	if (wizard.update())
	{
		buttonText += addUpdateButtons	(btnX, btnY, btnWidth, btnHeight) ;
	}

	KBAttrDict	formAttr	;
	KBAttrDict	fldContAttr	;
	KBAttrDict	btnContAttr	;
	KBAttrDict	queryAttr	;

	uint		extra_w	= 0	;
	uint		extra_h	= 0	;
	uint		bmargin	= 0	;

	extra_w	+= fldWidth > btnWidth ? fldWidth : btnWidth ;
	extra_h	+= fldHeight + btnHeight ;

	if ((scroll & NAV_SCROLL) != 0)
	{
		extra_w += 20 ;
	}
	if ((scroll & NAV_MINI  ) != 0)
	{
		extra_h += 40 ;
		bmargin	 = 40 ;
	}

	formAttr   .addValue	("w",		20 + extra_w) 	;
	formAttr   .addValue	("h",		30 + extra_h	) ;
	formAttr   .addValue	("rowcount",	oneRow ? 1 : 0	) ;

	fldContAttr.addValue	("x",		10		) ;
	fldContAttr.addValue	("y",		10		) ;
	fldContAttr.addValue	("w",		10		) ;
	fldContAttr.addValue	("h",		btnHeight + bmargin + 20) ;
	fldContAttr.addValue	("xmode",	KBObject::FMStretch) ;
	fldContAttr.addValue	("ymode",	KBObject::FMStretch) ;
	fldContAttr.addValue	("taborder",	1		) ;

	btnContAttr.addValue	("x",		10		) ;
	btnContAttr.addValue	("y",		btnHeight + bmargin + 10) ;
	btnContAttr.addValue	("w",		0		) ;
	btnContAttr.addValue	("h",		btnHeight	) ;
	btnContAttr.addValue	("xmode",	KBObject::FMStretch) ;
	btnContAttr.addValue	("ymode",	KBObject::FMFloat  ) ;

	formAttr   .addValue	("dx",		0	) ;
	formAttr   .addValue	("dy",		30	) ;
	formAttr   .addValue	("caption",	wizard.caption()) ;
	formAttr   .addValue	("autosync",	"Yes"	) ;
	formAttr   .addValue	("language",	"py"	) ;
	formAttr   .addValue	("stretch",	wizard.stretch() && !oneRow ? "Yes" : "No") ;
	formAttr   .addValue	("showbar",	showBar[scroll & 0x03]) ;

	if (!preview)
		switch (wizard.sourceType())
		{
			case KBWizardCtrlDataSource::Query :
				queryTag = "KBQryQuery"	;
				queryAttr.addValue	("query",	sourceName) ;
				break	;

			case KBWizardCtrlDataSource::Table :
				queryTag = "KBQryTable"	;
				queryAttr.addValue	("server",	"Self"	) ;
				queryAttr.addValue	("table",	sourceName) ;
				queryAttr.addValue	("primary",	""    	) ;
				queryAttr.addValue	("ptype",	(int)KBTable::Auto) ;
				break	;

			default	:
				break	;
		}


	formText += formAttr   .print ("KBForm", 	false) ;
	formText += queryAttr  .print (queryTag, 	true,  2) ;
	formText += fldContAttr.print ("KBContainer",	false, 2) ;
	formText += fieldText	;
	formText += "  </KBContainer>\n" ;
	formText += btnContAttr.print ("KBContainer",	false, 2) ;
	formText += buttonText	;
	formText += "  </KBContainer>\n" ;
	formText += "</KBForm>" ;

	return	formText	;
}
