/***************************************************************************
    file	         : kb_tablewidget.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_TABLEWIDGET_H
#define	__KB_TABLEWIDGET_H

#include	<qlayout.h>
#include	<qgroupbox.h>
#include	<qcombobox.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>

#include	"kb_copybase.h"
#include	"kb_copytable.h"
#include	"kb_fieldchooser.h"


/*  KBTableWidget							*/
/*  -------------							*/
/*  This is the copied widget which provides the user GUI interface to	*/
/*  the table copied object.						*/

class	KBTableWidget : public QWidget, public KBCopyTable
{
	Q_OBJECT

	QObject		*m_part		;

	bool		m_srce		;
	KBLocation	m_location	;

	QComboBox	m_cbServer	;
	QComboBox	m_cbTable	;

	QListBox	m_lbFields	;
	QListBox	m_lbSelect	;
	QPushButton	m_bAdd		;
	QPushButton	m_bAddAll	;
	QPushButton	m_bRemove	;
	QPushButton	m_bUp		;
	QPushButton	m_bDown		;

#if	! __KB_EMBEDDED
	QGroupBox	m_gbBottom	;
#endif
	QWidget		m_wBottom	;
	QLineEdit	*m_eWhere	;
	QLineEdit	*m_eOrder	;

	QLineEdit	*m_eExpr	;
	QPushButton	*m_bExpr	;
	QPushButton	*m_bAddAuto	;

	QComboBox	*m_cbOption	;
	QComboBox	*m_cbOptField	;

	KBFieldChooser	m_fldChooser	;

	void		saveall		() ;

signals	:

	void		changed		() ;

protected slots	:

	void		clickExpr	()	;
	void		optSelected	(int)	;
	void		selectChanged	(bool)	;
	void		slotAddAuto	()	;

public	:

	KBTableWidget	(QWidget *parent, QObject *, bool, KBLocation &) ;

	bool		valid		(KBError     &) ;
	void		def		(QDomElement &) ;
	bool		set		(QDomElement &, KBError &) ;
}	;
#endif	// __KB_TABLEWIDGET_H
