/***************************************************************************
    file	         : kb_copier.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_COPIER_H
#define  _KB_COPIER_H


#include	<qmultilineedit.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>
#include	<qsplitter.h>
#include	<qwidgetstack.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_dbinfo.h"
#include	"kb_gui.h"
#include	"kb_viewer.h"

#include	"kb_copyexec.h"
#include	"kb_copywidget.h"

class		KBParamSet	;

/*  KBCopier								*/
/*  --------								*/
/*  Basic script editor class						*/

class	KBCopier : public KBViewer
{
	Q_OBJECT

#if	__KB_EMBEDDED
	QWidgetStack		*m_mainWidget	;
#else
	QSplitter		*m_mainWidget	;
#endif
	KBCopyWidget		*m_srce		;
	KBCopyWidget		*m_dest		;
	
	KBaseGUI		*m_gui		;
	QSize			m_size		;
	QDict<KBParamSet>	m_params	;

protected slots :

	void			showSource	() ;
	void			showDestination	() ;

protected :

	virtual	void	displayMode (QString) {} ;

public	:

		 KBCopier (KBObjBase *, QWidget *) ;
	virtual	~KBCopier () ;

	virtual	bool		queryClose	() ;

	KB::ShowRC		startup		(QByteArray &, KB::ShowAs, KBError &) ;
	QString			def		() ;

public	slots	:

	virtual void		showAs		(KB::ShowAs) ;
	virtual	void		setParameters	() ;

	void			saveDocument	() ;
	void			saveDocumentAs	() ;
	bool			execute		() ;
	void			setChanged	() ;
}	;

#endif // _KB_COPIER_H
