/***************************************************************************
    file	         : kb_wizfont.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_font.h"

#ifndef		_WIN32
#include	"kb_wizfont.moc"
#else
#include	"kb_wizfont.h"
#endif

#include	"tk_config.h"
#include	"tk_fontdialog.h"


/*  KBWizardCtrlFont							*/
/*  KBWizardCtrlFont							*/
/*		: Constructor for font wizard control			*/
/*  page	: KBWizardPage *	: Parent wizard page		*/
/*  elem	: QDomElement &		: Definition element		*/

KBWizardCtrlFont::KBWizardCtrlFont
	(	KBWizardPage		*page,
		const QDomElement	&elem
	)
	:
	KBWizardCtrl	(page, elem.attribute("name")),
	m_type		(elem.attribute ("type"))
{
	QWidget		*cntr	= new QWidget     (page) ;
	QGridLayout	*layout	= new QGridLayout (cntr) ;
	QPushButton	*set	= new QPushButton (cntr) ;
	QPushButton	*clear	= new QPushButton (cntr) ;

	m_wizFont 		= new QLineEdit   (cntr) ;

	layout->setMargin  (0) ;
	layout->setSpacing (4) ;
	layout->addMultiCellWidget  (m_wizFont, 0, 0, 0, 1) ;
	layout->addWidget  	    (set,   1, 0) ;
	layout->addWidget  	    (clear, 1, 1) ;

	set   ->setText	   (TR("Set"  )) ;
	clear ->setText	   (TR("Clear")) ;

	m_wizFont->setReadOnly (true)  ;

	setWidget (cntr) ;

	connect
	(	set,
		SIGNAL(clicked	  ()),
		SLOT  (slotSetFont())
	)	;
	connect
	(	clear,
		SIGNAL(clicked	    ()),
		SLOT  (slotClearFont())
	)	;

	TKConfig *config = TKConfig::getConfig() ;
	config->setGroup ("Wizard Font")	 ;
	m_wizFont->setText(config->readEntry(m_type)) ;
}

KBWizardCtrlFont::~KBWizardCtrlFont ()
{
}

void	KBWizardCtrlFont::slotSetFont ()
{
	TKFontDialog  fDialog (0, TR("Font"), false, true) ;
	fDialog.setFont (KBFont::specToFont (m_wizFont->text())) ;

	if (fDialog.exec())
	{
		m_wizFont->setText (KBFont::fontToSpec (fDialog.font())) ;
		ctrlChanged() ;
	}
}

void	KBWizardCtrlFont::slotClearFont ()
{
	m_wizFont->setText (QString::null) ;
}

void	KBWizardCtrlFont::setValue
	(	const QString	&value
	)
{
	m_wizFont->setText (value) ;
}

/*  KBWizardCtrlDBType							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBWizardCtrlFont::value ()
{
	return	m_wizFont->text () ;
}

void	KBWizardCtrlFont::save
	(	int
	)
{
	TKConfig *config = TKConfig::getConfig() ;
	config->setGroup   ("Wizard Font")       ;
	config->writeEntry (m_type, m_wizFont->text()) ;
}

WIZARDCTRLREG(Font)
