/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#ifndef TKTEXTACTION_H
#define TKTEXTACTION_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#include <qstring.h>

#if QT_VERSION >= 300
#include <qptrstack.h>
#else
#include <qstack.h>
#define QPtrStack QStack
#endif

#include	"libtkwidgets_exports.h"

class LIBTKWIDGETS_API  TKEditorAction
{
public:
  enum ActionType {
    Replace,
    InsertLineBreak,
    RemoveLineBreak,
    MakeLine,
    RemoveLine,
    Fold
  };

  static TKEditorAction *replace(int line, int column, int length, const QString &);
  static TKEditorAction *insert(int line, int column, const QString &);
  static TKEditorAction *remove(int line, int column, int length);
  static TKEditorAction *makeLine(int line);
  static TKEditorAction *removeLine(int line);
  static TKEditorAction *insertLineBreak(int line, int column);
  static TKEditorAction *removeLineBreak(int line);
  static TKEditorAction *fold(int line);

  ActionType action;
  int line;
  int column;
  int length;
  QString text;

protected:
  TKEditorAction(ActionType, int line, int column=0, int length=0, const QString &text=QString::null);

public:
  ~TKEditorAction();
};

class LIBTKWIDGETS_API  TKEditorActionGroup
{
public:
  TKEditorActionGroup();
  ~TKEditorActionGroup();

  void setRedoCursor(int line, int column);
  void setUndoCursor(int line, int column);

  int undoLine;
  int undoColumn;
  int redoLine;
  int redoColumn;

  QPtrStack<TKEditorAction> *actions;
};

#endif
