/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#ifndef EDITORDIALOGS_H
#define EDITORDIALOGS_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#include <qwidget.h>

#include "libtkwidgets_exports.h"

class QComboBox;
class QGridLayout;
class QHBoxLayout;
class QPushButton;

class LIBTKWIDGETS_API FindReplaceDialog : public QWidget
{ 
	Q_OBJECT

public:

  FindReplaceDialog(QWidget *parent=0, const char *name=0);

  void prepareForFind();
  void prepareForReplace();
  void enableInSelection(bool);
  void exec();

  QString findText() const;
  QString replaceText() const;
  bool wholeWord() const;
  bool matchCase() const;
  bool inSelections() const;

signals:

  void find();
  void next();
  void replace();
  void replaceAll();
  void closeDialog();

private slots :

  void saveText();

private:

  QGridLayout *layout;

  QComboBox *findBox;
  QComboBox *replaceBox;

  QPushButton *bFind;
  QPushButton *bNext;
  QPushButton *bReplace;
  QPushButton *bReplaceAll;
  QPushButton *bWholeWord;
  QPushButton *bMatcgCase;
  QPushButton *bSelection;
  QPushButton *bClose;

};

#endif

