/***************************************************************************
    file	         : tk_toolbutton.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TK_TOOLBAR_H
#define	__TK_TOOLBAR_H

#include	<qwidget.h>
#include	<qlayout.h>

#include	<qtoolbar.h>
#include	<qtoolbutton.h>

#include "libtkkde_exports.h"

class LIBTKKDE_API TKToolBarButton : public QToolButton
{
	Q_OBJECT

	QPixmap		m_pmActive	;
	QPixmap		m_pmDisabled	;
	QPixmap		m_pmDefault	;
	bool		m_active	;
	bool		m_raised	;
	int		m_id		;

	void	init	(const QString &, const QString &) ;

signals	:

	void	clicked	(int)		;

protected :

	virtual	void	enterEvent	(QEvent   *) ;
	virtual	void	leaveEvent	(QEvent   *) ;
	virtual	void	drawButton	(QPainter *) ;

protected slots :

	void	slotClicked	()	;

public	:

	TKToolBarButton
	(	const QString	&iconName,
		const QString	&text,
		const QString	&group,
		QObject		*receiver,
		const char	*slot,
		QWidget 	*parent,
		const char 	*name = 0
	)	;

	TKToolBarButton
	(	const QString	&iconName,
		int		id,
		QWidget 	*parent,
		const char 	*name 		= 0,
		const QString	&text		= QString::null
	)	;

	virtual	void	setEnabled	(bool) ;
}	;
#endif	// __TK_TOOLBAR_H
