/***************************************************************************
    file	         : tk_part.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qapplication.h>

#ifndef 	_WIN32
#include	"tk_part.moc"
#else
#include	"tk_part.h"
#endif

/*  TKPartManager							*/
/*  TKPartManager: Constructor for simple part manager			*/
/*  parent	 : QWidget *	 : Parent widget			*/
/*  name	 : const char *	 : Out name				*/
/*  (returns)	 : TKPartManager :					*/

TKPartManager::TKPartManager
	(	QWidget		*parent,
		const char	*name
	)
	:
	QObject	(parent, name)
{
	m_topWidget  = parent	;
	m_activePart = 0	;
	qApp->installEventFilter (this) ;
}

void	TKPartManager::setActivePart
	(	TKPart		*part
	)
{
	if (part != m_activePart)
	{
		m_activePart = part ;
		emit	activePartChanged (part) ;
	}
}


void	TKPartManager::addPart
	(	TKPart		*part,
		bool		makeActive
	)
{
	m_partList.append (part) ;
	part->setManager  (this) ;
	connect	(part, SIGNAL(destroyed()), this, SLOT(partDestroyed())) ;

	if (makeActive)
	{	setActivePart (part) ;
		if (part->widget()) part->widget()->setFocus() ;
	}
}


void	TKPartManager::partDestroyed ()
{
	const TKPart *part = (const TKPart *)(sender()) ;
	m_partList.removeRef (part) ;
	if (part == m_activePart) m_activePart = 0 ;
}


TKPart	*TKPartManager::partForWidget
	(	QWidget		*widget
	)
{
	for (TKPart *part  = m_partList.first() ;
		     part != 0 ;
		     part  = m_partList.next ())
		if (part->widget() == widget)
			return	part	;

	return	0 ;
}

bool	TKPartManager::eventFilter
	(	QObject		*object,
		QEvent		*event
	)
{
	if ( (event->type() != QEvent::MouseButtonPress   ) &&
	     (event->type() != QEvent::MouseButtonDblClick) &&
	     (event->type() != QEvent::FocusIn) )
		return	false	;

	if (!object->isWidgetType())
		return	false	;

	QWidget	*widget = (QWidget *)(object) ;

	if (widget->topLevelWidget() != m_topWidget)
		return	false	;

	while (widget)
	{
		TKPart	*part	= partForWidget (widget) ;

		if (part != 0)
		{
//			fprintf (stderr, "Got part [%d] %d\n", part, event->type()) ;
			setActivePart (part) ;
			break	;
		}

		widget = widget->parentWidget () ;
	}

	return	false	;
}

/*  ------------------------------------------------------------------  */

TKPart::TKPart
	(	QObject		*parent,
		const char	*name
	)
	:
	QObject	(parent, name)
{
	m_widget	= 0 ;
	m_manager	= 0 ;
}

TKPart::~TKPart ()
{
	if (m_widget)
	{
		disconnect
		(	m_widget,
			SIGNAL(destroyed()),
			this,
			SLOT(slotWidgetDestroyed())
		)	;
		delete	m_widget ;
	}
}

void	TKPart::setWidget
	(	QWidget		*widget
	)
{
	m_widget	= widget ;
	connect (m_widget, SIGNAL(destroyed()), this, SLOT(slotWidgetDestroyed())) ;
}

void	TKPart::slotWidgetDestroyed ()
{
	m_widget = 0	;
	delete	 this	;
}
