/***************************************************************************
    file	         : kb_sorter.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"libkbase_exports.h"

class LIBKBASE_API	KBSorterItem
{
public	:

	QString		name	;
	void		*thing	;

	inline	KBSorterItem
		(	const QString	&name,
			void		*thing
		)
		:
		name	(name),
		thing	(thing)
	{
	}
}	;

template <class type> class LIBKBASE_API KBSorter : public QList<KBSorterItem>
{
protected :

	virtual	int	compareItems
		(	QCollection::Item	a,
			QCollection::Item	b
		)
	{
		return	((KBSorterItem *)a)->name.compare(((KBSorterItem *)b)->name) ;
	}

public	:

	inline	KBSorter ()
	{
		setAutoDelete (true) ;
	}

	inline	void	append
		(	const QString	&name,
			const type	*thing
		)
	{
		QList<KBSorterItem>::append (new KBSorterItem (name, (void *)thing)) ;
	}

	inline	type	*at
			(	uint	idx
			)
	{
		return	(type *)(QList<KBSorterItem>::at(idx)->thing) ;
	}
}	;
