/***************************************************************************
    file	         : kb_select.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_SELECT_H
#define	__KB_SELECT_H


#include	<qstring.h>
#include	<qstringlist.h>
#include	<qvaluelist.h>

#include	"libkbase_exports.h"


class	KBQryBase	;
class	KBQryLevel	;
class	KBTable		;

/*  The classes defined here are used to build up the components of a	*/
/*  select query, from which the query text can be generated. The	*/
/*  implementation includes knowledge of inner and outer join types. It	*/
/*  also contains a basic parser for SQL select queries.		*/


/*  KBSelectTable							*/
/*  -------------							*/
/*  Information about a table; its name, a possible alias, and a	*/
/*  possible join condition to another table in the query.		*/
 
class	KBSelectTable
{
public	:

	enum	JoinType
	{
		None,
		Inner,
		LeftOuter,
		RightOuter
	}	;

private	:

	QString		m_tabName	;
	QString		m_alias		;
	JoinType	m_joinType	;
	QString		m_joinExpr	;
	QString		m_primary	;

public	:

	KBSelectTable	()	;

	KBSelectTable
	(	const QString	&,
		const QString	&,
		const QString	& = QString::null
	)	;

	KBSelectTable
	(	const QString	&,
		const QString	&,
		JoinType,
		const QString	&,
		const QString	& = QString::null
	)	;

	KBSelectTable
	(	const QString	&,
		const QString	&,
		const QString	&,
		const QString	&,
		const QString	& = QString::null
	)	;

	void	print		()	;

	bool	hasOuterJoin 	()	;
	bool	hasInnerJoin 	()	;
	bool	hasAnyJoin 	()	;

	QString	joinType	()	;
	QString	joinExpr	(KBDBLink *) ;
	QString	tableText	(KBDBLink *) ;

	inline	const QString	tableName ()
	{
		return	m_tabName	;
	}

	KBTable	*makeTable	(KBNode	  *) ;
}	;


/*  KBSelectExpr							*/
/*  ------------							*/
/*  Contains an expression to be retrieved, comprising the expression	*/
/*  itself plus a possible column alias.				*/

class	KBSelectExpr
{
	QString		m_expr		;
	QString		m_alias		;

public	:

	KBSelectExpr	()	;

	KBSelectExpr
	(	const QString	&,
		const QString	& = QString::null
	)	;

	void	print		()	;

	QString	exprText	(KBDBLink *)	const ;

	inline	const QString	&expr  () const
	{
		return	m_expr	;
	}
	inline	const QString	&alias () const
	{
		return	m_alias	;
	}
}	;


/*  KBSelect								*/
/*  --------								*/
/*  Main select representation class. The class can generate the query	*/
/*  both as straight SQL and in rich-text format for display.		*/

class	LIBKBASE_API	KBSelect
{
	QValueList<KBSelectTable>	m_tableList	;
	QValueList<KBSelectExpr >	m_exprList	;
	QValueList<KBSelectExpr >	m_whereList	;
	QValueList<KBSelectExpr >	m_groupList	;
	QValueList<KBSelectExpr >	m_havingList	;
	QValueList<KBSelectExpr >	m_orderList	;
	bool				m_distinct	;
	bool				m_forUpdate	;

	uint				m_offset	;
	uint				m_limit		;

	uint				m_buffPtr	;
	QString				m_buffer	;
	QString				m_token		;
	QString				m_white		;

	KBError				m_error		;

	QString		mapExpression	(const QString &, KBDBLink *) ;

	void		setParseError	(const QString &) ;

	bool		nextToken	()	;
	bool		isKeyword	()	;
	QString		parseExpr	(bool, bool) ;
	void		parseExprList	(QValueList<KBSelectExpr>  &, cchar *, bool) ;
	bool		parseTableList	(KBDBLink *) ;

public	:

	KBSelect	() ;

	void	appendTable
	(	const QString	&,
		const QString	&
	)	;

	void	appendTable
	(	const QString	&,
		const QString	&,
		KBSelectTable::JoinType,
		const QString	&
	)	;

	void	appendTable
	(	const QString	&,
		const QString	&,
		const QString	&,
		const QString	&
	)	;

	void	appendExpr		(const QString &, const QString & = QString::null) ;
	void	appendWhere		(const QString &) ;
	void	appendGroup		(const QString &) ;
	void	appendHaving		(const QString &) ;
	void	appendOrder		(const QString &) ;

	inline	void	setDistinct
		(	bool	distinct
		)
	{
		m_distinct  = distinct	;
	}

	inline	void	setForUpdate
		(	bool	forUpdate
		)
	{
		m_forUpdate = forUpdate	;
	}

	inline	void	setLimit
		(	uint	limit,
			uint	offset
		)
	{
		m_limit	= limit	 ;
		m_offset= offset ;
	}


	inline	const KBError	&lastError ()
	{
		return	m_error	;
	}

	bool		parseQuery	(const QString &, KBDBLink * = 0) ;
	bool		parseExprList	(const QString &, KBDBLink * = 0) ;

	QString		getQueryText	(bool, bool, KBDBLink *) ;
	QString		getQueryText	(KBDBLink *) ;
	QString		getPrettyText	(bool, KBDBLink *) ;

	QString		getComment	()	;
	QStringList	tableList	()	;

	void		reset		()	;

	KBQryLevel	*makeQryLevel
			(	KBQryBase		*,
				KBDBLink		&,
				const QString		&,
				KBTable			*&
			)	;

	inline	const	QValueList<KBSelectExpr> &getExprList ()
	{
		return	m_exprList	;
	}

	inline	uint	limit		()	{ return m_limit ; }
	inline	uint	offset		()	{ return m_offset ; }

	static	bool	singleExpression(const QString &) ;
}	;


#endif	// __KB_SELECT_H
