/***************************************************************************
    file	         : kb_ruler.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qpainter.h>

#include	"kb_ruler.h"


#if	__KB_EMBEDDED
#define	RULER_W		16
#define	RULER_H		16
#else
#define	RULER_W		32
#define	RULER_H		24
#endif

#define	RULER_TICK_S	((RULER_H/4)  )
#define	RULER_TICK_L	((RULER_H/4)*3)

/*  KBRuler								*/
/*  KBRuler	: Constructor for report ruler class			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  horiz	: bool		: True for horizontal widget		*/
/*  (returns)	: KBRuler	:					*/

KBRuler::KBRuler
	(	QWidget		*parent,
		bool		horiz
	)
	:
	QWidget	(parent),
	horiz	(horiz)
{
	frame	= 0	;
	offset	= 0	;
	step	= 0.0	;
	ppmm	= 0.0	;
	frac	= 0	;

	if (horiz)
		setFixedHeight (RULER_H) ;
	else	setFixedWidth  (RULER_W) ;
}

/*  KBRuler								*/
/*  paintEvent	: Handle ruler paint event				*/
/*  e		: QPaintEvent *	: Paint event				*/
/*  (returns)	: void		:					*/

void	KBRuler::paintEvent
	(	QPaintEvent	*
	)
{
	QPainter p	;

	p.begin	(this)	;

	QSize	s	= size() ;
	int	fw	= p.fontMetrics().width ("999") ;
	int	labVal	= 0 ;

	if (horiz)
	{
		p.drawLine (frame, 0, frame, s.height() - 1) ;
		p.drawLine (frame, s.height() - 1, s.width() - frame - 1, s.height() - 1) ;

		if ((step > 0.0) && (ppmm >= 0.0))
			for (double posn = 0 - (double)offset / ppmm ; posn < (double)s.width() / ppmm ; posn += step)
			{
				if (posn + step < 0.0)
				{
					labVal	+= (int)lincr	;
					continue ;
				}

				p.drawLine
				(	frame + (int)(posn * ppmm),
					RULER_H - RULER_TICK_L,
					frame + (int)(posn * ppmm),
					s.height() - 1
				)	;
				p.drawText
				(	frame + (int)(posn * ppmm) + 4,
					0,
					fw,
					s.height(),
					Qt::AlignTop,
					QString("%1").arg(labVal)
				)	;

				labVal	+= (int)lincr	;

				if (frac <= 0) continue ;

				for (int f = 1 ; f < frac ; f += 1)
					p.drawLine
					(	frame + (int)((posn + (step / (double)frac) * f) * ppmm), 
						RULER_H - RULER_TICK_S,
						frame + (int)((posn + (step / (double)frac) * f) * ppmm), 
						s.height() - 1
					)	;
			}
	}
	else
	{
		p.drawLine (frame, 0, s.width() - 1, 0) ;
		p.drawLine (s.width() - 1, 0, s.height() - frame - 1, s.width() - 1) ;

		if ((step > 0.0) && (ppmm >= 0.0))
			for (double posn = 0 - (double)offset / ppmm ; posn < (double)s.height() / ppmm ; posn += step)
			{
				if (posn + step < 0.0) 
				{
					labVal	+= (int)lincr	;
					continue ;
				}

				p.drawLine
				(	RULER_W - RULER_TICK_L,
					frame + (int)(posn * ppmm),
					s.width () - 1,
					frame + (int)(posn * ppmm)
				)	;

				p.drawText
				(	0,
					frame + (int)(posn * ppmm) + 4,
					fw,
					s.height(),
					Qt::AlignTop,
					QString("%1").arg(labVal)
				)	;

				labVal	+= (int)lincr	;

				if (frac <= 0) continue ;

				for (int f = 1 ; f < frac ; f += 1)
					p.drawLine
					(	RULER_W - RULER_TICK_S,
						frame + (int)((posn + (step / (double)frac) * f) * ppmm),
						s.width () - 1,
						frame + (int)((posn + (step / (double)frac) * f) * ppmm) 
					)	;
			}
	}

	p.end	()	;
}

/*  KBRuler								*/
/*  setOffset	: Set ruler offset					*/
/*  _offset	: int		: New offset				*/
/*  (returns)	: void		:					*/

void	KBRuler::setOffset
	(	int	_offset
	)
{
	offset	= _offset ;
	update	()	   ;
}

/*  KBRuler								*/
/*  setFrame	: Set parent frame width				*/
/*  _frame	: int		: New frame width			*/
/*  (returns)	: void		:					*/

void	KBRuler::setFrame
	(	int	_frame
	)
{
	frame	= _frame  ;
	update	()	  ;
}

/*  KBRuler								*/
/*  setStep	: Set ruler stepping					*/
/*  _step	: double	: Main step interval			*/
/*  _ppmm	: double	: Pixels per millimeter			*/
/*  _frac	: int		: Number of fractions to mark		*/
/*  _lincr	: int		: Label increment			*/
/*  (returns)	: void		:					*/

void	KBRuler::setStep
	(	double	_step,
		double	_ppmm,
		int	_frac,
		int	_lincr
	)
{
	step	= _step  ;
	ppmm	= _ppmm	 ;
	frac	= _frac	 ;
	lincr	= _lincr ;
	update	()	 ;
}
