/***************************************************************************
    file	         : kb_richtext.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_RICHTEXT_H
#define	_KB_RICHTEXT_H

#include	"kb_classes.h"
#include	"kb_item.h"

#include	"libkbase_exports.h"

/*  KBRichText								*/
/*  -----------								*/
/*  This class is used to represent a rich text element in the XML	*/
/*  form description. Note that it may map onto more than one actual	*/
/*  control.								*/

class LIBKBASE_API	KBRichText : public KBItem
{
	KBAttrStr	fgcolor	;	/* Foreground (text) colour	*/
	KBAttrStr	bgcolor	;	/* Background colour		*/
	KBAttrStr	font	;	/* Report font			*/
	KBAttrBool	supress	;	/* Supress repeats		*/

	KBReport	*report	;	/* Embedding report		*/
	KBValue		lastVal	;	/* Last row value		*/

protected :

	virtual	KBControl	*makeCtrl	(uint)	;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	() ;
#endif

public	:

	KBRichText	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBRichText 	(KBNode  *, KBRichText *) ;
virtual~KBRichText	() ;

	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	KBValue		getReportValue	(bool) ;
}	;


#if	! __KB_RUNTIME
extern	LIBKBASE_API	bool	richTextPropDlg
			(	KBRichText	*,
				cchar		*,
				QList<KBAttr>	&
			)	;
#endif
#endif	// _KB_RICHTEXT_H
