/***************************************************************************
    file	         : kb_qrybase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>


#include	<qlist.h>
#include	<qstring.h>
#include	<qxml.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_attr.h"
#include	"kb_dbinfo.h"
#include	"kb_node.h"
#include	"kb_object.h"
#include	"kb_docroot.h"

#ifndef		_WIN32
#include	"kb_qrybase.moc"
#else
#include	"kb_qrybase.h"
#endif

#include	"kb_location.h"
#include	"kb_callback.h"
#include	"kb_appptr.h"


/*  KBQryBase								*/
/*  KBQryBase	: Query base class constructor				*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  name	: cchar *	: Actual element name			*/
/*  (returns)	: KBQryBase	:					*/

KBQryBase::KBQryBase
	(	KBNode			*parent,
		const QDict<QString>	&,
		cchar			*name
	)
	:
	KBNode	(parent, name)
{
}

/*  KBQryBase								*/
/*  KBQryBase	: Qyery base class constructor				*/
/*  parent	: KBNode *	: Parent node				*/
/*  name	: cchar *	: Actual element name			*/
/*  (returns)	: KBQryBase	:					*/

KBQryBase::KBQryBase
	(	KBNode		*parent,
		cchar		*name
	)
	:
	KBNode	(parent, name)
{
}

/*  KBQryBase								*/
/*  KBQryBase	: Qyery base class constructor				*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _query	: KBQryBase *	: Extant query				*/
/*  (returns)	: KBQryBase	:					*/

KBQryBase::KBQryBase
	(	KBNode		*_parent,
		KBQryBase	*_query
	)
	:
	KBNode	(_parent, _query)
{
}

/*  KBQryBase								*/
/*  ~KBQryBase	: Destructor for base query class			*/
/*  (returns)	:		:					*/

KBQryBase::~KBQryBase ()
{
}

/*  KBQryBase								*/
/*  linkServer	: Ensure we are linked to the server			*/
/*  server	: const QString & : Server name				*/
/*  (returns)	: void		  :					*/

bool	KBQryBase::linkServer
	(	const QString	&server
	)
{
	dbLink.disconnect () ;

	if (!dbLink.connect (getDocRoot()->getLocation(), server))
	{	setError (dbLink.lastError ()) ;
		return	 false ;
	}

	return	true ;
}

/*  KBQryBase								*/
/*  dropServer	: Drop connection to server				*/
/*  (returns)	: void		:					*/

void	KBQryBase::dropServer ()
{
	dbLink.disconnect () ;
}


/*  KBQryBase								*/
/*  getSQLText	: Return SQL text for query				*/
/*  qryLvl	: uint		: Query level				*/
/*  pretty	: bool		: Pretty format				*/
/*  (returns)	: QString	:					*/

QString	KBQryBase::getSQLText
	(	uint		,
		bool
	)
{
	return	""	;
}

/*  KBQryBase								*/
/*  getSQLReason: Get reason for query permissions			*/
/*  qryLvl	: uint		: Query level				*/
/*  (returns)	: QString	:					*/

QString	KBQryBase::getSQLReason
	(	uint
	)
{
	return	""	;
}
