/***************************************************************************
    file	         : kb_primarydlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_PRIMARY_H
#define	_KB_PRIMARY_H

#if	! __KB_RUNTIME

#include	<qlayout.h>
#include	<qlistbox.h>
#include	<qcombobox.h>
#include	<qcheckbox.h>
#include	<qpushbutton.h>
#include	<qlineedit.h>

#include	"libkbase_exports.h"

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_dialog.h"
#include	"kb_node.h"
#include	"kb_table.h"



/*  KBPrimaryDlg								*/
/*  -----------								*/
/*  This class contains the functionality needed to handle selection	*/
/*  of table primary (ie., unique) columns in a dialog box.		*/

class	LIBKBASE_API	KBPrimaryDlg : public QWidget
{
	Q_OBJECT

	KBTableSpec			&m_tabSpec	;
	QComboBox			m_mode		;
	QComboBox			m_singleColumn	;
	QListBox			m_multiColumns	;
	QLineEdit			m_expression	;

	QValueList<KBTable::UniqueType>	m_itemToType	;


	void		loadAllKeys	() ;
	void		loadPrimaryKey	() ;
	void		loadUniqueKeys	() ;
	void		loadMultiKeys	() ;

private slots :

	void		modeChanged	() ;

public	:

	KBPrimaryDlg	(QWidget *, KBTableSpec &, bool = false, bool = true) ;

	void			set		(const QString &, KBTable::UniqueType, const QString &) ;
	void			set		(QStringList   &, KBTable::UniqueType, const QString &) ;

	KBTable::UniqueType	retrieve	(QString &, QString &) ;
}	;


/*  KBQryPrimaryDlg							*/
/*  ---------------							*/
/*  This class is simply an OK/Cancel dialog wrapper round the		*/
/*  KBPrimaryDlg class, and is used to give the user the option to	*/
/*  specifu which column in a table should be treated as the key column	*/

class LIBKBASE_API	KBQryPrimaryDlg : public _KBDialog
{
	Q_OBJECT

	KBPrimaryDlg	m_primaryDlg	;
	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;

protected slots :

	void		clickOK		() ;
	void		clickCancel	() ;

public	:

	KBQryPrimaryDlg (KBTableSpec &, QStringList &, KBTable::UniqueType, const QString &) ;
       ~KBQryPrimaryDlg () ;

	inline	KBTable::UniqueType	retrieve
		(	QString		&columns,
			QString		&expr
		)
	{
		return	m_primaryDlg.retrieve (columns, expr) ;
	}

}	;


#endif
#endif	// _KB_PRIMARY_H
