/***************************************************************************
    file	         : kb_parsequery.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>


#include	<qstring.h>
#include	<qlist.h>
#include	<qxml.h>
#include	<qdict.h>

#include	"kb_node.h"
#include	"kb_location.h"

#include	"kb_dbinfo.h"
#include	"kb_query.h"
#include	"kb_nodereg.h"
#include	"kb_attrdict.h"
#include	"kb_parse.h"


static	uint 		pNodeFns	;
static	QDict<NodeSpec>	queryNodeDict	;



/*  KBQueryhandler							*/
/*  --------------							*/
/*  Handler for parsing queries.						*/

class LIBKBASE_API	KBQueryHandler : public KBSAXHandler
{
	KBQuery		*m_kbQuery	;	/* Root of parsed query	*/

public	:

	KBQueryHandler (KBLocation &, KBNode *) ;

	virtual	bool	startElement	(const QString &, const QString &, const QString &, const QXmlAttributes &) ;

	KBQuery	*parseFile (const QString &) ;
	KBQuery	*parseText (QByteArray	  &) ;
}	;


/*  ------------------------------------------------------------------  */

/*  KBQueryHandler							*/
/*  KBQueryHandler: Constructor for query parser			*/
/*  location	  : KBLocation &    : Location				*/
/*  parent	  : KBNode *	    : Initial parent			*/
/*  (returns)	  : KBQueryHandler  : Query parse handler		*/

KBQueryHandler::KBQueryHandler
	(	KBLocation	&location,
		KBNode		*parent
	)
	:
	KBSAXHandler ("query", location, parent)
{
	m_kbQuery	= 0 ;
}

/*  KBQueryHandler							*/
/*  startElement: Handle start of element				*/
/*  URI		: const QString &	: Namespace URI			*/
/*  localName	: const QString &	:				*/
/*  qName	: const QString &	: Element name			*/
/*  attribs	: const QXmlAttributes &: Attribute list		*/
/*  (returns)	: bool			:				*/

bool	KBQueryHandler::startElement
	(	const	QString		&,
		const	QString		&,
		const	QString		&qName,
		const	QXmlAttributes	&attribs
	)
{
	/* The QXmlAttributes are converted to a QDict<QString>		*/
	/* dictionary. This is done since by passing attributes in this	*/
	/* way, it is easy to construct queries on the fly.		*/
	QDict<QString>	aList	   ;
	aList.setAutoDelete (true) ;
	for (int idx = 0 ; idx < attribs.length() ; idx += 1)
		aList.insert (attribs.qName (idx), new QString (attribs.value(idx))) ;


	/* Check for the root of the query. This is a special case, as	*/
	/* we need to construct and note the query root node.		*/
	if (qName == "KBQuery")
	{
		m_kbTOS	= m_kbQuery = new KBQuery (aList) ;
		m_kbQuery->startParse () ; 
		return	true ;
	}

	if (m_kbTOS == 0)
	{
		setErrMessage (TR("Expected KBQuery element at top-most level, got %1"), qName) ;
		return	false ;
	}

	return	processNode (qName, aList, queryNodeDict) ;
}

/*  KBQueryHandler							*/
/*  parseFile	 : Parse query from file				*/
/*  document	 : const QString &: Query file name			*/
/*  (returns)	 : KBQuery *	  : Query root or null on error		*/

KBQuery	*KBQueryHandler::parseFile
	(	const QString	&document
	)
{
	/* All of the work is done by the base parse method, which	*/
	/* picks up on errors and empty documents.			*/
	if (!KBSAXHandler::parseFile (document)) return 0 ;

	return	m_kbQuery	;
}

/*  KBQueryHandler							*/
/*  parseText	 : Parse query from text string				*/
/*  document	 : QByteArray &	: Query text				*/
/*  (returns)	 : KBQuery *	: Query root or null on error		*/

KBQuery	*KBQueryHandler::parseText
	(	QByteArray	&document
	)
{
	/* All of the work is done by the base parse method, which	*/
	/* picks up on errors and empty documents.			*/
	if (!KBSAXHandler::parseText (document)) return 0 ;

	return	m_kbQuery ;
}



/*  QryLoadNodeFuncs							*/
/*		: Load new node definition functions			*/
/*  (returns)	: void		:					*/

static	void	QryLoadNodeFuncs ()
{
	pNodeFns = LoadNodeFuncs(pNodeFns, KF_QUERY, queryNodeDict) ;
}

/*  KBOpenQueryText							*/
/*		: Open a query document text				*/
/*  location	: KBLocation &	: Database location			*/
/*  document	: QByteArray &	: Query document text			*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: KBQuery	: Document root or null			*/

KBQuery	*KBOpenQueryText
	(	KBLocation	&location,
		QByteArray	&document,
		KBError		&pError
	)
{
	QryLoadNodeFuncs () ;

	/* Create and initialise the SAX parser and the document and	*/
	/* error handlers (which are actually one and the same.		*/
	KBQueryHandler  handler (location, 0)   ;
	KBQuery		*query	= handler.parseText (document) ;

	if (query == 0)
	{	pError	= handler.lastError () ;
		return	0 ;
	}

	return	query	;
}

