/***************************************************************************
    file	         : kb_options.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdlib.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"
#include	"kb_options.h"

#include	"tk_config.h"
#include	"tk_action.h"



#define	DEF_GRIDX		10
#define	DEF_GRIDY		10
#define	DEF_DEFDX		0
#define	DEF_DEFDY		20
#define	DEF_MARGIN		25
#define	DEF_DPI			0
#define	DEF_DESIGNINCHES	false

#define	DEF_MAXQUERIES		64
#define	DEF_MAXEVENTS		256
#define	DEF_MAXARGS		16
#define	DEF_MAXARGLEN		80

#if	__KB_EMBEDDED
#define	DEF_OPENLAST		true
#define	DEF_SPACE		0
#define	DEF_FORMW		240
#define	DEF_FORMH		280
#define	DEF_TABLESSMODAL	true
#define	DEF_FORMSMODAL		true
#define	DEF_REPORTSMODAL	true
#define	DEF_QUERIESMODAL	true
#define	DEF_SINGLEDBONLY	true
#else
#define	DEF_OPENLAST		false
#define	DEF_SPACE		20
#define	DEF_FORMW		500
#define	DEF_FORMH		400
#define	DEF_TABLESSMODAL	false
#define	DEF_FORMSMODAL		false
#define	DEF_REPORTSMODAL	false
#define	DEF_QUERIESMODAL	false
#define	DEF_SINGLEDBONLY	false
#endif


/*  There is but a single static instance of the KBOptions object, used	*/
/*  to collect all options into one place.				*/

static	KBOptions	kbOptions ;


/*  ------------------------------------------------------------------  */

/*  KBOptions								*/
/*  loadOptions	: Load options from configuration			*/
/*  (returns)	: void		:					*/

void	KBOptions::loadOptions ()
{
	TKConfig *config = TKConfig::getConfig () ;
	config->setGroup(KB_OPTIONS_GROUP) ;

	kbOptions.gridX		= config->readUnsignedNumEntry	("gridX",		DEF_GRIDX 	) ;
	kbOptions.gridY		= config->readUnsignedNumEntry	("gridY",		DEF_GRIDY 	) ;
	kbOptions.formW		= config->readUnsignedNumEntry	("formW",		DEF_FORMW 	) ;
	kbOptions.formH		= config->readUnsignedNumEntry	("formH",		DEF_FORMH 	) ;
	kbOptions.defDX		= config->readNumEntry		("defDX",		DEF_DEFDX 	) ;
	kbOptions.defDY		= config->readNumEntry		("defDY",		DEF_DEFDY 	) ;
	kbOptions.space		= config->readUnsignedNumEntry	("space",		DEF_SPACE 	) ;
	kbOptions.marginL	= config->readUnsignedNumEntry	("marginL",		DEF_MARGIN	) ;
	kbOptions.marginR	= config->readUnsignedNumEntry	("marginR",		DEF_MARGIN	) ;
	kbOptions.marginT	= config->readUnsignedNumEntry	("marginT",		DEF_MARGIN	) ;
	kbOptions.marginB	= config->readUnsignedNumEntry	("marginB",		DEF_MARGIN	) ;
	kbOptions.dpi		= config->readUnsignedNumEntry	("dpi",			DEF_DPI		) ;
	kbOptions.useMdi	= config->readBoolEntry		("usemdi",		false     	) ;
	kbOptions.singleDBOnly	= config->readBoolEntry		("singledbonly",	DEF_SINGLEDBONLY) ;
	kbOptions.openLast	= config->readBoolEntry		("openLast",		DEF_OPENLAST	) ;
	kbOptions.designInches	= config->readBoolEntry		("designInches",	DEF_DESIGNINCHES) ;
	kbOptions.tablesModal	= config->readBoolEntry		("tablesModal", 	DEF_TABLESSMODAL) ;
	kbOptions.formsModal	= config->readBoolEntry		("formsModal",  	DEF_FORMSMODAL  ) ;
	kbOptions.reportsModal	= config->readBoolEntry		("reportsModal",	DEF_REPORTSMODAL) ;
	kbOptions.queriesModal	= config->readBoolEntry		("queriesModal",	DEF_QUERIESMODAL) ;
	kbOptions.logMaxQueries	= config->readUnsignedNumEntry	("logMaxQueries",	DEF_MAXQUERIES	) ;
	kbOptions.logMaxEvents	= config->readUnsignedNumEntry	("logMaxEvents",	DEF_MAXEVENTS	) ;
	kbOptions.logMaxArgs	= config->readUnsignedNumEntry	("logMaxArgs",		DEF_MAXARGS	) ;
	kbOptions.logMaxArgLen	= config->readUnsignedNumEntry	("logMaxArgLen",	DEF_MAXARGLEN	) ;
	kbOptions.scriptFont	= config->readEntry		("scriptFont") ;

	kbOptions.scriptType	= (ScriptType)config->readNumEntry
				  (	"scriptType",
					ScriptTypeAlwaysScript
				  )	;

	kbOptions.macroDebug	= (MacroDebug  )config->readNumEntry ("macroDebug") ;
	kbOptions.verInsert	= (VerifyOption)config->readNumEntry ("verInsert" ) ;
	kbOptions.verUpdate	= (VerifyOption)config->readNumEntry ("verUpdate" ) ;
	kbOptions.verDelete	= (VerifyOption)config->readNumEntry ("verDelete" ) ;
	kbOptions.verMultiple	= config->readNumEntry ("verMulti" ) ;

}

/*  KBOptions								*/
/*  snappingOn	: Report whether snap-to-grid is enabled		*/
/*  (returns)	: bool		: True if enabled			*/

bool	KBOptions::snappingOn ()
{
	static	TKToggleAction *snap = 0 ;

	if (snap == 0)
		snap = (TKToggleAction *)
				KBAppPtr::getCallback()->globalAction("KB_snapEnable") ;

	return	snap == 0 ? false : snap->isChecked () ;
}

/*  KBOptions								*/
/*  getDlgMargin: Get dialog layout margin				*/
/*  (returns)	: int		: Margin				*/

int	KBOptions::getDlgMargin ()
{
#if	__KB_EMBEDDED
	return	0	;
#else
	return	4	;
#endif
}

/*  KBOptions								*/
/*  getDlgSpacing: Get dialog layout spacing				*/
/*  (returns)	 : int		: Spacing				*/

int	KBOptions::getDlgSpacing ()
{
#if	__KB_EMBEDDED
	return	0	;
#else
	return	4	;
#endif
}

void	KBOptions::loadFromXML
	(	QDomElement	&elem
	)
{
	kbOptions.gridX		= elem.attribute("gridX"	).toUInt() ;
	kbOptions.gridY		= elem.attribute("gridY"	).toUInt() ;
	kbOptions.formW		= elem.attribute("formW"	).toUInt() ;
	kbOptions.formH		= elem.attribute("formH"	).toUInt() ;
	kbOptions.defDX		= elem.attribute("defDX"	).toInt () ;
	kbOptions.defDY		= elem.attribute("defDY"	).toInt () ;
	kbOptions.space		= elem.attribute("space"	).toUInt() ;
	kbOptions.marginL	= elem.attribute("marginL"	).toUInt() ;
	kbOptions.marginR	= elem.attribute("marginR"	).toUInt() ;
	kbOptions.marginT	= elem.attribute("marginT"	).toUInt() ;
	kbOptions.marginB	= elem.attribute("marginB"	).toUInt() ;
	kbOptions.dpi		= elem.attribute("dpi"		).toUInt() ;
	kbOptions.useMdi	= elem.attribute("usemdi"	).toInt () ;
	kbOptions.singleDBOnly	= elem.attribute("singledbonly" ).toInt () ;
	kbOptions.openLast	= elem.attribute("openLast"     ).toInt () ;
	kbOptions.designInches	= elem.attribute("designInches" ).toInt () ;
	kbOptions.tablesModal	= elem.attribute("tablesModal"  ).toInt () ;
	kbOptions.formsModal	= elem.attribute("formsModal"   ).toInt () ;
	kbOptions.reportsModal	= elem.attribute("reportsModal" ).toInt () ;
	kbOptions.queriesModal	= elem.attribute("queriesModal" ).toInt () ;
	kbOptions.logMaxQueries	= elem.attribute("logMaxQueries").toUInt() ;
	kbOptions.logMaxEvents	= elem.attribute("logMaxEvents"	).toUInt() ;
	kbOptions.logMaxArgs	= elem.attribute("logMaxArgs"	).toUInt() ;
	kbOptions.logMaxArgLen	= elem.attribute("logMaxArgLen"	).toUInt() ;
	kbOptions.scriptFont	= elem.attribute("scriptFont"   ) ;

	kbOptions.scriptType	= (ScriptType  )elem.attribute("scriptType").toInt() ;
	kbOptions.macroDebug	= (MacroDebug  )elem.attribute("macroDebug").toInt() ;
	kbOptions.verInsert	= (VerifyOption)elem.attribute("verInsert" ).toInt() ;
	kbOptions.verUpdate	= (VerifyOption)elem.attribute("verUpdate" ).toInt() ;
	kbOptions.verDelete	= (VerifyOption)elem.attribute("verDelete" ).toInt() ;

	kbOptions.verMultiple	= elem.attribute("verMulti").toInt() ;
}

void	KBOptions::saveToXML
	(	QDomElement	&elem
	)
{
	elem.setAttribute("gridX",		kbOptions.gridX		 ) ;
	elem.setAttribute("gridY",		kbOptions.gridY		 ) ;
	elem.setAttribute("formW",		kbOptions.formW		 ) ;
	elem.setAttribute("formH",		kbOptions.formH		 ) ;
	elem.setAttribute("defDX",		kbOptions.defDX		 ) ;
	elem.setAttribute("defDY",		kbOptions.defDY		 ) ;
	elem.setAttribute("space",		kbOptions.space		 ) ;
	elem.setAttribute("marginL",		kbOptions.marginL	 ) ;
	elem.setAttribute("marginR",		kbOptions.marginR	 ) ;
	elem.setAttribute("marginT",		kbOptions.marginT	 ) ;
	elem.setAttribute("marginB",		kbOptions.marginB	 ) ;
	elem.setAttribute("dpi",		kbOptions.dpi		 ) ;
	elem.setAttribute("usemdi",		kbOptions.useMdi	 ) ;
	elem.setAttribute("singledbonly",	kbOptions.singleDBOnly	 ) ;
	elem.setAttribute("openLast",		kbOptions.openLast	 ) ;
	elem.setAttribute("designInches",	kbOptions.designInches	 ) ;
	elem.setAttribute("tablesModal",	kbOptions.tablesModal	 ) ;
	elem.setAttribute("formsModal",		kbOptions.formsModal	 ) ;
	elem.setAttribute("reportsModal",	kbOptions.reportsModal	 ) ;
	elem.setAttribute("queriesModal",	kbOptions.queriesModal	 ) ;
	elem.setAttribute("logMaxQueries",	kbOptions.logMaxQueries	 ) ;
	elem.setAttribute("logMaxEvents",	kbOptions.logMaxEvents	 ) ;
	elem.setAttribute("logMaxArgs",		kbOptions.logMaxArgs	 ) ;
	elem.setAttribute("logMaxArgLen",	kbOptions.logMaxArgLen	 ) ;
	elem.setAttribute("scriptFont",		kbOptions.scriptFont	 ) ;

	elem.setAttribute("scriptType",		(int)kbOptions.scriptType) ;
	elem.setAttribute("macroDebug",		(int)kbOptions.macroDebug) ;
	elem.setAttribute("verInsert",		(int)kbOptions.verInsert ) ;
	elem.setAttribute("verUpdate",		(int)kbOptions.verUpdate ) ;
	elem.setAttribute("verDelete",		(int)kbOptions.verDelete ) ;

	kbOptions.verMultiple	= elem.attribute("verMulti").toInt() ;
}




KBOptions &KBOptions::self()
{
	return	kbOptions ;
}

/*  The remainder of the code retrieves values. This is all pretty	*/
/*  samey, so define a macro and use that to generate the code.		*/

#define	GETVALUE(type,func,value)		\
	type	KBOptions::get##func ()		\
	{					\
		return	kbOptions.value	;	\
	}

GETVALUE(uint,		GridXStep,	gridX  		)
GETVALUE(uint,		GridYStep,	gridY  		)
GETVALUE(uint,		FormWidth,	formW  		)
GETVALUE(uint,		FormHeight,	formH  		)
GETVALUE(int,		DefaultDX,	defDX  		)
GETVALUE(int,		DefaultDY,	defDY  		)
GETVALUE(uint,		CtrlSpace,	space  		)

GETVALUE(bool,		UseMDI,		useMdi 		)
GETVALUE(bool,		SingleDBOnly,	singleDBOnly	)

GETVALUE(uint,		LeftMargin,	marginL		)
GETVALUE(uint,		RightMargin,	marginR		)
GETVALUE(uint,		TopMargin,	marginT		)
GETVALUE(uint,		BottomMargin,	marginB		)
GETVALUE(uint,		DPI,		dpi		)

GETVALUE(bool,		OpenLast,	openLast	)
GETVALUE(bool,		DesignInches,	designInches	)
GETVALUE(bool,		TablesModal,	tablesModal	)
GETVALUE(bool,		FormsModal,	formsModal	)
GETVALUE(bool,		ReportsModal,	reportsModal	)
GETVALUE(bool,		QueriesModal,	queriesModal	)

GETVALUE(uint,		LogMaxQueries,	logMaxQueries	)
GETVALUE(uint,		LogMaxEvents,	logMaxEvents	)
GETVALUE(uint,		LogMaxArgs,	logMaxArgs	)
GETVALUE(uint,		LogMaxArgLen,	logMaxArgLen	)

GETVALUE(KBOptions::ScriptType,		ScriptType,	scriptType	)
GETVALUE(KBOptions::MacroDebug,		MacroDebug,	macroDebug	)

GETVALUE(KBOptions::VerifyOption,	VerInsert,	verInsert	)
GETVALUE(KBOptions::VerifyOption,	VerUpdate,	verUpdate	)
GETVALUE(KBOptions::VerifyOption,	VerDelete,	verDelete	)
GETVALUE(bool,				VerMultiple,	verMultiple	)

GETVALUE(QString,	ScriptFont,	scriptFont	)
