/***************************************************************************
    file	         : kb_moduleitem.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_MODULEITEM_H
#define	__KB_MODULEITEM_H

#include	"libkbase_exports.h"

#include	<qlist.h>
#include	<qlayout.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"tk_lineedit.h"


/*  KBModuleItem							*/
/*  ------------							*/
/*  This is a wrapper round a list view item, used to store a pointer	*/
/*  at an associated KBModule object.					*/

class LIBKBASE_API	KBModuleItem : public QListBoxText
{
	KBModule	*module	;

protected :

	virtual	KBModule *makeModule (KBNode *, const QString &) = 0 ;

public	:

	KBModuleItem (QListBox *, KBModule 	*) ;
	KBModuleItem (QListBox *, const QString &) ;
        virtual ~KBModuleItem () ;

	inline	KBModule *getModule  () { return module ; }
	void	fixUp	 (KBNode *) ;
}	;

/*  KBModuleDlg								*/
/*  -----------								*/
/*  This dialog is used to edit lists of modules (scripts or imports).	*/
/*  It is extended in each case to implement the pure vurtual function	*/
/*  "makeModule" which creates the appropriate module type.		*/

class LIBKBASE_API	KBModuleDlg : public QWidget
{
	Q_OBJECT

	QHBoxLayout	hLayout	  ;
	QVBoxLayout	vLayout	  ;
	QHBoxLayout	bLayout	  ;
	QListBox	vModules  ;
	TKLineEdit	eModule	  ;
	QPushButton	bAdd	  ;
	QPushButton	bRemove	  ;

	KBNode		*node	  ;
	QList<KBModule>	dropped	  ;

protected :

	void			setModules	(QList<KBModule> &) ;

	virtual KBModuleItem	*makeModuleItem (QListBox *, KBModule 	   *) = 0 ;
	virtual KBModuleItem	*makeModuleItem (QListBox *, const QString &) = 0 ;

protected slots :

	void	clickAdd	()	;
	void	clickRemove	()	;
	void	highlighted	(int)	;

public	:

	KBModuleDlg (QWidget *, KBNode *) ;
	virtual ~KBModuleDlg	() ;

	void	fixUp		() ;
	QString	getText		() ;
}	;

#endif	// __KB_MODULEITEM_H
