/***************************************************************************
    file	         : kb_memo.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#ifndef 	_WIN32
#include	<sys/time.h>
#else
#include 	<time.h>
#endif

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qcursor.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_sizer.h"
#include	"kb_display.h"
#include	"kb_ctrl.h"
#include	"kb_formblock.h"
#include	"kb_memo.h"
#include	"kb_qtmemo.h"
#include	"kb_nodereg.h"
#include	"kb_writer.h"
#include	"kb_layout.h"
#include	"kb_font.h"

#include	"kb_locator.h"

#include	"kb_dialog.h"
#include	"tktextmanager.h"


/*  KBMemo								*/
/*  KBMemo	: Constructor for simple form field			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBMemo::KBMemo
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem	 	(parent, "KBMemo",	"expr",  	aList),
	fgcolor	 	(this,   "fgcolor",			aList),
	bgcolor	 	(this,   "bgcolor",			aList),
	frame	 	(this,	 "frame",			aList, KF_FORM),
	font	 	(this,	 "font",			aList),
	nullOK	 	(this,	 "nullok",			aList, KF_FORM),
	hilite	 	(this,	 "hilite",			aList, KF_FORM),
	wrap	 	(this,	 "wrap",			aList, KF_FORM),
	wrapChars	(this,	 "wrapchars",			aList, KF_FORM),
	m_emptyNull	(this,	 "emptynull",			aList, KF_FORM	),
	onChange 	(this,	 "onchange",	"onMemo",	aList, KF_FORM)
{
#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::memoPropDlg (this, "Memo", attribs))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}
#endif
	if (isReportDoc())
		report	= getParent()->getReport () ;
	else	report	= 0 ;
}

/*  KBMemo								*/
/*  KBMemo	: Constructor for simple form field			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _memo	: KBMemo *	: Extant memo				*/
/*  (returns)	: KBMemo	:					*/

KBMemo::KBMemo
	(	KBNode		*_parent,
		KBMemo		*_memo
	)
	:
	KBItem	 	(_parent,"expr",		  _memo),
	fgcolor	 	(this,   "fgcolor",		  _memo),
	bgcolor	 	(this,   "bgcolor",		  _memo),
	frame	 	(this,	 "frame",		  _memo),
	font	 	(this,	 "font",		  _memo),
	nullOK	 	(this,	 "nullok",		  _memo),
	hilite	 	(this,	 "hilite",		  _memo),
	wrap	 	(this,	 "wrap",		  _memo),
	wrapChars	(this,	 "wrapchars",		  _memo),
	m_emptyNull	(this,	 "emptynull",		  _memo, KF_FORM	),
	onChange 	(this,	 "onchange",	"onMemo", _memo)
{
	if (isReportDoc())
		report	= getParent()->getReport () ;
	else	report	= 0 ;
}

/*  KBMemo								*/
/*  ~KBMemo	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBMemo::~KBMemo ()
{
}

/*  KBMemo								*/
/*  makeCtrl	: Make a field control					*/
/*  drow	: uint		: Display row number			*/
/*  (returns)	: KBControl *	: New control				*/

KBControl
	*KBMemo::makeCtrl
	(	uint		drow
	)
{
	return	new KBCtrlMemo (getDisplay(), this, drow) ;
}

/*  KBMemo								*/
/*  doCheckValid: Check whether value can be saved in database		*/
/*  value	: const QString & : Putative value			*/
/*  allowNull	: bool		  : Ignore not-null check		*/
/*  (returns)	: bool		  : True if OK				*/

bool	KBMemo::doCheckValid
	(	const QString	&value,
		bool		allowNull
	)
{
	KBError	err	;

	if (!allowNull)
		if (value.isEmpty () && !nullOK.getBoolValue())
		{	
			setError
			(	KBError::Error,
			  	QString (TR("Memo %1 may not be empty")).arg(name.getValue()),
				QString::null,
			  	__ERRLOCN
			)	;
			return	false	;
		}

	/* If the value is not empty or we are doing not-null checks	*/
	/* then see if the value is OK to be saved to the database.	*/
	if (!value.isEmpty() || !allowNull)
		if (!type->isValid (value, err, name.getValue()))
		{
			setError (err) ;
			return	 false ;
		}

	return	true	;
}

/*  KBMemo								*/
/*  checkValid	: Check whether value can be saved in database		*/
/*  value	: const QString & : Putative value			*/
/*  allowNull	: bool		  : Ignore not-null check		*/
/*  (returns)	: bool		  : True if OK				*/

bool	KBMemo::checkValid
	(	const QString	&value,
		bool		allowNull
	)
{
	/* Special case. Ig the value is empty and empty values are to	*/
	/* be treated as null, then validate it as such.		*/
	if (value.isEmpty() && m_emptyNull.getBoolValue())
		return	doCheckValid (QString::null, allowNull) ;

	return	doCheckValid (value, allowNull) ;
}

/*  KBMemo								*/
/*  getValue	: Get value						*/
/*  qrow	: uint		: Query row				*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBMemo::getValue
	(	uint	qrow
	)
{
	/* Get the control for the specified row. If there isn't one	*/
	/* (outside the displayed range) then return a null.		*/
	KBControl *ctrl = ctrlAtQRow (qrow) ;
	if (ctrl == 0) return KBValue()	    ;

	/* Get the value. If this is empty and empty values are to be	*/
	/* treated as nulls then also return a null ...			*/
	KBValue	value	= ctrl->getValue()  ;
	if (value.dataLength() == 0)
		if (m_emptyNull.getBoolValue())
			return	KBValue()   ;

	/* ... otherwise use the value as-is.				*/
	return	value	;
}

/*  KBMemo								*/
/*  userChange	: Text changed						*/
/*  qrow	: uint		: Query row number			*/
/*  (returns)	: void		:					*/

void	KBMemo::userChange
	(	uint	qrow
	)
{
	KBValue	args[2]	;
	bool	evRc	;

	args[0] = (int)qrow		    ;
	args[1] = KBValue ()		    ;
	eventHook (onChange, 2, args, evRc) ;

	KBItem::userChange (qrow) ;
}

/*  KBMemo								*/
/*  replicate	: Replicate this field					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New field node			*/

KBNode	*KBMemo::replicate
	(	KBNode	*_parent
	)
{
	return	new KBMemo (_parent, this) ;
}


#if	! __KB_RUNTIME
/*  KBMemo								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success				*/

bool	KBMemo::propertyDlg
	(	cchar	*iniAttr
	)
{
	if (!::memoPropDlg (this, "Memo", attribs, iniAttr)) return false ;

	updateProps  ()	;
	return true     ;
}
#endif

NEWNODE(Memo, __TR("New &Memo"), KF_FORM|KF_REPORT|KF_BLOCK|KF_DATA)


/*  ------------------------------------------------------------------  */

/*  _KBDialog								*/
/*  getTextManager: Get text editor manager				*/
/*  (returns)	  : TKTextEditorManager					*/

/*  NOTE:								*/
/*  Temporary home but means that libkbase_common can be build for use	*/
/*  by the drivers without needing tkwidgets.				*/

TKTextEditorManager *_KBDialog::getTextManager
	(	QString		fontSpec,
		bool		showLines,
		bool		showSelect
	)
{
	static	QDict<TKTextEditorManager> managers ;
	TKTextEditorManager		   *manager ;

	if (fontSpec.isEmpty()) fontSpec = "/default" ;

	QString	key	= fontSpec ;
	key += showLines  ? "/lines"  : "/nolines"  ;
	key += showSelect ? "/select" : "/noselect" ;

	if ((manager = managers.find(key)) == 0)
	{
		QString	hldir	= locateDir
				  (	"appdata",
					"highlight/global/nohighlight"
				  )
				  + "highlight/"   ;

		manager = new TKTextEditorManager  ;

		manager->setResourcesDir	   (hldir) ;
		manager->setOverwriteMode	   (false) ;
		manager->setIndicatorMarginVisible (false) ;
		manager->setLinuNumberMarginVisible(showLines ) ;
		manager->setSelectionMarginVisible (showSelect) ;

		manager->setFont
		(	KBFont::specToFont(fontSpec)
		)	;

		managers.insert (key, manager) ;
	}

	return	manager	;
}


// void	timedMsg
// 	(	const QString	&message
// 	)
// {
// #ifndef	_WIN32
// 	struct	timeval	tv ;
// 	gettimeofday (&tv, 0) ;
// 	fprintf	     (stderr, "%09d.%06d: %s\n", tv.tv_sec, tv.tv_usec, (cchar *)message) ;
// #endif
// }
