/***************************************************************************
    file	         : kb_label.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB__LABEL_H
#define	_KB__LABEL_H


#include	"libkbase_exports.h"

#include	"kb_object.h"
#include	"kb_qtlabel.h"
#include	"kb_attralign.h"
#include	"kb_attrframe.h"



/*  KBLabel								*/
/*  -----------								*/
/*  This class is used for XML parse tree elements corresponding to	*/
/*  simple labeks.							*/

class	LIBKBASE_API	KBLabel : public KBObject
{
	Q_OBJECT

	KBAttrStr	text	;
	KBAttrStr	fgcolor	;
	KBAttrStr	bgcolor	;
	KBAttrFrame	frame	;	/* Frame style			*/
	KBAttrStr	font	;
	KBAttrAlign	align	;	/* Alignment			*/
	KBCtrlLabel	*label	;
	KBAttrStr	m_buddy	;

	KBReport	*report	;	/* Embedding report		*/

protected :

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	(cchar  *) ;
#endif

public	:

	KBLabel	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBLabel (KBNode  *, KBLabel *) ;
virtual~KBLabel	()		 ;

	virtual	void		updateProps	() ;
	virtual	void		buildCtrls	(uint, int, int ) ;
	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	void		showAs		(KB::ShowAs) ;
	virtual void		setPalette	() ;

	inline	void	setText
		(	const QString	&text
		)
	{
		label->setValue (KBValue (text, &_kbString)) ;
	}
	inline	int	getAlign  ()
	{
		return	align.getIntValue() ;
	}
}	;

#if	! __KB_RUNTIME
extern	LIBKBASE_API	bool labelPropDlg
			(	KBLabel		*,
				cchar		*,
				QList<KBAttr>	&,
				cchar		* = 0
			)	;
#endif
#endif	// _KB__LABEL_H
