/***************************************************************************
    file	         : kb_import.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_IMPORT_H
#define	_KB_IMPORT_H

#include	"libkbase_exports.h"

#include	<stdarg.h>

#include	<qlist.h>
#include	<qdict.h>

#include	"kb_module.h"
#include	"kb_moduleitem.h"
#include	"kb_location.h"


/*  KBImport								*/
/*  --------								*/

class LIBKBASE_API	KBImport : public KBModule
{
public	:

	KBImport	(KBNode *, const QDict<QString> &, bool * = 0) ;
	KBImport	(KBNode *, cchar    *) ;
	KBImport	(KBNode *, KBImport *) ;
virtual~KBImport	()		;

	virtual	KBImport	*isImport () { return this ; }

	virtual	KBNode		*replicate (KBNode *) ;
}	;


/*  KBImportItem							*/
/*  ------------							*/
/*  Wrapper class round KBModuleItem which manufactures KBImport	*/
/*  instances.								*/

class LIBKBASE_API	KBImportItem : public KBModuleItem
{
protected :

	virtual	KBModule *makeModule (KBNode *, const QString &) ;

public	:

	inline	KBImportItem
		(	QListBox	*listBox,
			KBImport	*import
		)
		:
		KBModuleItem (listBox, import)
	{
	}

	inline	KBImportItem
		(	QListBox	*listBox,
			const QString	&name
		)
		:
		KBModuleItem (listBox, name)
	{
	}

	virtual	~KBImportItem () ;
}	;

/*  KBImportDlg								*/
/*  -----------								*/
/*  This wraps the module dialog to implement the virtual methods that	*/
/*  instantiate module items (here as import items).			*/

class LIBKBASE_API	KBImportDlg : public KBModuleDlg
{
protected :

	virtual	KBModuleItem	*makeModuleItem (QListBox *, KBModule 	   *) ;
	virtual	KBModuleItem	*makeModuleItem (QListBox *, const QString &) ;

public	:

	KBImportDlg (QWidget *, KBNode *, QList<KBModule> &) ;
	virtual ~KBImportDlg () ;
}	;

#endif	// _KB_IMPORT_H
