/***************************************************************************
    file	         : kb_framer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_FRAMER_H
#define	_KB_FRAMER_H

#include	"libkbase_exports.h"

#include	"kb_block.h"
#include	"kb_navigator.h"


/*  KBFramer								*/
/*  --------								*/
/*  Class used to implement block headers and footers, plus tab widgets	*/
/*  and simple form containers. Basically, its a subdivision of a block	*/


class	LIBKBASE_API	KBFramer : public KBObject, public KBNavigator
{
	Q_OBJECT

	KBQryBase		*query		;
	uint			qryLvl		;
	uint			numRows		;
	KBBlockInfo		*blkInfo	;

	virtual void		setPalette  	()	;
	virtual void		setFont	    	()	;

#if	! __KB_RUNTIME
	virtual	KBPopupMenu	*makeNewPopup	(bool, QRect) ;
#endif

protected :

	KBAttrStr		bgcolor	    	;
	KBAttrStr		title		;
	KBAttrFrame		frame		;
	KBAttrBool		showbar		;
	KBAttrUInt		tabOrd  	;

	KBDisplay		*frmDisp	;

	QRect			newRect		;
	QPoint			insertAt	;
	Qt::ButtonState		bState		;

#if	! __KB_RUNTIME
	QRect			newCtrlRect	() 	;
	void			setCtrlRect	(QRect)	;
#endif

public	:

	KBFramer (KBNode *, const QDict<QString> &, cchar *, bool * = 0) ;
	KBFramer (KBNode *, KBFramer *) ;
	virtual	 ~KBFramer () ;

	virtual	KBFramer	*isFramer	() { return this    ; }
	virtual	KBNavigator	*isNavigator	() { return this    ; }
	virtual	KBDisplay	*getContainer	() { return frmDisp ; }

	virtual	void		remChild	(KBNode *) ;
	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	bool		write		(KBWriter *, QPoint, bool, int &) ;

#if	! __KB_RUNTIME
	virtual	void		designPopup	(QMouseEvent *, uint) ;
#endif
	virtual	QRect		getPosition	() ;

	virtual	void		move		(int, int) ;
	virtual	bool		resize		(int, int) ;
	virtual	void		buildDisplay	(KBDisplay *) ;
	virtual	void		buildCtrls	(uint, int, int) ;
	virtual	void		showAs		(KB::ShowAs) ;
	bool			writeData	() ;

	bool			doAction	(KB::Action) ;
	void			setQryLevel 	(uint, KBQryBase *) ;

	bool			anyChildBlock	() ;

	bool			changed		(uint) ;
	void			hideBelow	(uint) ;
	void			clearFields	(uint, bool) ;
	void			extendCtrls	(uint, int, int) ;

	virtual	void		setEnabled	(bool)	;
	virtual	void		setVisible	(bool)	;
	virtual bool		isEnabled	()	;
	virtual bool		isVisible	()	;

	uint			getNumRows	() ;
	uint			getCurQRow	() ;
	KBValue			getRowValue	(const QString &, uint) ;
	void			setRowValue	(const QString &, uint, const KBValue &) ;

	void			setRowMarked	(uint, uint) ;

	virtual	void		setTabOrder	(int)	;
	virtual	int		getTabOrder	()	;

	uint			rowsInFrame	(int, int) ;
	int			height		() ;
	virtual	bool		framerSetup	(KBQryBase *, uint, KBBlockInfo *) ;
	bool			addAllItems	() ;
	bool			showData	() ;

	void			getResults	(const QString &, QDict<QString> &) ;

#if	! __KB_RUNTIME
	virtual	bool		playerAdd	(const QStringList &, KBError &) ;
#endif

protected	:

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	() 	;
	virtual	void		updateProps	()	;
#endif

public	slots :

	virtual KBNode		*newNode	(int)	;
	virtual void		docPropDlg	()	;
	virtual	void		blockPropDlg	()	;
	virtual void		framerPropDlg	()	;

	virtual void		pasteObjects	()	;
	virtual void		pasteHere	()	;
	virtual void		pasteComponent	()	;
	virtual void		linkComponent	()	;

	void			newTabOrder	() 	;
	void			newNullBlock	() 	;
	void			newTableBlock	() 	;
	void			newQueryBlock	() 	;
	void			newSQLBlock	() 	;
	void			newContainer	() 	;
}	;


/*  KBHeader								*/
/*  --------								*/
/*  Block header, used in reports					*/

class	LIBKBASE_API	KBHeader : public KBFramer
{
	Q_OBJECT

public	:

	KBHeader (KBNode *, const QDict<QString> &, cchar *, bool * = 0) ;
	KBHeader (KBNode *, KBHeader *) ;
	virtual	 ~KBHeader () ;

	virtual	void		showAs		(KB::ShowAs) ;
	virtual	bool		resize		(int, int) ;
	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	KBHeader	*isHeader	() { return this ; }
	virtual	void		buildDisplay	(KBDisplay *) ;
}	;

/*  KBFooter								*/
/*  --------								*/
/*  Block footer, used in reports					*/

class	LIBKBASE_API	KBFooter : public KBFramer
{
	Q_OBJECT

public	:

	KBFooter (KBNode *, const QDict<QString> &, cchar *, bool * = 0) ;
	KBFooter (KBNode *, KBFooter *) ;
	virtual	 ~KBFooter () ;

	virtual	void		showAs		(KB::ShowAs) ;
	virtual	bool		resize		(int, int) ;
	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	KBFooter	*isFooter	() { return this ; }
	virtual	void		buildDisplay	(KBDisplay *) ;
}	;


/*  KBContainer								*/
/*  -----------								*/
/*  A container is used to provide resizing (floating or stretching)	*/
/*  of an area which can itself contain nested controls.		*/

class	LIBKBASE_API	KBContainer : public KBFramer
{
	Q_OBJECT

public	:

	KBContainer (KBNode *, const QDict<QString> &, cchar *, bool * = 0) ;
	KBContainer (KBNode *, KBContainer *) ;
	virtual	 ~KBContainer () ;

	virtual	void		showAs		(KB::ShowAs) ;
	virtual	bool		resize		(int, int) ;
	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	KBContainer	*isContainer	() { return this ; }
}	;

/*  KBTabberPage							*/
/*  ------------							*/
/*  This class is used for a page under a tabber. It is essentially a	*/
/*  container, except that its geometry is locked to its parent tabber.	*/

class	LIBKBASE_API	KBTabberPage : public KBFramer
{
	Q_OBJECT

protected :

	KBAttrStr		tabText		;

public	:

	KBTabberPage (KBNode *, const QDict<QString> &, cchar *, bool * = 0) ;
	KBTabberPage (KBNode *, KBTabberPage *) ;
	virtual	 ~KBTabberPage () ;

	virtual	KBTabberPage	*isTabberPage	() { return this ; }

	virtual	void		showAs		(KB::ShowAs)    ;
	virtual	bool		resize		(int, int)	;
	virtual	KBNode		*replicate	(KBNode *)	;

	virtual	void		setEnabled	(bool)	;
	void			setCurrent	()	;

public	slots	:

	void			setOffset	(int)	;
	virtual	bool		propertyDlg	() 	;
}	;

#endif	// _KB_FRAMER_H
