/***************************************************************************
    file	         : kb_formatdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_attr.h"
#include	"kb_qrybase.h"

#ifndef 	_WIN32
#include	"kb_formatdlg.moc"
#else
#include	"kb_formatdlg.h"
#endif


static	aFormat fDate[]=
{
{	"Long Date",		"Thursday, November 09, 2000",	"%A, %B %d, %Y"		},
{	"Medium Date",		"09-Nov-00",			"%d-%b-%y"		},
{	"Short Date",		"09/11/00",			"%d/%m/%y"		},
{	0,			0,				0			}
}	;

static	aFormat fTime[]=
{
{	"Long Time",		"1:26:44 PM",			"%l:%M:%S %p"		},
{	"Medium Time",		"1:26 PM",			"%l:%M %p"		},
{	"Short Time",		"13:26",			"%H:%M"			},
{	0,			0,				0			}
}	;

static	aFormat fDateTime[]=
{
{	"Date/Time",		"09-Nov-00 1:26:44 PM",		"%d-%b-%y %l:%M:%S %p"	},
{	"Short Date/Time",	"09/11/00 13:26:44",		"%d/%m/%y %H:%M:%S"	},
{	0,			0,				0			}
}	;

static	aFormat	fFixed[]=
{
{	"Decimal",		"42",				"%d"			},
{	"Short Hexadecimal",	"00A5",				"%04X"			},
{	"Long Hexadecimal",	"12FB00A5",			"%08X"			},
{	0,			0,				0			}
}	;

static	aFormat fFloat[]=
{
{	"Scientific",		"1.92764E+02",			"%E"			},
{	"Fixed point",		"192.76416",			"%f"			},
{	"Fixed point",		"192.76",			"%.2f"			},
{	"Percentage",		"35%",				"%f.0%%"		},
{	"Percentage, 1 place",	"35.2%",			"%f.1%%"		},
{	0,			0,				0			}
}	;

static	aFormat	fNumber[]=
{
{	0,			0,				0			}
}	;

static	aFormat	fCurrency[]=
{
{	0,			0,				0			}
}	;

static	cchar *ftypes[]=
{
	"Date",
	"Time",
	"DateTime",
	"Float",
	"Fixed",
	"Number",
	"Currency",
	0
}	;

#define	FT_DATE		0
#define	FT_TIME		1
#define	FT_DATETIME	2
#define	FT_FLOAT	3
#define	FT_FIXED	4
#define	FT_NUMBER	5
#define	FT_CURRENCY	5


static	QDict<aFormat> fmtMap;

LIBKBASE_API
	struct	aFormat	*getDateFormat	  ()
{
	return	fDate	;
}

LIBKBASE_API
	struct	aFormat	*getTimeFormat	  ()
{
	return	fTime	;
}

LIBKBASE_API
	struct	aFormat	*getDateTimeFormat()
{
	return	fDateTime ;
}

/*  KBFormatDlg								*/
/*  KBFormatDlg	: Constructor for format dialog support class		*/
/*  parent	: QWidget *	: Parent widget				*/
/*  (returns)	: KBFormatDlg	:					*/

KBFormatDlg::KBFormatDlg
	(	QWidget		*parent
	)
	:
	QWidget		(parent),
	parent		(parent),
	vLayBox		(this),
	hLayBox		(&vLayBox),
	eBox		(this),
	types		(this),
	formats		(this)
{
	vLayBox.setDirection (QBoxLayout::BottomToTop) ;
	vLayBox.setSpacing   (10)	;
	hLayBox.setSpacing   (10)	;

	vLayBox.addWidget    (&eBox   ) ;
	hLayBox.addWidget    (&types  ) ;
	hLayBox.addWidget    (&formats) ;

	formats.addColumn    (TR("Format"),  100) ;
	formats.addColumn    (TR("Example"), 160) ;

	if (fmtMap.count() == 0)
	{
		for (aFormat *fp1 = &fDate    [0] ; fp1->descr != 0 ; fp1 += 1)
			fmtMap.insert (fp1->descr, fp1) ;
		for (aFormat *fp2 = &fTime    [0] ; fp2->descr != 0 ; fp2 += 1)
			fmtMap.insert (fp2->descr, fp2) ;
		for (aFormat *fp3 = &fDateTime[0] ; fp3->descr != 0 ; fp3 += 1)
			fmtMap.insert (fp3->descr, fp3) ;
		for (aFormat *fp4 = &fFixed   [0] ; fp4->descr != 0 ; fp4 += 1)
			fmtMap.insert (fp4->descr, fp4) ;
		for (aFormat *fp5 = &fFloat   [0] ; fp5->descr != 0 ; fp5 += 1)
			fmtMap.insert (fp5->descr, fp5) ;
		for (aFormat *fp6 = &fNumber  [0] ; fp6->descr != 0 ; fp6 += 1)
			fmtMap.insert (fp6->descr, fp6) ;
		for (aFormat *fp7 = &fCurrency[0] ; fp7->descr != 0 ; fp7 += 1)
			fmtMap.insert (fp7->descr, fp7) ;
	}

	for (cchar **ft = &ftypes[0] ; *ft != 0 ; ft += 1)
		types.insertItem (*ft) ;

	connect
	(	&types,   SIGNAL(highlighted  (const QString &)),
		this,     SLOT  (selectType   (const QString &))
	) ;
	connect
	(	&formats, SIGNAL(doubleClicked(QListViewItem *)),
		this,     SLOT  (selectFormat (QListViewItem *))
	) ;
	connect
	(	&formats, SIGNAL(returnPressed(QListViewItem *)),
		this,     SLOT  (selectFormat (QListViewItem *))
	) ;
}

/*  KBFormatDlg								*/
/*  loadFormats	: Load formats into list view				*/
/*  fmtList	: aFormat *	: Form list				*/
/*  (returns)	: void		:					*/

void	KBFormatDlg::loadFormats
	(	aFormat	*fmtList
	)
{
	QListViewItem *last = 0 ;

	formats.clear () ;

	while (fmtList->descr != 0)
	{
		last = new QListViewItem (&formats, last,
						    fmtList->descr,
						    fmtList->example) ;
		fmtList += 1 ;
	}
}

/*  KBFormatDlg								*/
/*  selectType	: User selects format type				*/
/*  type	: const QString &: Selected type			*/
/*  (returns)	: void		 :					*/

void	KBFormatDlg::selectType
	(	const QString	&type
	)
{
	if	(type == "Date"    ) loadFormats (fDate    ) ;
	else if	(type == "Time"    ) loadFormats (fTime    ) ;
	else if	(type == "DateTime") loadFormats (fDateTime) ;
	else if (type == "Fixed"   ) loadFormats (fFixed   ) ;
	else if (type == "Float"   ) loadFormats (fFloat   ) ;
	else if (type == "Number"  ) loadFormats (fNumber  ) ;
	else if (type == "Currency") loadFormats (fCurrency) ;
}

/*  KBFormatDlg								*/
/*  selectFormat: User selects format specification			*/
/*  format	: QListViewItem *: Selected item			*/
/*  (returns)	: void		 :					*/

void	KBFormatDlg::selectFormat
	(	QListViewItem	*format
	)
{
	aFormat	*fp	;

	if ((fp = fmtMap.find(format->text(0))) != 0)
	{	eBox.setText  (fp->format) ;
		eBox.setFocus () ;
	}
}

/*  KBFormatDlg								*/
/*  showFormats	: Show format selection					*/
/*  value	: const QString & : Current display format		*/
/*  itype	: KB::IType	  : Field type				*/
/*  (returns)	: bool		  : Success				*/

bool	KBFormatDlg::showFormats
	(	const QString	&value,
		KB::IType	itype
	)
{
	int	cs	= value.find (':') ;

	if (cs >= 0)
	{
		QString	type	= value.left (cs)     ;
		QString	text	= value.mid  (cs + 1) ;

		eBox.setText (text) ;

		for (uint idx = 0 ; idx < types.count() ; idx += 1)
			if (types.text(idx) == type)
			{	types.setCurrentItem (idx) ;
				selectType (type) ;
			}

		return	true	;
	}

	int	ft = -1 ;

	switch (itype)
	{
		case KB::ITDate	   : ft = FT_DATE     ; break ;
		case KB::ITTime	   : ft = FT_TIME     ; break ;
		case KB::ITDateTime: ft = FT_DATETIME ; break ;
		case KB::ITFloat   : ft = FT_FLOAT    ; break ;
		case KB::ITFixed   : ft = FT_FIXED    ; break ;
		default		   : break ;
	}

	if (ft >= 0)
	{	types.setCurrentItem (ft)  ;
		selectType    (ftypes[ft]) ;
	}

	return	true ;
}

/*  KBFormatDlg								*/
/*  showFormats	: Show format selection					*/
/*  value	: const QString & : Current display format		*/
/*  fname	: const QString & : Field being displayed		*/
/*  query	: KBQryBase *	  : Underlying query			*/
/*  qlvl	: uint		  : Query level				*/
/*  (returns)	: bool		  : Success				*/

bool	KBFormatDlg::showFormats
	(	const QString	&value,
		const QString	&fname,
		KBQryBase	*query,
		uint		qlvl
	)
{
	KB::IType ft	= KB::ITUnknown ;

	QList<KBFieldSpec> fldList   ;
	int		   pKey	     ;

	fldList.setAutoDelete (true) ;

	if (!query->getFieldList (qlvl, fldList, pKey))
	{	query->lastError().DISPLAY() ;
		return	false	;
	}

	LITER
	(	KBFieldSpec,
		fldList,
		field,

		if (field->m_name == fname)
		{	ft = field->m_typeIntl ;
			break	;
		}
	)
	return	showFormats (value, ft) ;
}

