/***************************************************************************
    file	         : kb_eventdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_EVENTDLG_H
#define	_KB_EVENTDLG_H

#if	! __KB_RUNTIME

#include	<qspinbox.h>
#include	<qcombobox.h>
#include	<qpushbutton.h>
#include	<qframe.h>
#include	<qvaluelist.h>

#include	"libkbase_exports.h"

#include	"kb_classes.h"
#include	"kb_attrdlg.h"
#include	"kb_attritem.h"
#include	"kb_propdlg.h"
#include	"kb_macroeditor.h"

#include	"tktextmanager.h"
#include	"tktexteditor.h"
#include	"tkc_tkemapper.h"



/*  KBAttrEventItem							*/
/*  ---------------							*/
/*  Attribute item for events, knows about scripted and macro-based	*/
/*  events.								*/

class	LIBKBASE_API	KBAttrEventItem : public KBAttrItem
{
	KBEvent			*m_event	;
	KBMacroExec		*m_macro	;
	QValueList<int>		m_breakpoints	;

public	:

	KBAttrEventItem		(KBEvent *)	;
	~KBAttrEventItem	()		;

	virtual	QString		displayValue	() ;
	virtual	void		clear		() ;
	virtual	void		save		() ;

	virtual	KBAttrDlg	*getAttrDlg	(QWidget *, QDict<KBAttrItem> &) ;

	inline	KBMacroExec	*getMacro ()
	{
		return	m_macro	;
	}
	inline	void	setMacro
		(	KBMacroExec	*macro
		)
	{
		if (m_macro != 0) delete m_macro ;
		m_macro	= macro ;
	}

	void			setBreakpoints	(QValueList<int> &) ;
	const QValueList<int>	&breakpoints	() ;
}	;

/*  KBEventDlg								*/
/*  ----------								*/
/*  Dialog component for events. This is the plugin dialog for the	*/
/*  property editors.							*/

class	LIBKBASE_API	KBEventDlg : public KBAttrDlg
{
	Q_OBJECT

	TKTextEditor		m_editor	;
	TKCTKEMapper		m_mapper	;
	KBAttrEventItem		*m_eventItem	;
	QString			m_language	;
	int			m_lastLno	;
	QValueList<int>		m_breakpoints	;

protected slots :

	void	mouseRightClick 	(QPoint, int)	;
	void	toggleBreakpoint	()		;
	void	clearBreakpoints	()		;

public	:

	KBEventDlg
	(	QWidget			*,
		KBEvent			*,
		KBAttrEventItem		*,
		QDict<KBAttrItem>	&
	)	;

	virtual	void		verify		() ;
	virtual	bool		init		() ;
	virtual	bool		init		(const QString &) ;
	virtual	void		save		() ;
	virtual	QString		value		() ;
}	;

/*  KBEventMacroDlg							*/
/*  ---------------							*/
/*  Wrapper around the macro editor, used when editing macros embedded	*/
/*  in events.								*/

class	LIBKBASE_API	KBEventMacroDlg : public _KBDialog
{
	Q_OBJECT

	KBMacroEditor	m_editor	;
	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;

protected slots :

	void	accept	()	;

public	:

	KBEventMacroDlg (KBDBInfo *, const QString &)	;

	inline	KB::ShowRC startup
		(	KBMacroExec	*macro,
			KBError		&pError
		)
	{
		return	m_editor.startup (macro, pError) ;
	}

	KBMacroExec	*macro	(KBNode *, KBError &)	 ;
}	;

#endif	// ! __KB_RUNTIME
#endif	// _KB_EVENTDLG_H
