/***************************************************************************
    file	         : kb_configdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_CONFIGDLG_H
#define	_KB_CONFIGDLG_H

#if	! __KB_RUNTIME


#include	<qlist.h>
#include	<qwidget.h>
#include	<qwidgetstack.h>
#include	<qlayout.h>
#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qcheckbox.h>
#include	<qpushbutton.h>
#include	<qlistview.h>

#include	"libkbase_exports.h"

#include	"kb_param.h"
#include	"kb_config.h"
#include	"kb_dialog.h"
#include	"kb_paramsetdlg.h"

#include	"tk_lineedit.h"


/*  KBConfigItem							*/
/*  -----------								*/
/*  This is a wrapper round a list view item, used to store the		*/
/*  properties of a configuration item which is being edited.		*/

class	LIBKBASE_API KBConfigItem : public QListViewItem
{
	bool		m_user		;
	bool		m_required	;
	bool		m_hidden	;

	void		showFlags  ()	;

public	:

	KBConfigItem
	(	QListView 	*,
		KBConfig	*
	)	;

	KBConfigItem
	(	QListView	*,
		const QString	&,
		const QString	&,
		const QString	&,
		bool		,
		bool		,
		bool
	) ;

        virtual ~KBConfigItem () ;

	KBConfig	*getConfig  (KBNode *, uint) ;

	inline	bool	user     ()
	{
		return	m_user	    ;
	}
	inline	bool	required ()
	{
		return	m_required  ;
	}
	inline	bool	hidden   ()
	{
		return	m_hidden    ;
	}
}	;



/*  KBConfigDlg								*/
/*  ----------								*/
/*  This class is used as a component in property dialogs to handle	*/
/*  editing of configuration objects.					*/

class	LIBKBASE_API KBConfigDlg : public QWidget
{
	Q_OBJECT

	KBNode		*m_node		;
	QLabel		m_lAttrib	;
	QLabel		m_lValue	;
	QLabel		m_lLegend	;

	QWidgetStack	m_attrStack	;
	TKLineEdit	m_eAttrib	;
	QComboBox	m_cbAttrib	;
	TKLineEdit	m_eValue	;
	TKLineEdit	m_eLegend	;

	QCheckBox	m_cUser		;
	QCheckBox	m_cRequired	;
	QCheckBox	m_cHidden	;

	QPushButton	m_bAdd		;
	QPushButton	m_bRemove	;
	QPushButton	m_bEdit		;

	QListView	m_lvConfigs	;

	KBConfigItem	*m_curItem	;
	KBConfigItem	*m_editItem	;
	uint		m_ident		;

protected slots :

	void		clickAdd	() ;
	void		clickRemove	() ;
	void		clickEdit	() ;
	void		userChanged	() ;
	void		selectionChanged(QListViewItem *) ;

public	:

	KBConfigDlg	(QWidget *, KBNode *) ;
	~KBConfigDlg	() ;

	void		fixUp		() ;
	QString		getText		() ;
}	;


#endif
#endif	// _KB_CONFIGDLG_H
