/***************************************************************************
    file	         : kb_configdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<time.h>
#include	<qlistbox.h>

#ifndef 	_WIN32
#include	"kb_configdlg.moc"
#else
#include 	"kb_configdlg.h"
#endif

#include	"kb_config.h"



class	KBConfigAttrItem : public QListBoxText
{
	KBAttr	*m_attr	;

public	:

	inline	KBConfigAttrItem
		(	QListBox	*listBox,
			KBAttr		*attr
		)
		:
		QListBoxText	(listBox, attr->getLegend()),
		m_attr		(attr)
	{
	}

	inline	KBAttr	*getAttr ()
	{
		return	m_attr	;
	}
}	;



/*  KBConfigItem								*/
/*  KBConfigItem: Constructor for parameter dialog configuration item	*/
/*  listView	: QListView *	: Parent list view			*/
/*  config	: KBConfig *	: Extant configuration object		*/
/*  (returns)	: KBConfigItem	:					*/

KBConfigItem::KBConfigItem
	(	QListView	*listView,
		KBConfig	*config
	)
	:
	QListViewItem
	(	listView,
		config->attrib(),
		config->legend(),
		config->value ()
	),
	m_user		(config->user     ()),
	m_required	(config->required ()),
	m_hidden	(config->hidden   ())
{
	showFlags	() ;
}

/*  KBConfigItem							*/
/*  KBConfigItem Constructor for configuration dialog parameter item	*/
/*  listView	: QListView *	  : Parent list view			*/
/*  name	: const QString & : Configuration object name		*/
/*  value	: const QString & : Default value			*/
/*  legend	: const QString & : Prompt legend			*/
/*  user	: bool		  : User (scripting) configuration	*/
/*  required	: bool		  : Value is required			*/
/*  hidden	: bool		  : Hidden state			*/
/*  (returns)	: KBConfigItem	  :					*/

KBConfigItem::KBConfigItem
	(	QListView	*listView,
		const QString	&name,
		const QString	&value,
		const QString	&legend,
		bool		user,
		bool		required,
		bool		hidden
	)
	:
	QListViewItem
	(	listView,
		name,
		legend,
		value
	),
	m_user		(user),
	m_required	(required),
	m_hidden	(hidden)
{
	showFlags	() ;
}

/*  KBConfigItem								*/
/*  KBConfigItem~: Destructor for parameter dialog parameter item	*/
/*  (returns)	:		:					*/

KBConfigItem::~KBConfigItem ()
{
}

void	KBConfigItem::showFlags ()
{
	setText
	(	3,
		QString	("%1%2%3")
			.arg(m_user      ? "U" : "")
			.arg(m_required  ? "R" : "")
			.arg(m_hidden    ? "H" : "")
	)	;
}

/*  KBConfigItem							*/
/*  getConfig	: Get configuration object				*/
/*  node	: KBNode *	: Parent node				*/
/*  ident	: uint		: Identifier value			*/
/*  (returns)	: KBConfig *	:					*/

KBConfig*KBConfigItem::getConfig
	(	KBNode		*node,
		uint		ident
	)
{
	return	new KBConfig
		(	node,
			QString("%1.%2").arg(time(0)).arg(ident),
			text(0),
			m_user ? text(2) : QString::null,
			text(1),
			m_user,
			m_required,
			m_hidden
		)	;
}


/*  ------------------------------------------------------------------  */

/*  KBConfigDlg								*/
/*  KBConfigDlg	: Constructor for configuration object dialog		*/
/*  parent	: QWidget *	: Parent widget				*/
/*  node	: KBNode *	: Owning node				*/
/*  (returns)	: KBConfigDlg	:					*/

KBConfigDlg::KBConfigDlg
	(	QWidget		*parent,
		KBNode		*node
	)
	:
	QWidget		(parent),
	m_node		(node),
	m_lAttrib	(this),
	m_lValue	(this),
	m_lLegend	(this),
	m_attrStack	(this),
	m_eAttrib	(&m_attrStack),
	m_cbAttrib	(&m_attrStack),
	m_eValue	(this),
	m_eLegend	(this),
	m_cUser		(this),
	m_cRequired	(this),
	m_cHidden	(this),
	m_bAdd		(this),
	m_bRemove	(this),
	m_bEdit		(this),
	m_lvConfigs	(this)
{
	m_lAttrib  .setText   (TR("Property" )) ;
	m_lValue   .setText   (TR("Value"    )) ;
	m_lLegend  .setText   (TR("Legend"   )) ;

	m_cUser	   .setText   (TR("User"     )) ;
	m_cRequired.setText   (TR("Required" )) ;
	m_cHidden  .setText   (TR("Hidden"   )) ;

	m_bAdd	   .setText   (TR("Add"      )) ;
	m_bRemove  .setText   (TR("Remove"   )) ;
	m_bEdit	   .setText   (TR("Edit"     )) ;

	m_bEdit    .setEnabled(false) ;
	m_bRemove  .setEnabled(false) ;

#if	__KB_EMBEDDED
	m_lvConfigs.addColumn (TR("Property" ),  50) ;
	m_lvConfigs.addColumn (TR("Legend"   ),  50) ;
	m_lvConfigs.addColumn (TR("Value"    ),  90) ;
#else
	m_lvConfigs.addColumn (TR("Property" ),  80) ;
	m_lvConfigs.addColumn (TR("Legend"   ),  90) ;
	m_lvConfigs.addColumn (TR("Value"    ), 140) ;
#endif
	m_cbAttrib .setFixedHeight (m_eAttrib.sizeHint().height()) ;
	m_attrStack.setFixedHeight (m_eAttrib.sizeHint().height()) ;
	m_attrStack.raiseWidget    (&m_cbAttrib) ;

	QVBoxLayout	*layMain = new QVBoxLayout (this   ) ;
	QGridLayout	*layEdit = new QGridLayout (layMain) ;

	layEdit->addColSpacing(2, 8) ;

	layEdit->addWidget (&m_lAttrib,     0, 0) ;
	layEdit->addWidget (&m_lValue,      1, 0) ;
	layEdit->addWidget (&m_lLegend,     2, 0) ;

	layEdit->addWidget (&m_attrStack,   0, 1) ;
	layEdit->addWidget (&m_eValue,      1, 1) ;
	layEdit->addWidget (&m_eLegend,     2, 1) ;

	layEdit->addWidget (&m_cUser, 	    0, 3) ;
	layEdit->addWidget (&m_cRequired,   1, 3) ;
	layEdit->addWidget (&m_cHidden,     2, 3) ;

	layEdit->addWidget (&m_bAdd,        0, 4) ;
	layEdit->addWidget (&m_bEdit,       1, 4) ;
	layEdit->addWidget (&m_bRemove,     2, 4) ;

	layMain->addWidget (&m_lvConfigs) ;

	_KBDialog::setupLayout (this, -1, 0)  ;

	connect	(&m_bAdd,	SIGNAL(clicked()), SLOT(clickAdd   ())) ;
	connect	(&m_bRemove,	SIGNAL(clicked()), SLOT(clickRemove())) ;
	connect	(&m_bEdit,	SIGNAL(clicked()), SLOT(clickEdit  ())) ;

	connect (&m_lvConfigs,	SIGNAL(selectionChanged(QListViewItem *)),
				SLOT  (selectionChanged(QListViewItem *))) ;

	connect (&m_lvConfigs,	SIGNAL(doubleClicked   (QListViewItem *)),
				SLOT  (clickEdit       ())) ;
	connect (&m_lvConfigs,	SIGNAL(returnPressed   (QListViewItem *)),
				SLOT  (clickEdit       ())) ;

	connect	(&m_cUser,	SIGNAL(toggled	       (bool)),
				SLOT  (userChanged     ())) ;

	m_curItem	= 0 ;
	m_editItem	= 0 ;

	TITER
	(	Config,
		node->getChildren(),
		c,

		c->fixupValue () ;
		new KBConfigItem (&m_lvConfigs, c) ;
	)

	/* Load the property selection listbox with all the non-dummy	*/
	/* poperties of the node whose configuration objects are being	*/
	/* edited.							*/
	LITER
	(	KBAttr,
		node->getAttribs(),
		attr,
		if ((attr->getFlags() & KAF_DUMMY) == 0)
			new KBConfigAttrItem (m_cbAttrib.listBox(), attr) ;
	)
}


/*  KBConfigDlg								*/
/*  ~KBConfigDlg: Destructor for configuration object dialog		*/
/*  (returns)	:		:					*/

KBConfigDlg::~KBConfigDlg ()
{
	DELOBJ	(m_editItem)	;
}


/*  KBConfigDlg								*/
/*  getText	: Get text to display in properties dialog		*/
/*  (returns)	: QString	: Text					*/

QString	KBConfigDlg::getText ()
{
	QString	res	;
	QListViewItem	*item	= m_lvConfigs.firstChild() ;

	while (item != 0)
	{
		if (!res.isEmpty()) res += ", " ;

		res += item->text       (0) ;
		item = item->nextSibling()  ;
	}

	if (m_editItem != 0)
	{
		if (!res.isEmpty()) res += ", " ;
		res += m_editItem->text (0)	;
	}

	return	res	;
}

/*  KBConfigDlg								*/
/*  fixUp	: Fix up on acceptance					*/
/*  (returns)	: void		:					*/

void	KBConfigDlg::fixUp ()
{
	fprintf
	(	stderr,
		"KBConfigDlg::fixUp: called ....\n"
	)	;

	if (m_editItem != 0)
	{	m_lvConfigs.insertItem (m_editItem) ;
		m_editItem = 0	 ;
	}

	QList<KBConfig>   old	 ;
	old.setAutoDelete (true) ;

	TITER
	(	Config,
		m_node->getChildren(),
		c,
		old.append(c)
	)

	old.clear () ;

	QListViewItem	*item	= m_lvConfigs.firstChild() ;
	uint		ident	= 0x000ffffff & (uint)(void *)item ;

	while (item != 0)
	{
		((KBConfigItem *)item)->getConfig (m_node, ident) ;
		item   = item->nextSibling()  ;
		ident += 1 ;
	}
}

void	KBConfigDlg::userChanged ()
{
	if (!m_cUser.isOn())
	{	m_attrStack.raiseWidget (&m_cbAttrib) ;
		m_eValue   .setEnabled  (false) ;
		m_eValue   .setText	(QString::null) ;
		return	;
	}

	int		index	= m_cbAttrib.currentItem() ;
	QListBoxItem	*item	= m_cbAttrib.listBox()->item(index) ;

	m_eAttrib  .setText	(((KBConfigAttrItem *)item)->getAttr()->getName()) ;
	m_attrStack.raiseWidget (&m_eAttrib) ;
	m_eValue   .setEnabled  (true) ;
	m_eValue   .setText	(QString::null) ;
}

/*  KBConfigDlg								*/
/*  clickAdd	: User clicks add button				*/
/*  (returns)	: void		:					*/

void	KBConfigDlg::clickAdd ()
{
	if (!m_eAttrib.text().isEmpty() || !m_cUser.isOn())
	{
		QString	     attr  ;

		if (!m_cUser.isOn())
		{
			int		index	= m_cbAttrib.currentItem() ;
			QListBoxItem	*item	= m_cbAttrib.listBox()->item(index) ;

			attr	= ((KBConfigAttrItem *)item)->getAttr()->getName () ;
		}
		else	attr	= m_eAttrib.text() ;

		KBConfigItem *item = new KBConfigItem
				     	 (	&m_lvConfigs,
						attr,
						m_eValue   .text       (),
						m_eLegend  .text       (),
						m_cUser    .isChecked  (),
						m_cRequired.isChecked  (),
						m_cHidden  .isChecked  ()
					 ) 	;

		m_lvConfigs.setCurrentItem (item) ;
		m_eValue   .setEnabled     (m_cUser.isOn()) ;
		m_eAttrib  .clear () ;
		m_eValue   .clear () ;
		m_eLegend  .clear () ;

		DELOBJ	(m_editItem) ;

		m_bAdd   .setText    (TR("Add")) ;
		m_bEdit  .setEnabled (true) ;
		m_bRemove.setEnabled (true) ;
	}
}

/*  KBConfigDlg								*/
/*  clickRemove	: User clicks remove button				*/
/*  (returns)	: void		:					*/

void	KBConfigDlg::clickRemove ()
{
	if (m_curItem != 0)
		DELOBJ (m_curItem) ;
}

/*  KBConfigDlg								*/
/*  clickEdit	: User clicks edit button				*/
/*  (returns)	: void		:					*/

void	KBConfigDlg::clickEdit ()
{
	if (m_curItem == 0)
		return ;

	/* If not a user configuration the see if we can map the	*/
	/* property name to the value the user sees as the the name of	*/
	/* the property (the property legend).				*/
	if (!m_curItem->user())
	{
		for (int idx = 0 ; idx < m_cbAttrib.count() ; idx += 1)
		{
			QListBoxItem *item = m_cbAttrib.listBox()->item(idx) ;
			QString	     name  = ((KBConfigAttrItem *)item)->getAttr()->getName() ;

			if (name == m_curItem->text(0))
			{
				m_cbAttrib.setCurrentItem (idx) ;
				break	;
			}
		}

		m_attrStack.raiseWidget (&m_cbAttrib) ;
		m_eValue   .setEnabled  (false) ;
	}
	else
	{	m_attrStack.raiseWidget (&m_eAttrib ) ;
		m_eValue   .setEnabled  (true ) ;
	}

	/* Note: Set the checkboxes first, since changing the state of	*/
	/* the user checkbox may trigger a signal to the "userChanged"	*/
	/* slot, and update the property text edit box.			*/
	m_cUser    .setChecked(m_curItem->user    ()) ;
	m_cRequired.setChecked(m_curItem->required()) ;
	m_cHidden  .setChecked(m_curItem->hidden  ()) ;

	m_eAttrib  .setText   (m_curItem->text (0)) ;
	m_eLegend  .setText   (m_curItem->text (1)) ;
	m_eValue   .setText   (m_curItem->text (2)) ;

	m_editItem  = m_curItem	;
	m_curItem   = 0		;
	m_lvConfigs.takeItem (m_editItem) ;

	m_bAdd   .setText    (TR("Save")) ;
	m_bEdit  .setEnabled (false) ;
	m_bRemove.setEnabled (false) ;
}

/*  KBConfigDlg								*/
/*  selectionChanged							*/
/*		: Current item selection changes			*/
/*  item	: QListViewItem * : Newly selected item			*/
/*  (returns)	: void		  :					*/

void	KBConfigDlg::selectionChanged
	(	QListViewItem	*item
	)
{
	m_curItem = (KBConfigItem *)item   ;
	m_bRemove .setEnabled  (item != 0) ;
	m_bEdit   .setEnabled  (item != 0) ;
}

