/***************************************************************************
    file	         : kb_block.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_BLOCK_H
#define	__KB_BLOCK_H

#include	"libkbase_exports.h"

#include	"kb_item.h"
#include	"kb_attrframe.h"
#include	"kb_attrnav.h"

class	KBBlockEvents	;

class	LIBKBASE_API	KBBlockInfo
{
public	:

	KBDisplay	*scroll		;
	KBRowMark	*rowmark	;

	inline	KBBlockInfo ()
	{
		scroll	= 0	;
		rowmark	= 0	;
	}
}	;

/*  KBBlock								*/
/*  -----------								*/
/*  This node represents the KBaseBlock XML element. It is essentially	*/
/*  a wrapper round a query and the data this is displayed from it.	*/

class	LIBKBASE_API KBBlock : public KBItem
{
	Q_OBJECT

public	:

	enum	BlkType
	{
		BTUnknown,
		BTTable,
		BTQuery,
		BTSubBlock,
		BTNull,
		BTDesign,
		BTSQL
	}	;

protected :

	KBAttrStr		cexpr	    ;
	KBAttrStr		bgcolor	    ;

	KBAttrBool		autosync    ;
	KBAttrStr		title	    ;
	KBAttrFrame		frame	    ;
	KBAttrNav		showbar	    ;
	KBAttrInt		rowcount    ;
	KBAttrInt		dx	    ;
	KBAttrInt		dy	    ;

	BlkType			blkType	    ;

	KBBlockEvents		*events	    ;

	KBQryBase		*m_query    ;
	KBDisplay		*blkDisp    ;
	KBBlockInfo		blkInfo     ;

	uint			curQRow	    ;	/* Current query row	*/
	uint			curDRow	    ;	/* First displayed row	*/
	uint			qryLvl	    ;	/* Block query level	*/

	/* The nRows member contains the number of rows displayed 	*/
	/* within this block; pRows contains the number of rows		*/
	/* displayed by the parent block. mValues contains the set of	*/
	/* values from the parent.					*/
	uint			nRows	    	;
	uint			pRows	    	;

	bool			topLevel    	;
	Qt::ButtonState		bState	    	;
	QRect			newRect	    	;
	QPoint			insertAt    	;

	KBFramer		*header	    	;
	KBFramer		*footer	    	;
	bool			anyChildBlock	;

	void			init		() 	;
	bool			newSubBlocks	()	;

#if	! __KB_RUNTIME
	QRect			newCtrlRect	() 	;
	void			setCtrlRect	(QRect)	;
#endif
	virtual void		setPalette	()	;
	virtual void		setFont		()	;
	bool			eventHook	(KBEvent &, uint, KBValue *, bool &) ;

	bool			findQuery	()	;

#if	! __KB_RUNTIME
	bool			blockPropDlg	(cchar *) ;
#endif

	QString			m_userFilter	;
	QString			m_userSorting	;

public	:

	KBBlock	(KBNode   *, const QDict<QString> &, cchar *) ;
	KBBlock	(KBObject *, const QRect &, BlkType, bool  &, cchar *) ;
	KBBlock (KBNode   *, KBBlock *) ;
virtual~KBBlock	()		 ;

	virtual	void		showAs		(KB::ShowAs)	;
	virtual	void		remChild	(KBNode *)	;

	virtual	void		move		(int, int) 	;
	virtual	bool		resize		(int, int) 	;

	virtual	KBBlock 	*isBlock	() { return this    ; }
	virtual	bool		isUpdateVal	() { return false   ; }
	virtual	KBDisplay	*getContainer	() { return blkDisp ; }

	virtual	KBValue		getValue	(uint) = 0 ;
	virtual	bool		setValue	(uint, const KBValue &) = 0 ;
	virtual	KBValue		*getBlockVal	()     = 0 ;
	virtual	uint		rowsInBlock	()     = 0 ;

	virtual void		clearValue	(uint, bool) ;
	virtual	bool		changed		(uint) ;
	virtual	bool		isEmpty		(uint) ;
	virtual	bool		isValid		(uint, bool) ;

	virtual	uint		calcNumRows 	(int,  int,  uint    ) ;
	virtual	uint		calcNumRows 	(uint, uint, int, int) ;
	virtual void		extendCtrls	(uint, int, int) ;

	void			buildTopDisplay	(KBDisplay *) ;
	void			buildDisplay	(KBDisplay *) ;
	virtual	void		buildCtrls	(uint, int, int) ;
	bool			setBlkType	(BlkType) ;
	void			setCurrent	(bool)	  ;

	KBQryBase		*getQuery       () ;

	void			getObjects	(QList<KBObject> &) ;
	void			getItems	(QList<KBItem  > &) ;

	virtual	bool		blockSetup	() ;
	bool			addAllItems	() ;
	virtual bool		requery		() ;
	void			setQryLevel 	(uint, KBQryBase *) ;

	inline	uint		getCurQRow	() { return curQRow ; }
	inline	BlkType		getBlkType	() { return blkType ; }
	inline	uint		getCurDRow	() { return curDRow ; }
	inline	uint		getQryLevel	() { return qryLvl  ; }
	inline	uint		getDisplayRows	() { return nRows   ; }

	uint			getNumRows	() ;
	KBValue			getRowValue	(const QString &, uint) ;
	KBValue			getRowValue	(KBItem	       *, uint) ;
	void			setRowValue	(const QString &, uint, const KBValue &) ;

#if	! __KB_RUNTIME
	virtual	void		designPopup	(QMouseEvent   *, uint) ;
#endif

	virtual	void		setTabOrder	(int)	;
	virtual	int		getTabOrder	()	;

	virtual	KBNode		*replicate	(KBNode *) = 0  ;
	virtual	bool		write		(KBWriter *, QPoint, bool, int &) ;

	QString			getQueryComment	() ;

	inline	void	setUserFilter
		(	const QString	&filter
		)
	{
		m_userFilter	= filter	;
	}
	inline	void	setUserSorting
		(	const QString	&sorting
		)
	{
		m_userSorting	= sorting	;
	}

public	slots :

	bool			blockPropDlg	() ;
	virtual KBNode		*newNode	(int) = 0 ;
	virtual void		docPropDlg	()    = 0 ;
	virtual	void		showQuery	() ;

	virtual void		pasteObjects	() ;
	virtual void		pasteHere	() ;
	virtual void		pasteComponent	() ;
	virtual void		linkComponent	() ;
}	;

#if	! __KB_RUNTIME

extern 	LIBKBASE_API	bool	blockPropDlg
			(	KBBlock		*,
				cchar 		*,
				QList<KBAttr  > &,
				cchar 		* = 0
			)	;

#endif
#endif	// __KB_BLOCK_H
