/***************************************************************************
    file	         : kb_attr.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_ATTR_H
#define	_KB_ATTR_H

#include 	"libkbase_exports.h"

#include	<stdio.h>
#include	<stdlib.h>

#include	<qstring.h>
#include	<qdict.h>
#include	<qlistview.h>

#include	"kb_classes.h"

#define	KF_FLAGS	0x000007ff

#define	KF_FORM		0x00000001	/* Attribute appears in form	*/
#define	KF_QUERY	0x00000002	/* .... query			*/
#define	KF_REPORT	0x00000004	/* .... report			*/
#define	KF_STATIC	0x00000010	/* Static control		*/
#define	KF_BLOCK	0x00000020	/* Block control		*/
#define	KF_DATA		0x00000040	/* Data-only node		*/
#define	KF_FRAMER	0x00000080	/* .... framer only		*/
#define	KF_EXTRA	0x00000100	/* Add to extra menu		*/
#define	KF_REQD		0x00000800	/* Value must be set		*/

#define	KAF_FLAGS	0xfffff000

#define	KAF_GRPMASK	0x000ff000
#define	KAF_GRPFORMAT	0x00001000	/* Formatting property		*/
#define	KAF_GRPDATA	0x00002000	/* Data property		*/
#define	KAF_GRPOTHER	0x00004000	/* Other property		*/
#define	KAF_GRPEVENT	0x00008000	/* Event property		*/
#define	KAF_GRPNOTES	0x00010000	/* Special, used for notes	*/

#define	KAF_CLEAR	0x00100000	/* Enable clear button		*/
#define	KAF_EDITOR	0x00200000	/* Display editor		*/
#define	KAF_SINGLE	0x00400000	/* Display single line		*/
#define	KAF_MULTI	0x00800000	/* Display multi line		*/
#define	KAF_COMMON	0x01000000	/* Display in common properties	*/
#define	KAF_HIDDEN	0x02000000	/* Attribute is always hidden	*/

/*  Dummy attributes are those that are constructed for use only inside	*/
/*  property dialogs (for instance "blktype") to provide the user with	*/
/*  a handle to change a setting that is not actually a property.	*/
/*  Synthetic attributes (which are always also dummies) are used where	*/
/*  child nodes (for instance, hidden and paramater nodes) can only	*/
/*  be accessed via the parent nodes properties dialog.			*/
#define	KAF_DUMMY	0x08000000	/* Dummy attribute		*/
#define	KAF_SYNTHETIC	0x0c000000	/* Synthetic attribute		*/

#define	KAF_USER	0x40000000	/* User attribute		*/
#define	KAF_CUSTOM	0x80000000	/* Custom flags set		*/


#define	KAF_NOTES	(KAF_GRPNOTES|KAF_EDITOR|KAF_CLEAR|KAF_CUSTOM)


class	KBAttrItem	;
class	KBAttrDlg	;


/*  KBAttr								*/
/*  ------								*/
/*  The KBAttr(ibute) class, and its derived classes are used to	*/
/*  automate attribute setting and output.				*/

class	LIBKBASE_API	KBAttr
{
	void		attach ()	;

public	:

	enum	AType
	{	Base,
		String,
		Int,
		UInt,
		Bool
	}	;

protected :

	KBNode		*owner		;

	AType		type		;
	QString		name		;

private	  :

	QString		m_value		;
	QString		m_saved		;

protected :

	uint		nFlags		;
	uint		order		;
	KB::ShowAs	m_showing	;

	KBNodeMonitor	*monitor	;
	cchar		*ownerName	;

	QString		substitute	(const QString &) ;

public	:

	KBAttr (KBNode *, AType, cchar *, const QDict<QString> &, uint = 0) ;
	KBAttr (KBNode *, AType, cchar *, cchar  *, uint = 0) ;
	KBAttr (KBNode *, 	 cchar *, KBNode *, uint = 0) ;
	virtual	~KBAttr () ;

	virtual	bool		showAs		(KB::ShowAs)	  ;
	virtual	void		printAttr 	(QString &, QString &, int) ;
	virtual	void		setValue  	(const QString &) ;
	virtual	bool		valueOK	  	(const QString &) ;

	virtual	KBAttr		*replicate	(KBNode  * ) ;

	inline	AType		getType   	() { return type  ; }
	inline	const QString	&getName        () { return name  ; }
	virtual QString		getLegend       () ;
	virtual QString		getDescription  () ;
	virtual QString		getNullcheck	() ;

	uint			getOrder	() ;
	uint			getFlags	() ;
	virtual	QString 	getValue  	() ;

#if	! __KB_RUNTIME
	virtual	KBAttrItem	*getAttrItem	() ;
	virtual	KBAttrDlg	*getAttrDlg
				(	QWidget			*,
					KBAttrItem		*,
					QDict<KBAttrItem>	&
				)	;
	virtual	QString		displayValue	(const QString &) ;
#endif
	virtual	KBEvent		*isEvent	() ;

	void			showMonitor	(QListViewItem *) ;

	inline	void	setFlags
		(	uint	_flags
		)
	{
		nFlags	|= _flags ;
	}
	inline	bool	required ()
	{
		return	(nFlags & KF_REQD) != 0 ;
	}
	inline	cchar	*getOwnerName ()
	{
		return	ownerName ;
	}
	inline	KBNode	*getOwner ()
	{
		return	owner	  ;
	}


	static	QString	escapeText	(const QString &, bool = true) ;
	static	void	addAttrText	(QString &, const QString &, const QString &, bool = false) ;
}	;

class	LIBKBASE_API	KBAttrStr : public KBAttr
{
public	:

	KBAttrStr (KBNode *, cchar *, const QDict<QString> &, uint = 0) ;
	KBAttrStr (KBNode *, cchar *, cchar  *, uint = 0) ;
	KBAttrStr (KBNode *, cchar *, KBNode *, uint = 0) ;

	virtual	  ~KBAttrStr		() ;

	virtual	KBAttr	*replicate	(KBNode  *) ;
}	;

class	LIBKBASE_API	KBAttrInt : public KBAttr
{
public	:

	KBAttrInt (KBNode *, cchar *, const QDict<QString> &, uint = 0) ;
	KBAttrInt (KBNode *, cchar *, cchar  *, uint = 0) ;
	KBAttrInt (KBNode *, cchar *, int     , uint = 0) ;
	KBAttrInt (KBNode *, cchar *, KBNode *, uint = 0) ;

	virtual	  ~KBAttrInt	    () ;

	virtual	void	setValue    (int) ;
	virtual	bool	valueOK	    (const QString &) ;
	virtual	KBAttr	*replicate  (KBNode  *) ;

	inline	int	getIntValue ()
	{
		return	getValue().isEmpty() ? 0 : getValue().toInt() ;
	}
}	;

class LIBKBASE_API	KBAttrUInt : public KBAttr
{
public	:

	KBAttrUInt (KBNode *, cchar *, const QDict<QString> &, uint = 0) ;
	KBAttrUInt (KBNode *, cchar *, cchar  *, uint = 0) ;
	KBAttrUInt (KBNode *, cchar *, uint    , uint = 0) ;
	KBAttrUInt (KBNode *, cchar *, KBNode *, uint = 0) ;

	virtual	  ~KBAttrUInt		() ;

	virtual	void	setValue	(uint) ;
	virtual	bool	valueOK		(const QString &) ;
	virtual	KBAttr	*replicate	(KBNode  *) ;

	inline	int	getIntValue ()
	{
		return	getValue().isEmpty() ? 0 : getValue().toInt() ;
	}
}	;

class	LIBKBASE_API	KBAttrBool : public KBAttr
{
public	:

	KBAttrBool(KBNode *, cchar *, const QDict<QString> &, uint = 0) ;
	KBAttrBool(KBNode *, cchar *, cchar  *, uint = 0) ;
	KBAttrBool(KBNode *, cchar *, bool    , uint = 0) ;
	KBAttrBool(KBNode *, cchar *, KBNode *, uint = 0) ;

	virtual	  ~KBAttrBool	    	() ;

	virtual	void	setValue    	(bool) ;
	virtual	KBAttr	*replicate	(KBNode  *) ;

	bool		getBoolValue	() ;
}	;




/*  KBATTRCTRDEF							*/
/*  ------------							*/
/*  These are convenience macros, used to generate a set of default	*/
/*  constructors for a derived attribute, where "type" is the derived	*/
/*  class name, and "base" is the base class name.			*/


#define	KBATTRCTRDEF(type,base)	\
	inline	type							\
		(	KBNode			*node,			\
			cchar			*name,			\
			const QDict<QString>	&aList,			\
			uint			flags = 0		\
		)							\
		:							\
		base	(node, name, aList, flags)			\
	{								\
	}								\
	inline	type							\
		(	KBNode			*node,			\
			cchar			*name,			\
			cchar			*value,			\
			uint			flags = 0		\
		)							\
		:							\
		base	(node, name, value, flags)			\
	{								\
	}								\
	inline	type							\
		(	KBNode			*node,			\
			cchar			*name,			\
			KBNode			*extant,		\
			uint			flags = 0		\
		)							\
		:							\
		base	(node, name, extant, flags)			\
	{								\
	}								\
									\
	int	dummy	()	;

/*  KBATTRCTRINT							*/
/*  ------------							*/
/*  As above, but generates a constructor where the attribute is	*/
/*  derived from a KBAttrInt-derived class.				*/


#define	KBATTRINTDEF(type,base)	\
	inline	type							\
		(	KBNode			*node,			\
			cchar			*name,			\
			int			value,			\
			uint			flags = 0		\
		)							\
		:							\
		base	(node, name, value, flags)			\
	{								\
	}

#endif	// _KB_ATTR_H
