/***************************************************************************
    file	         : kb_tablechooser.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdlib.h>

#ifndef 	_WIN32
#include 	"kb_tablechooser.moc"
#else
#include 	"kb_tablechooser.h"
#endif

#include	"kb_serverinfo.h"


/*  KBTableChooser							*/
/*  KBTableChooser							*/
/*		: Constructor for table chooser				*/
/*  location	: KBLocation &	 : Database location			*/
/*  cbServer	: QComboBox &	 : Server selector			*/
/*  cbTable	: QComboBox &	 : Table selector			*/
/*  (returns)	: KBTableChooser :					*/

KBTableChooser::KBTableChooser
	(	KBLocation	&location,
		QComboBox	&cbServer,
		QComboBox	&cbTable
	)
	:
	location (location),
	cbServer (cbServer),
	cbTable  (cbTable)
{
	if (!location.dbInfo->findServer(KBLocation::m_pFile)->dbType().isEmpty())
		cbServer.insertItem (KBLocation::m_pFile) ;

	QListIterator<KBServerInfo> *svIter = location.dbInfo->getServerIter () ;
	KBServerInfo		    *svInfo ;

	while ((svInfo = svIter->current()) != 0)
	{
		cbServer.insertItem (svInfo->serverName()) ;
		(*svIter) += 1 ;
	}

	delete	svIter	;

	connect	(&cbServer, SIGNAL(activated     (const QString &)),
		 this,	    SLOT  (serverSelected(const QString &))) ;
	connect	(&cbTable,  SIGNAL(activated     (const QString &)),
		 this,	    SLOT  (tableSelected (const QString &))) ;

	serverSelected (cbServer.text(0)) ;
}

/*  KBTableChooser							*/
/*  serverSelected							*/
/*		: User selects a database server			*/
/*  svName	: const QString & : Server name				*/
/*  (returns)	: void		  :					*/

void	KBTableChooser::serverSelected
	(	const QString	&svName
	)
{
	KBDBLink		dbLink	;
	KBTableDetailsList	tabList	;

	cbTable .clear	()	;
	emit	serverChanged()	;

	if (svName == "")
		return	;

	if (!dbLink.connect (location, svName))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}
	if (!dbLink.listTables (tabList))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	cbTable.insertItem ("") ;

	for (uint idx = 0 ; idx < tabList.count() ; idx += 1)
		cbTable.insertItem (tabList[idx].m_name) ;

	emit	serverChanged	() ;
}

/*  KBTableChooser							*/
/*  tableSelected							*/
/*		: User selects a table					*/
/*  tabName	: const QString & : Table name				*/
/*  (returns)	: void		  :					*/

void	KBTableChooser::tableSelected
	(	const QString	&
	)
{
	emit	tableChanged	() ;
}

/*  KBTableChooser							*/
/*  setServer	: Set specifier server					*/
/*  svrName	: const QString & : Server name				*/
/*  (returns)	: bool		  : Server name valid			*/

bool	KBTableChooser::setServer
	(	const QString	&svrName
	)
{
	bool	rc	= false ;

	cbServer.setCurrentItem (0) ;

	for (int idx = 0 ; idx < cbServer.count() ; idx += 1)
		if (cbServer.text(idx) == svrName)
		{	cbServer.setCurrentItem (idx) ;
			serverSelected		(svrName) ;
			rc	= true	;
			break	;
		}

	emit serverChanged () ;
	return	rc ;
}

/*  KBTableChooser							*/
/*  setTable	: Set specifier table					*/
/*  tabName	: const QString & : Table name				*/
/*  (returns)	: bool		  : Table name valid			*/

bool	KBTableChooser::setTable
	(	const QString	&tabName
	)
{
	bool	rc	= false ;

	cbTable.setCurrentItem (0) ;

	for (int idx = 0 ; idx < cbTable.count() ; idx += 1)
		if (cbTable.text(idx) == tabName)
		{	cbTable.setCurrentItem	(idx) ;
			tableSelected		(tabName) ;
			rc	= true	;
			break	;
		}

	emit tableChanged () ;
	return	rc ;
}


/*  ------------------------------------------------------------------ */

/*  KBTableChooserDlg							*/
/*  KBTableChooserDlg							*/
/*		: Simple server/table selection dialog			*/
/*  location	: KBLocation &	    : Database location			*/
/*  (returns)	: KBTableChooserDlg :					*/

KBTableChooserDlg::KBTableChooserDlg
	(	KBLocation	&location
	)
	:
	_KBDialog("Pick server and table", true),
	location (location),
	cbServer (this),
	cbTable  (this),
	lServer  (this),
	lTable   (this),
	chooser	 (location, cbServer, cbTable),
	bOK	 (this),
	bCancel	 (this)
{
	layMain	  = new QGridLayout(this) ;
	layMain->addWidget (&lServer,  0, 0) ;
	layMain->addWidget (&cbServer, 0, 1) ;
	layMain->addWidget (&lTable,   1, 0) ;
	layMain->addWidget (&cbTable,  1, 1) ;
	layMain->addWidget (&bCancel,  2, 0) ;
	layMain->addWidget (&bOK,      2, 1) ;

	layMain->setMargin (8) ;
	layMain->setSpacing(4) ;

	lServer.setText (TR("Server")) ;
	lTable .setText (TR("Table" )) ;
	bCancel.setText (TR("Cancel")) ;
	bOK    .setText (TR("OK"    )) ;

	connect	 (&bOK,     SIGNAL(clicked()), this, SLOT(clickOK    ())) ;
	connect	 (&bCancel, SIGNAL(clicked()), this, SLOT(clickCancel())) ;
	connect  (&chooser, SIGNAL(changed()), this, SLOT(changed    ())) ;

	bOK.setEnabled  (false) ;
}

/*  KBTableChooserDlg							*/
/*  changed	: Selection changed					*/
/*  (returns)	: void		:					*/

void	KBTableChooserDlg::changed ()
{
	bOK.setEnabled (!cbServer.currentText().isEmpty() &&
			!cbTable .currentText().isEmpty()) ;
}

/*  KBTableChooserDlg							*/
/*  clickOK	: User clicks OK					*/
/*  (returns)	: void		:					*/

void	KBTableChooserDlg::clickOK ()
{
	done	(true)  ;
}

/*  KBTableChooserDlg							*/
/*  clickCancel	: User clicks cancel					*/
/*  (returns)	: void		:					*/

void	KBTableChooserDlg::clickCancel ()
{
	done	(false) ;
}
