/***************************************************************************
    file	         : kb_table.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_TABLE_H
#define	_KB_TABLE_H

#include	<qstringlist.h>
#include	"libkbase_exports.h"

class	KBSelect		;
class	KBTableUniqueList	;
class	KBTableInfoSet		;



/*  KBTable								*/
/*  -------								*/
/*  This class is used for a table node in a query description.	It is	*/
/*  used both directly in the XML definition of queries, and indirectly	*/
/*  when assembling queries for execution.				*/


class	LIBKBASE_API	KBTable : public KBNode
{
public	:

	enum	UniqueType
	{
		None		= 'X',
		Auto		= 'A',
		PrimaryKey	= 'P',
		AnyUnique	= 'U',
		AnySingle	= 'S',
		PreExpression	= 'B',
		PostExpression	= 'E',
#ifdef	__NOTYET
		Multiple	= 'M',
		TableSetup	= 'T',
#endif
		Legacy100	= 0
	}	;

private	:

	KBAttrStr	m_ident	  ;	/* Unique identifier		*/

	KBAttrStr	m_table	  ;	/* Name of the table		*/
	KBAttrStr	m_alias	  ;	/* Possible  alias		*/
	KBAttrStr	m_primary ;	/* Primary key column		*/
	KBAttrInt	m_ptype	  ;	/* Primary mode			*/
	KBAttrStr	m_pexpr	  ;	/* Primary expression		*/

	KBAttrStr	m_parent  ;	/* Parent identifier if any	*/
	KBAttrStr	m_field	  ;	/* Field used in join		*/
	KBAttrStr	m_field2  ;	/* Second field in join		*/
	KBAttrStr	m_where	  ;	/* Where criteria		*/
	KBAttrStr	m_order	  ;	/* Ordering criteria		*/
	KBAttrStr	m_jtype	  ;	/* Join type			*/

	KBAttrUInt	m_x	  ;
	KBAttrUInt	m_y	  ;
	KBAttrUInt	m_w	  ;
	KBAttrUInt	m_h	  ;

	QString		m_jexpr	  ;	/* Specific join expression	*/
	QString		m_unique  ;	/* Unique column to be used	*/
	uint		m_uflags  ;	/* Unique column flags		*/
	QString		m_uexpr	  ;	/* Unique column expression	*/

	bool		m_grouped ;	/* Table is in group expression	*/

public	:

	KBTable (KBNode *, const QDict<QString> &, bool * = 0) ;
	KBTable (KBNode *, const QString &, const QString &, const QString &,
			   const QString &, const QString &, const QString &,
			   const QString &, const QString &, const QString &,
			   uint = 0, uint = 0, uint = 0, uint = 0) ;
	KBTable (KBNode *, KBTable *) ;
virtual~KBTable () ;

	virtual	KBTable		*isTable () { return this ; }

	inline	QString	getIdent  () { return	m_ident  .getValue() ; }
	inline	QString	getTable  () { return	m_table  .getValue() ; }
	inline	QString	getAlias  () { return	m_alias  .getValue() ; }
	inline	QString	getParent () { return	m_parent .getValue() ; }
	inline	QString	getField  () { return	m_field  .getValue() ; }
	inline	QString	getField2 () { return	m_field2 .getValue() ; }
	inline	QString	getJType  () { return	m_jtype  .getValue() ; }
	inline	QString	getJExpr  () { return	m_jexpr		     ; }
	inline	QString	getUnique () { return	m_unique	     ; }

	inline	QString	getUnique
		(	uint		&uflags,
			QString		&uexpr
		)
	{
		uflags	= m_uflags ;
		uexpr	= m_uexpr  ;
		return	m_unique   ;
	}

	inline	UniqueType getUnique
		(	QStringList	&names,
			QString		&uexpr
		)
	{
		names	= QStringList::split(',', m_primary.getValue()) ;
		uexpr	= m_pexpr.getValue() ;
		return	(UniqueType)m_ptype.getIntValue() ;
	}


	/*  getQueryName						*/
	/*  Returns the name to use in a query, either the table alias	*/
	/* if there is one or the table name otherwise.			*/
	inline	QString	getName   ()
	{
		return	m_alias.getValue().isEmpty() ?
				m_table.getValue() :
				m_alias.getValue() ;
	}

	inline	QRect	geometry  ()
	{
		return	QRect
			(	m_x.getIntValue(),
				m_y.getIntValue(),
				m_w.getIntValue(),
				m_h.getIntValue()
			)	;
	}

	inline	void	setAlias	(const QString &alias  ) { m_alias  .setValue(alias  ) ; }
	inline	void	setParent	(const QString &parent ) { m_parent .setValue(parent ) ; }
	inline	void	setField	(const QString &field  ) { m_field  .setValue(field  ) ; }
	inline	void	setField2	(const QString &field2 ) { m_field2 .setValue(field2 ) ; }
	inline	void	setJType	(const QString &jtype  ) { m_jtype  .setValue(jtype  ) ; }
	inline	void	setJExpr	(const QString &jexpr  ) { m_jexpr  = jexpr	       ; }

	inline	void	setUnique
		(	const QString	&unique,
			uint		uflags,
			const QString	&uexpr
		)
	{
		m_unique	= unique	;
		m_uflags	= uflags	;
		m_uexpr		= uexpr		;
	}

	inline	void	setGrouped
		(	bool	grouped
		)
	{
		m_grouped = grouped	;
	}

	inline	bool	getGrouped ()
	{
		return	m_grouped	;
	}

	void		setGeometry	(QRect) ;
	void		getQueryInfo	(QList<KBTable> &) ;
	QString		getJoinText	(QList<KBTable> &, bool, KBTable * = 0, bool = false) ;
	QString		getOrderText	(bool = false) ;
	QString		getTableText	(bool = false) ;
	bool		getFieldList	(QList<KBFieldSpec> &, KBDBLink &, bool) ;

	void		addToSelect	(KBSelect &, bool) ;

	QString		getPrimary	() ;
	void		setPrimary	(const QString  &, UniqueType = PrimaryKey) ;

	virtual	KBNode	*replicate 	(KBNode *) ;

	static	KBTable	*findParent	(QList<KBTable> &, KBTable *) ;
	static	bool	blockUp		(QList<KBTable> &, KBTable *, QList<KBTable> &, KBError &) ;
	static	bool	blockUp		(QList<KBTable> &, QString,   QList<KBTable> &, KBError &) ;

#if	0
	static	UniqueType
			decodeUnique	(const QString  &, QStringList &) ;
#endif
}	;

#endif	// _KB_TABLE_H
