/***************************************************************************
    file	         : kb_tabber.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qwidget.h>
#include	<qcursor.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_display.h"
#include	"kb_sizer.h"
#include	"kb_popupmenu.h"
#include	"kb_nodereg.h"
#include	"kb_formcopier.h"
#include	"kb_layout.h"
#include	"kb_qttabber.h"
#include	"kb_attrdict.h"
#include	"kb_writer.h"
#include	"kb_ascii.h"

#if		! __KB_RUNTIME
#include	"kb_tabpagedlg.h"
#include	"kb_framerdlg.h"
#endif

#ifndef 	_WIN32
#include 	"kb_tabber.moc"
#else
#include 	"kb_tabber.h"
#endif



/*  KBTabberTab								*/
/*  -----------								*/
/*  Helper class used to record tab id/page pointer pairs, so that we	*/
/*  can map back and forth. The KBTabberBar class keeps a list of these	*/
/*  for all tabs.							*/

class	LIBKBASE_API KBTabberTab
{
public	:

	int		id	;
	KBTabberPage	*page	;

	inline	KBTabberTab
		(	int		id,
			KBTabberPage	*page
		)
		:
		id	(id),
		page	(page)
	{
	}
}	;

int	tabBarHeight ()
{
	static	int	_tabBarHeight	;

	if (_tabBarHeight == 0)
	{
		QTabBar *tabBar = new QTabBar (0)     ;
		QTab	*tabTab	= new QTab    ("Tab") ;
		tabBar->addTab(tabTab) ;
		_tabBarHeight	= tabBar->sizeHint().height() ;
		delete	tabBar	;

		fprintf
		(	stderr,
			"tabBarHeight: height=%d\n",
			_tabBarHeight
		)	;
	}

	return	_tabBarHeight ;
}

/*  KBTabberBar								*/
/*  KBTabberBar	: Consructor for tabber tab bar node			*/
/*  tabber	: KBTabber *	: Parent tabber				*/
/*  (returns)	: KBTabberBar	:					*/

KBTabberBar::KBTabberBar
	(	KBTabber  *tabber
	)
	:
	KBObject	(tabber, "KBTabberBar", QRect(0, 0, 0, tabBarHeight())),
	m_tabber	(tabber)
{
	xmode.setValue (FMStretch) ;
	ymode.setValue (FMFixed  ) ;
	m_tabBar = 0 ;
	m_tabList.setAutoDelete (true) ;
}


/*  KBTabberBar								*/
/*  KBTabberBar	: Consructor for tabber tab bar node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  tabber	: KBTabberBar *	: Extant tabber	bar			*/
/*  (returns)	: KBTabberBar	:					*/

KBTabberBar::KBTabberBar
	(	KBNode	  	*parent,
		KBTabberBar	*tabber
	)
	:
	KBObject	(parent, tabber),
	m_tabber		(parent->isTabber())
{
	xmode.setValue (FMStretch) ;
	ymode.setValue (FMStretch) ;
	m_tabBar = 0 ;
	m_tabList.setAutoDelete (true) ;
}

/*  KBTabberBar								*/
/*  ~KBTabberBar: Desructor for tabber tab bar node			*/
/*  (returns)	:		:					*/

KBTabberBar::~KBTabberBar ()
{
}

/*  KBTabberBar								*/
/*  buildCtrls	: Build GUI for this node				*/
/*  numrows	: uint		: Number of rows to be displayed	*/
/*  dx		: int		: X offset between rows			*/
/*  dy		: int		: Y offset between rows			*/
/*  (returns)	: void		:					*/

void	KBTabberBar::buildCtrls
	(	uint		numrows,
		int		dx,
		int		dy
	)
{
	KBObject::buildCtrls (numrows, dx, dy) ;

	if (m_tabBar == 0)
	{
		m_tabBar = new KBCtrlTabberBar (getDisplay(), this) ;
		setControl (m_tabBar) ;

		QRect	g   = geometry() ;
		g.setHeight (m_tabBar->sizeHint().height()) ;
		setGeometry (g) ;
	}

	m_tabBar->KBControl::setGeometry (geometry()) ;
	m_tabBar->setVisible  (true) ;
	setPalette 	    () ;
	setFont 	    () ;
}

/*  KBTabberBar								*/
/*  replicate	: Replicate this tabber bar					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New tabber node			*/

KBNode	*KBTabberBar::replicate
	(	KBNode	*_parent
	)
{
	return	new KBTabberBar (_parent, this) ;
}


/*  KBTabberBar								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBTabberBar::showAs
	(	KB::ShowAs	mode
	)
{
#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (getSizer() == 0))
	{
		extern	QCursor	cNoCursor	  ;

		KBSizerInfoSet	infoSet		  ;
		KBSizer::defaultInfoSet (infoSet) ;

		infoSet.trap	  = SZF_RIGHT|SZF_DBL	    ;
		infoSet.tl.proxy  = getParent()->isObject() ;
		infoSet.tr.proxy  = getParent()->isObject() ;
		infoSet.bl.flags  = 0		;
		infoSet.bl.cursor = &cNoCursor	;
		infoSet.br.flags  = 0		;
		infoSet.br.cursor = &cNoCursor	;

		setSizer
		(	new KBSizer
			(	this,
				getDisplay(),
				m_tabBar->mainWidget(),
				&infoSet
		)	)	;
	}

	if ((mode == KB::ShowAsData) && (getSizer() != 0))
		setSizer(0) ;
#endif

	for (int idx = 0 ; idx < m_tabBar->count() ; idx += 1)
		m_tabBar->setTabEnabled (m_tabList.at(idx)->id, true) ;

	/* Pass the request on down to the base class, which will in	*/
	/* turn recurse down to any children.				*/
	KBObject::showAs (mode) ;
}

/*  KBTabberBar								*/
/*  designPopup	: Handle design menu request				*/
/*  e		: QMouseEvent *	: Associated mouse event		*/
/*  drow	: uint		: Display row				*/
/*  (returns)	: void		:					*/

void	KBTabberBar::designPopup
	(	QMouseEvent	*e,
		uint		drow
	)
{
	m_tabber->designPopup (e, drow) ;
}

/*  KBTabberBar								*/
/*  getNumTabs	: Get the number of tabs				*/
/*  (returns)	: uint		: Number of tabs			*/

uint	KBTabberBar::getNumTabs ()
{
	return	m_tabBar->count () ;
}

/*  KBTabberBar								*/
/*  getCurrentTab: Get current tab					*/
/*  page	 : KBTabberPage *& : Current page			*/
/*  (returns)	 : int		   : Tab identifier or negative if none	*/

int	KBTabberBar::getCurrentTab
	(	KBTabberPage	*&page
	)
{
	int	id = m_tabBar->currentTab () ;

	LITER
	(	KBTabberTab,
		m_tabList,
		t,

		if (t->id == id)
		{	page	= t->page	;
			return	id		;
		}
	)

	page	= 0 ;
	return	-1  ;
}

/*  KBTabberBar								*/
/*  setCurrentTab: Set current by bay page				*/
/*  page	 : KBTabberPage & : Required page			*/
/*  (returns)	 : void		  :					*/

void	KBTabberBar::setCurrentTab
	(	KBTabberPage	*page
	)
{
	LITER
	(	KBTabberTab,
		m_tabList,
		t,

		if (t->page == page)
		{	m_tabBar->setCurrentTab (t->id) ;
			return	;
		}
	)
}

/*  KBTabberBar								*/
/*  tabSelected	: User selects a tab					*/
/*  id		: int		: Identifier for selected tab		*/
/*  (returns)	: void		:					*/

void	KBTabberBar::tabSelected
	(	int		id
	)
{
//	fprintf	(stderr, "KBTabberBar: user selects tab %d\n", id) ;

	LITER
	(	KBTabberTab,
		m_tabList,
		t,

		if (t->id == id)
		{	m_tabber->tabSelected (t->page) ;
			return	;
		}
	)
}

/*  KBTabberBar								*/
/*  addTab	: Add a new tab						*/
/*  label	: const QString & : Text for tab			*/
/*  page	: KBTabberPage *  : Associated tab page			*/
/*  adding	: bool		  : New tab is being added		*/
/*  (returns)	: int		  : New tab identifier			*/

int	KBTabberBar::addTab
	(	const QString	&label,
		KBTabberPage	*page,
		bool		adding
	)
{
	int	id = m_tabBar->addTab (label) ;
	if (id < 0) return -1 ;

	m_tabList.append (new KBTabberTab (id, page)) ;

	if (adding)
	{
		m_tabBar->repaint	(true) ;
		m_tabBar->setCurrentTab (id)   ;
	}

	return	id	;
}

/*  KBTabberBar								*/
/*  setTabText	: Set text for specified tab				*/
/*  label	: const QString & : Text for tab			*/
/*  page	: KBTabberPage *  : Associated tab page			*/
/*  (returns)	: int		  : New tab identifier			*/

void	KBTabberBar::setTabText
	(	const QString	&label,
		KBTabberPage	*page
	)
{
	LITER
	(	KBTabberTab,
		m_tabList,
		t,

		if (t->page == page)
		{	m_tabBar->setTabText (t->id, label) ;
			m_tabBar->repaint    (true) ;
			return	;
		}
	)
}

/*  KBTabberBar								*/
/*  removeTab	: Remove tab corresponding to page			*/
/*  page	: KBNode *	: Page in question			*/
/*  (returns)	: void		:					*/

void	KBTabberBar::removeTab
	(	KBNode		*page
	)
{
	LITER
	(	KBTabberTab,
		m_tabList,
		t,

		if (t->page == page)
		{	m_tabBar->removeTab (t->id) ;
			m_tabList.remove    (t)	  ;
			break	 ;
		}
	)

	m_tabBar->repaint (true) ;

	if (m_tabList.count() > 0)
	{
		m_tabBar->setCurrentTab (m_tabList.at(0)->id  ) ;
		m_tabber->tabSelected   (m_tabList.at(0)->page) ;
	}
}

/*  KBTabber								*/
/*  setPageEnabled							*/
/*		: Enable/disable a page					*/
/*  page	: KBTabberPage *: Page in question			*/
/*  enabled	: bool		: True to enable			*/
/*  (returns)	: void		:					*/

void	KBTabberBar::setPageEnabled
	(	KBTabberPage	*page,
		bool		enabled
	)
{
	if (m_tabBar != 0)
		LITER
		(	KBTabberTab,
			m_tabList,
			tab,

			if (tab->page == page)
			{	m_tabBar->setTabEnabled (tab->id, enabled) ;
				break	;
			}
		)
}

/*  KBTabber								*/
/*  printPages	: Output node XML					*/
/*  text	: QString &	: Result string				*/
/*  indent	: int		: Indent level of this node		*/
/*  (returns)	: void		:					*/

void	KBTabberBar::printPages
	(	QString		&text,
		int		indent
	)
{
	LITER
	(	KBTabberTab,
		m_tabList,
		tab,
		tab->page->printNode (text, indent + 2)
	)
}


/*  ------------------------------------------------------------------  */

/*  KBTabber								*/
/*  KBTabber	: Constructor for Tabber node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  element	: cchar *	: Element name				*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBTabber	:					*/

KBTabber::KBTabber
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBFramer	(parent, aList, "KBTabber", ok),
	m_initPage	(this,	 "initpage", aList)
{
	m_tabberBar = new KBTabberBar (this) ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::framerPropDlg (this, attribs, 0))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}
#endif
}

/*  KBTabber								*/
/*  KBTabber	: Consructor for Tabber node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  tabber	: KBTabber *	: Extant Tabber				*/
/*  (returns)	: KBTabber	:					*/

KBTabber::KBTabber
	(	KBNode	  *parent,
		KBTabber  *tabber
	)
	:
	KBFramer	(parent, tabber),
	m_initPage	(this,	 "initpage", tabber)
{
	m_tabberBar = new KBTabberBar (this) ;
}

/*  KBTabber								*/
/*  KBTabber	: Desructor for tabber node				*/
/*  (returns)	:		:					*/

KBTabber::~KBTabber ()
{
}

/*  KBTabber								*/
/*  replicate	: Replicate this Tabber					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New tabber node			*/

KBNode	*KBTabber::replicate
	(	KBNode	*_parent
	)
{
	return	replicateBelow (new KBTabber (_parent, this)) ;
}

/*  KBTabber								*/
/*  buildCtrls	: Build display for this node				*/
/*  numrows	: uint		: Number of rows			*/
/*  dx		: int		: X-delta				*/
/*  dy		: int		: X-delta				*/
/*  (returns)	: void		:					*/

void	KBTabber::buildCtrls
	(	uint	numrows,
		int	dx,
		int	dy
	)
{
	int	 th	= m_tabberBar->geometry().height() ;

	CITER
	(	TabberPage,
		page,
		page->setOffset (th) ;
	)

	KBFramer::buildCtrls (numrows, dx, dy) ;
}

/*  KBTabber								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBTabber::showAs
	(	KB::ShowAs	mode
	)
{
	if (m_tabberBar->getNumTabs() == 0)
		CITER
		(	TabberPage,
			page,
			m_tabberBar->addTab (page->getAttrVal("tabtext"), page) ;
		)

	KBFramer::showAs (mode) ;

	KBTabberPage	*defPage = 0 ;
	QString		initPage = m_initPage.getValue() ;

	CITER
	(	TabberPage,
		page,

		if (!initPage.isEmpty() && (page->getName() == initPage))
		{
			defPage	= page	;
			break	;
		}

		if (defPage == 0)
			defPage	= page	;
	)

	if (defPage != 0)
	{ 
		tabSelected (defPage) ;
		m_tabberBar->setCurrentTab (defPage) ;
	}
}

/*  KBTabber								*/
/*  printNode	: Output node XML					*/
/*  text	: QString &	: Result string				*/
/*  indent	: int		: Indent level of this node		*/
/*  (returns)	: void		:					*/

void	KBTabber::printNode
	(	QString	&text,
		int	indent
	)
{
	QString		nodeText ;

	text	+= QString("%1<%2").arg("", indent).arg(getElement()) ;

	for (uint idx = 0 ; idx < attribs .count () ; idx += 1)
		attribs.at(idx)->printAttr(text, nodeText, indent + 2) ;

	/* The child printing is handled via the tabber bar, since the	*/
	/* nodes must be output in the order they appear, which may not	*/
	/* be the original order.					*/
	if (children.count() > 0)
	{
		text	+= ">\n" ;
		m_tabberBar->printPages (text, indent + 2) ;
		text	+= nodeText ;
		text	+= QString("%1</%2>\n").arg("", indent).arg(getElement()) ;
	}
	else	text	+= "/>\n" ;
}

/*  KBTabber								*/
/*  tabSelected	: User selects a tab					*/
/*  (returns)	: void		:					*/

void	KBTabber::tabSelected
	(	KBTabberPage	*page
	)
{
//	fprintf	(stderr, "KBTabber: page %d selected\n", page) ;

	CITER
	(	TabberPage,
		f,
		if (f == page) f->setVisible (true ) ;
	)
	CITER
	(	TabberPage,
		f,
		if (f != page) f->setVisible (false) ;
	)

}

/*  KBTabber								*/
/*  newPage	: Add new page						*/
/*  (returns)	: void		:					*/

void	KBTabber::newPage ()
{
#if	! __KB_RUNTIME
	KBAttrDict aDict ;
	bool	   ok	 ;

//	aDict.addValue
//	(	"y", 
//		tabberBar->geometry().height()
//	)	;
	aDict.addValue
	(	"tabtext",
		QString("Page %1").arg(m_tabberBar->getNumTabs() + 1)
	)	;

	KBTabberPage *page = new KBTabberPage
			     (		this,
					aDict,
					"KBTabberPage",
					&ok
			      )	;

	if (ok)
	{
		page->buildDisplay (frmDisp) ;
		page->showAs    (KB::ShowAsDesign) ;
		page->getContainer()->show() ;

		getLayout()->setChanged() ;

		m_tabberBar->addTab (page->getAttrVal("tabtext"), page, true) ;
		tabSelected (page) ;
	}
#endif
}

/*  KBTabber								*/
/*  setPageOrder: Handle reordering of pages				*/
/*  (returns)	: void		:					*/

void	KBTabber::setPageOrder ()
{
#if	! __KB_RUNTIME

	QList<KBTabberPage>	pageList ;

	CITER
	(	TabberPage,
		page,
		pageList.append (page)
	)

	if (!KBTabPageDlg(pageList).exec()) return ;

	CITER
	(	TabberPage,
		page,
		m_tabberBar->removeTab (page)
	)

	LITER
	(	KBTabberPage,
		pageList,
		page,
		m_tabberBar->addTab (page->getAttrVal("tabtext"), page)
	)

	getLayout()->setChanged() ;
#endif
}

/*  KBTabber								*/
/*  designPopup	: Handle design menu request				*/
/*  e		: QMouseEvent *	: Associated mouse event		*/
/*  drow	: uint		: Display row				*/
/*  (returns)	: void		:					*/

void	KBTabber::designPopup
	(	QMouseEvent	*,
		uint
	)
{
	static Qt::ButtonState	bState ;

	KBPopupMenu  popupMain	(&bState) ;
	KBPopupMenu *popupEdit	= new KBPopupMenu (&bState) ;

	KBNode	*cpyNode	= 0 	;
	bool	noIns		= !KBFormCopier::self()->anyCopied(cpyNode) ;
	bool	noPage		= true	;

	if (cpyNode != 0) noIns = cpyNode->isTabberPage() == 0 ;

	CITER (TabberPage, t, noPage = false ; break)

	popupEdit->insertEntry (false,	TR("C&ut"),	 	this, SLOT(cutObj   	())) ;
	popupEdit->insertEntry (false,	TR("&Copy"),		this, SLOT(copyObj  	())) ;
	popupEdit->insertEntry (noIns,  TR("&Paste page"),	this, SLOT(pasteObjects	())) ;
	popupEdit->insertEntry (false,	TR("&Delete"),		this, SLOT(deleteObj	())) ;
 
	popupMain .insertItem  (TR("Cancel")) ;
	popupMain .insertItem  (TR("&Edit"), popupEdit) ;
	popupMain .insertItem  (TR("&New Page"), this, SLOT(newPage()), 0, 0) ;

	popupMain .insertEntry (noPage, TR("Set page order"),	this, SLOT(setPageOrder ())) ;

	popupMain .insertItem  (TR("Tabber properties"),	this, SLOT(framerPropDlg())) ;
	popupMain .insertItem  (TR("Block properties"),		this, SLOT(blockPropDlg ())) ;
	popupMain .insertItem  (TR("&Document properties"),	this, SLOT(docPropDlg   ())) ;

//	insertAt	= e->pos ()	 ;
//	newRect		= QRect  ()	 ;
	popupMain .exec	(QCursor::pos()) ;
}

/*  KBTabber								*/
/*  framerSetup	: Set up prior to execution				*/
/*  _query	: KBQryBase *	: Associated query			*/
/*  _qryLvl	: uint		: Level in query			*/
/*  _blkInfo	: KBBlockInfo *	: Block information			*/
/*  (returns)	: bool		: Success				*/

bool	KBTabber::framerSetup
	(	KBQryBase	*_query,
		uint		_qryLvl,
		KBBlockInfo	*_blkInfo
	)
{
	return	KBFramer::framerSetup (_query, _qryLvl, _blkInfo) ;
}

/*  KBTabber								*/
/*  setTabText	: Set tab text for specified page			*/
/*  page	: KBTabberPage * : Page in question			*/
/*  tabText	: QString	 : Tab text				*/
/*  (returns)	: void		 :					*/

void	KBTabber::setTabText
	(	KBTabberPage	*page,
		QString		tabText
	)
{
	m_tabberBar->setTabText (tabText, page) ;
}

/*  KBTabber								*/
/*  remChild	: Child node being removed				*/
/*  node	: KBNode *	: Node in question			*/
/*  (returns)	: void		:					*/

void	KBTabber::remChild
	(	KBNode		*node
	)
{
	/* Intercept this method so that we can remove the table which	*/
	/* corresponds to the page					*/
	m_tabberBar->removeTab (node) ;
	KBNode::remChild (node) ;
}

void	KBTabber::setPageEnabled
	(	KBTabberPage	*page,
		bool		enabled
	)
{
	m_tabberBar->setPageEnabled (page, enabled) ;
}

void	KBTabber::setCurrentPage
	(	KBTabberPage	*page
	)
{
	m_tabberBar->setCurrentTab (page) ;
}

/*  KBTabber								*/
/*  write	: Write tabber 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  offset	: QPoint	: Offset into writer			*/
/*  first	: bool		: First control flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBTabber::write
	(	KBWriter	*writer,
		QPoint		offset,
		bool		first,
		int		&extra
	)
{
	QString	bgcolor	;
	bgcolor.sprintf	("0x%06x", frmDisp->getDisplayWidget()->backgroundColor().rgb() & 0x00ffffff) ;

	new KBWriterBG  (writer, geometry(offset), bgcolor) ;

#if	! __KB_RUNTIME
	if (showingDesign())
		new KBWriterBox (writer, geometry(offset)) ;
#endif

	QPoint		s	= writer->setOffset (false, geometry().topLeft()) ;
	KBTabberPage	*page	;

	if (m_tabberBar->getCurrentTab (page) >= 0)
		page->write  (writer, offset, first, extra) ;

	m_tabberBar->write     (writer, offset, first, extra) ;
	writer     ->setOffset (true, s)  ;

	return	true	;
}

#if	! __KB_RUNTIME

/*  KBTabber								*/
/*  playerAdd	: Perform addition from a score				*/
/*  action	: const QString		: Action			*/
/*  args	: const QStringList &	: Arguemnts			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	; bool			: Success			*/

bool	KBTabber::playerAdd
	(	const QStringList	&args,
		KBError			&pError
	)
{
	if (args[1] == "KBTabberPage")
	{
		setCtrlRect
		(	QRect
			(	args[2].toInt(), args[3].toInt(),
				args[4].toInt(), args[5].toInt()
		)	)	;

		newPage	()	;
		return	true	;

	}

	return	KBFramer::playerAdd (args, pError) ;
}
#endif

NEWNODE(Tabber, __TR("New &Tab control"), KF_FORM|KF_BLOCK|KF_STATIC)
