/***************************************************************************
    file	         : kb_report.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		_WIN32
#include	"kb_report.moc"
#else
#include	"kb_report.h"
#endif

#include	"kb_script.h"
#include	"kb_import.h"
#include	"kb_param.h"
#include	"kb_display.h"
#include	"kb_sizer.h"
#include	"kb_writer.h"
#include	"kb_framer.h"
#include	"kb_popupmenu.h"


/*  KBReport								*/
/*  KBReport	: Constructor for report root class for extant report	*/
/*  location	: KBLocation &	 : Report location			*/
/*  aList	: const QDict<QString> &				*/
/*				 : List of attributes			*/
/*  (returns)	: KBReport	 :					*/

KBReport::KBReport
	(	KBLocation		&location,
		const QDict<QString>	&aList
	)
	:
	KBReportBlock	(0,     aList,       "KBReport"),
	KBLayout	(this),
	m_language	(this,  "language",  aList     ),
	m_caption	(this,  "caption",   aList     ),
	m_modal		(this,  "modal",     aList     ),
	m_printer	(this,  "printer",   aList     ),
	m_printdlg	(this,  "printdlg",  aList     ),
	m_lMargin	(this,  "lmargin",   aList     ),
	m_rMargin	(this,  "rmargin",   aList     ),
	m_tMargin	(this,  "tmargin",   aList     ),
	m_bMargin	(this,  "bmargin",   aList     ),
	m_docRoot	(this,  children,    location  )
{
	root		= this	;
	m_display	= 0     ;
	m_writer	= 0	;
}

#if	! __KB_RUNTIME
/*  KBReport								*/
/*  KBReport	: Constructor for report root class for new report	*/
/*  location	: KBLocation &	 : Report location			*/
/*  aList	: const QDict<QString> &				*/
/*				 : List of attributes			*/
/*  _ok		: bool &	 : Success				*/
/*  (returns)	: KBReport	 :					*/

KBReport::KBReport
	(	KBLocation		&location,
		const QDict<QString>	&aList,
		bool			&_ok
	)
	:
	KBReportBlock	(0,	  aList,   "KBReport"),
	KBLayout	(this),
	m_language	(this,  "language",	aList     ),
	m_caption	(this,  "caption",	aList     ),
	m_modal		(this,  "modal",	aList     ),
	m_printer	(this,  "printer",	aList     ),
	m_printdlg	(this,  "printdlg",	aList     ),
	m_lMargin	(this,  "lmargin",	aList     ),
	m_rMargin	(this,  "rmargin",	aList     ),
	m_tMargin	(this,  "tmargin",	aList     ),
	m_bMargin	(this,  "bmargin",	aList     ),
	m_docRoot	(this,  children,	location  )
{
	root		= this ;
	m_display	= 0    ;
	m_writer	= 0    ;

	if (!propertyDlg ())
	{	_ok	= false ;
		return	;
	}

	if (!blockPropDlg ())
	{	_ok	= false ;
		return	;
	}

	addFramers ()	;
	KBLayout::setChanged ()	;
	_ok	= true	;
}
#endif

/*  KBReport								*/
/*  ~KBReport	: Destructor for report root class			*/
/*  (returns)	:		:					*/

KBReport::~KBReport ()
{
	showMonitor ((QListView *)0) ;
}

/*  KBReport								*/
/*  printNode	: Output node XML					*/
/*  text	: QString &	: Resulting text			*/
/*  indent	: int		: Indent level of this node		*/
/*  (returns)	: void		:					*/

void	KBReport::printNode
	(	QString	&text,
		int	indent
	)
{
	extern	QString	kbXMLEncoding () ;
	QString		nodeText ;

	/* Implement this specially, since we need to output the XML	*/
	/* header. Also output script stuff and paramaters near the	*/
	/* front.							*/
	text	+= QString
		   (	"<?xml version=\"1.0\" encoding=\"%1\"?>\n"
			"<!DOCTYPE KBaseReport SYSTEM \"kbasereport.dtd\">\n"
		   )
		   .arg	(kbXMLEncoding()) ;

	text	+= QString("%1<%2").arg("", indent).arg(getElement()) ;
	for (uint idx = 0 ; idx < attribs .count () ; idx += 1)
		attribs.at(idx)->printAttr(text, nodeText, indent + 2) ;
	text	+= ">\n" ;

	CITER	(Script, s, s->printNode (text, indent+2))
	CITER	(Param,  p, p->printNode (text, indent+2))

	LITER
	(	KBNode,
		KBNode::children,
		child,
		{
			if (child->isScript ()) continue ;
			if (child->isParam  ()) continue ;
			child->printNode (text, indent+2)  ;
		}
	)

	text	+= nodeText ;
	text	+= QString("%1</%2>\n").arg("", indent).arg(getElement()) ;
}


/*  KBReport								*/
/*  requery	: Re-execute top-level query				*/
/*  (returns)	: bool		  : Success				*/

bool	KBReport::requery ()
{
	if (!KBReportBlock::requery ()) return false ;
	if (!KBReportBlock::showData()) return false ;

	/* Success .....						*/
	return	true	;
}

/*  KBReport								*/
/*  resize	: Handle resize in design mode				*/
/*  size	: QSize		: Raw size				*/
/*  (returns)	: void		:					*/

void	KBReport::resize
	(	QSize	size
	)
{
#if	! __KB_RUNTIME
	if (showingDesign())
	{
		KBObject::resize (size.width(), size.height()) ;
		getDisplay ()->resize (size.width(), size.height()) ;
		KBLayout::setChanged () ;
	}
#endif
}

/*  KBReport								*/
/*  showData	: Show report in data mode				*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  writer	: KBWriter *	  : Writer used for output		*/
/*  pDict	: QDict<QString>& : Paramater dictionary		*/
/*  key		: const KBValue	& : Parent key				*/
/*  size	: QSize &	  : Return required size		*/
/*  printing	: bool		  : Actually printing			*/
/*  (returns)	: KB::ShowRC	  : Startup return code			*/

KB::ShowRC
	KBReport::showData
	(	QWidget			*parent,
		KBWriter		*writer,
		const QDict<QString>	&pDict,
		const KBValue		&key,
		QSize			&size,
		bool			printing
	)
{
	/* In the event of any error while starting up, we switch to	*/
	/* design mode, and indicate this to the called via the return	*/
	/* code.							*/
	bool	   ok	  ;
	KBError	   error  ;
	KB::ShowRC rc	  ;

	m_writer = writer ;

	fprintf
	(	stderr,
		"KBReport::showData: p=[%s] d=[%d] p=[%d]\n",
		(cchar *)m_printer.getValue (),
		m_printdlg.getBoolValue(),
		printing
	)	;

	ok = m_writer->setup
	     (		m_printer .getValue    (),
			m_printdlg.getBoolValue(),
			m_lMargin .getIntValue (),
			m_rMargin .getIntValue (),
			m_tMargin .getIntValue (),
			m_bMargin .getIntValue (),
			printing
  	     ) ;
	if (!ok) return	KB::ShowRCCancel ;

	writer->setReport () ;


	m_parentKey = key ;
	fprintf
	(	stderr,
		"KBReport::showData: key=[%s]\n",
		(cchar *)m_parentKey.getRawText()
	)	;

	/* Reset the document root object (which, for instance, clears	*/
	/* an extant scripting interface), then load any scripting for	*/
	/* the report.							*/
	m_docRoot.reset 	()	  ;
	m_docRoot.loadScripting (ok, error) ;

	if (!ok)
	{	setError (error)	  ;
		return	 showDesign (parent, size) ;
	}


	/* We can now set the parameter dictionary (which may invoke	*/
	/* scripts for default values). This may return indicating an	*/
	/* error or that the user cancelled.				*/
	rc = m_docRoot.setParamDict (pDict, error) ;

	if (rc != KB::ShowRCOK)
	{
		if (rc == KB::ShowRCCancel)
			return	rc ;

		if (showDesign (parent, size) != KB::ShowRCDesign)
			return	KB::ShowRCError ;

		setError (error) ;
		return	 rc ;
	}


	/* Next run the block setup. This may pick up parameter values	*/
	/* that are now set.						*/
	if (!blockSetup ())
		return	showDesign (parent, size) ;


	/* Then build the GUI and sort out the geometry. The returned	*/
	/* size is the size needed by the display. Actually, in report	*/
	/* data view there is no real GUI, but the call stitches stuff	*/
	/* together, and the user may later switch to design view.	*/
	if (m_display == 0)
	{
		m_display = new KBDisplay (parent, this, false, false, true) ;
		buildTopDisplay (m_display) ;
		buildCtrls      (0, 0, 0  ) ;
	}

	KBReportBlock::showAs (KB::ShowAsData) ;
	size	= m_writer->getSize () ;

	/* Just about there. Add all items to the queries, and then	*/
	/* run the query; this is the bit that will actually generate	*/
	/* the report.							*/
	if (!addAllItems())
	{
		setError
		(	KBError::Error,
			TR
			(	"Report contains blocks which retrieve no values"
			),
			TR
			(	"At least one field in each block should "
				"have a non-empty display expression"
			),
			__ERRLOCN
		)	;
		return	showDesign (parent, size) ;
	}

	if (!requery ())
		return showDesign (parent, size) ;

	m_writer->showPage (0) ;
	return	KB::ShowRCData ;
}

/*  KBReport								*/
/*  showDesign	: Show report in design mode				*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  size	: QSize &	  : Return required size		*/
/*  (returns)	: KB::ShowRC	  : Startup return code			*/

KB::ShowRC
	KBReport::showDesign
	(	QWidget		*parent,
		QSize		&size
	)
{
#if	__KB_RUNTIME

	return	KB::ShowRCError ;

#else

	/* Next run the block setup. This links blocks to queries and	*/
	/* such.							*/
	if (!blockSetup ())
		return	KB::ShowRCError  ;

	/* Then build the GUI and sort out the geometry. The returned	*/
	/* size is the size needed by the design display.		*/
	if (m_display == 0)
	{
		m_display = new KBDisplay (parent, this, false, false, true) ;
		buildTopDisplay (m_display) ;
		buildCtrls      (0, 0, 0  ) ;
	}

#if	! __KB_RUNTIME
	KBLayout     ::clear      (true)  ;
	KBLayout     ::initSizer  ()	  ;
#endif
	KBReportBlock::showAs     (KB::ShowAsDesign) ;

	QScrollView *scroller = m_display->getScroller ()      ;
	size	= m_display->getSizeNeeded (geometry().size()) ;

	scroller->resizeContents (1600, 1600) ;
	size	+= QSize (100, 100) ;

	return	KB::ShowRCDesign ;
#endif
}

/*  KBReport								*/
/*  objType	: Get object type for this node				*/
/*  (returns)	: KB::ObjType	: Object type				*/

KB::ObjType KBReport::objType ()
{
	return	KB::ObjReport	;
}

/*  KBReport								*/
/*  getBlockVal	: Get block value pointer				*/
/*  (returns)	: KBValue *	: Value pointer or null at top level	*/

KBValue	*KBReport::getBlockVal ()
{
	if (!cexpr.getValue().isEmpty() && !m_parentKey.isNull())
	{
		fprintf
		(	stderr,
			"KBReport::getBlockVal: returns [%s]\n",
			(cchar *)m_parentKey.getRawText()
		)	;
		return	&m_parentKey ;
	}

	return	KBReportBlock::getBlockVal() ;
}

/*  KBReport								*/
/*  margins	: Get margin settings					*/
/*  left, ...	: int &, ...	: Return margins			*/
/*  (returns)	: void		:					*/

void	KBReport::margins
	(	int		&left,
		int		&right,
		int		&top,
		int		&bottom
	)
{
	left	= m_lMargin.getIntValue() ;
	right	= m_rMargin.getIntValue() ;
	top	= m_tMargin.getIntValue() ;
	bottom	= m_bMargin.getIntValue() ;
}

/*  KBReport								*/
/*  margins	: Get margin settings					*/
/*  left, ...	: int &, ...	: Return margins			*/
/*  (returns)	: void		:					*/

void	KBReport::margins
	(	int		&left,
		int		&top
	)
{
	left	= m_lMargin.getIntValue() ;
	top	= m_tMargin.getIntValue() ;
}

#if	! __KB_RUNTIME

/*  KBReport								*/
/*  makeFramerPopup							*/
/*		: Make popup menu for a framer				*/
/*  framer	: KBFramer *	    : Framer in question		*/
/*  bState	: QT::ButtonState & : Button state return location	*/
/*  (returns)	: KBPopupMenu *	    : Popup menu			*/

KBPopupMenu
	*KBReport::makeFramerPopup
	(	KBFramer	*framer,
		Qt::ButtonState	*bState
	)
{
	extern void 	makeReportMenu (QPopupMenu *, QObject *, uint) ;

	KBPopupMenu	*newPopup = new KBPopupMenu (bState) ;

	makeReportMenu (newPopup, framer, KF_FRAMER|KF_STATIC|KF_DATA) ;

	newPopup->insertSeparator () ;
	newPopup->insertEntry     (false,  TR("Paste component"), framer, SLOT(pasteComponent())) ;
	newPopup->insertEntry     (false,  TR("Link component"),  framer, SLOT(linkComponent ())) ;
	return	newPopup ;
}

/*  KBReport								*/
/*  propertyDlg	: Run root property dialog				*/
/*  (returns)	: bool		: Success					*/

bool	KBReport::propertyDlg ()
{
	QList<KBModule>	scripts	;
	QList<KBModule>	imports	;
	QList<KBParam > params  ;

	cchar		*btstr	= getBlkType() == KBBlock::BTNull  ? "null"  :
				  getBlkType() == KBBlock::BTTable ? "table" :
				  getBlkType() == KBBlock::BTSQL   ? "sql"   :
				  getBlkType() == KBBlock::BTQuery ? "query" : "" ;

	KBAttrStr	mattr	(this, "modlist",      "", KAF_SYNTHETIC) ;
	KBAttrStr	iattr	(this, "implist",      "", KAF_SYNTHETIC) ;
	KBAttrStr	pattr	(this, "paramlist",    "", KAF_SYNTHETIC) ;
	KBAttrStr	tattr	(this, "blktype",   btstr, KF_REQD) ;

	CITER
	(	Script,
		s,
		scripts.append (s)
	)
	CITER
	(	Import,
		i,
		imports.append (i)
	)
	CITER
	(	Param,
		p,
		params .append (p)
	)

	if (!::reportPropDlg (this, "Report", attribs, scripts, imports, params))
		return false ;

	if (tattr.getValue() != btstr)
	{
		bool	rc = false ;

		if	(tattr.getValue() == "null" ) rc = setBlkType (KBBlock::BTNull ) ;
		else if	(tattr.getValue() == "table") rc = setBlkType (KBBlock::BTTable) ;
		else if	(tattr.getValue() == "sql"  ) rc = setBlkType (KBBlock::BTSQL  ) ;
		else if	(tattr.getValue() == "query") rc = setBlkType (KBBlock::BTQuery) ;

		if (!rc) return false ;
	}

	setGeometry (geometry ()) ;

	CITER
	(	Object,
		o,
		o->setGeometry (o->geometry())
	)

	if (getContainer() != 0)
		getContainer()->getDisplayWidget()->repaint() ;

	KBLayout::setChanged ()	;
	return	true	;
}
#endif
