/***************************************************************************
    file	         : kb_passdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>

#include	"kb_classes.h"

#ifndef		_WIN32
#include	"kb_passdlg.moc"
#else
#include	"kb_passdlg.h"
#endif


/*  KBPassDlg								*/
/*  KBPassDlg	: Constructor for username/password dialog		*/
/*  caption	: const QString & : Dialog caption			*/
/*  legend	: const QString & : Dialog legend			*/
/*  userName	: const QString & : Default user name			*/
/*  password	: const QString & : Default password			*/
/*  (returns)	: KBPassDlg	  :					*/

KBPassDlg::KBPassDlg
	(	const QString	&caption,
		const QString	&legend,
		const QString	&userName,
		const QString	&password
	)
	:
	_KBDialog	(caption, true),
	m_legend	(this),
	m_labUserName	(this),
	m_userName	(this),
	m_labPassword	(this),
	m_password	(this),
	m_showPassword	(this),
	m_bOK		(this),
	m_bCancel	(this)
{
	QVBoxLayout *layMain	= new QVBoxLayout (this) ;
	layMain->addWidget (&m_legend) ;

	m_legend.setText (legend) ;

	QGridLayout *layGrid	= new QGridLayout (layMain) ;
	layGrid->addWidget (&m_labUserName, 0, 0) ;
	layGrid->addWidget (&m_userName,    0, 1) ;
	layGrid->addWidget (&m_labPassword, 1, 0) ;
	layGrid->addWidget (&m_password,    1, 1) ;

	layMain->addWidget (&m_showPassword) ;

	QHBoxLayout *layButt	= new QHBoxLayout (layMain) ;
	layButt->addStretch()	;
	layButt->addWidget (&m_bOK    ) ;
	layButt->addWidget (&m_bCancel) ;

	m_labUserName .setText (TR("User name"	  )) ;
	m_labPassword .setText (TR("Password "	  )) ;
	m_showPassword.setText (TR("Show password")) ;
	m_bOK	      .setText (TR("OK"		  )) ;
	m_bCancel     .setText (TR("Cancel"	  )) ;

	m_userName    .setText (userName) ;
	m_password    .setText (password) ;

	m_password.setEchoMode (TKLineEdit::Password) ;

	connect	(&m_bOK,     SIGNAL(clicked()), SLOT(clickOK    ())) ;
	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;

	connect	(&m_showPassword, SIGNAL(toggled(bool)), SLOT(showChanged())) ;
}

KBPassDlg::~KBPassDlg ()
{
}

void	KBPassDlg::clickOK ()
{
	done	(1) ;
}

void	KBPassDlg::clickCancel ()
{
	done	(0) ;
}

void	KBPassDlg::showChanged ()
{
	m_password.setEchoMode
	(	m_showPassword.isChecked() ?
			TKLineEdit::Normal : TKLineEdit::Password
	)	;
}
