/***************************************************************************
    file	         : kb_paramsetdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_PARAMSETDLG_H
#define	_KB_PARAMSETDLG_H

#include	<qapplication.h>
#include	<qdialog.h>
#include	<qlayout.h>
#include	<qpushbutton.h>

#include	"libkbase_exports.h"

#include	"kb_classes.h"
#include	"kb_node.h"
#include	"kb_dialog.h"

#include	"tk_lineedit.h"

/*  KBParamSet								*/
/*  ----------								*/
/*  Simple class to contain values associated with a parameter		*/

class LIBKBASE_API	KBParamSet
{
public	:

	QString		m_legend	;
	QString		m_defval	;
	QString		m_value		;
	QString		m_format	;
	bool		m_prompt	;

	bool		m_set		;

	inline	KBParamSet
		(	const QString	&legend,
			const QString	&defval,
			const QString	&value,
			const QString	&format,
			bool		prompt
		)
		:
		m_legend 	(legend),
		m_defval 	(defval),
		m_value  	(value),
		m_format	(format),
		m_prompt	(prompt)
	{
		m_set		= false ;
	}

}	;

/*  KBParamSetDlg							*/
/*  -------------							*/
/*  This dialog is used to set parameters values.			*/

class LIBKBASE_API	KBParamSetDlg : public _KBDialog
{
	Q_OBJECT

	KBDocRoot		*m_docRoot	;

	QVBoxLayout		m_layMain	;
	QGridLayout		m_layParams	;
	QHBoxLayout		m_layButtons	;

	QPushButton		m_bOK		;
	QPushButton		m_bCancel	;

	QList<KBParamSet>	m_params	;
	QList<TKLineEdit >	m_values	;

	bool			m_anyParams	;

	QString		getScriptValue	(const QString &, KBError &, bool &) ;

protected slots :

	virtual	void	clickOK		()	;
	virtual	void	clickCancel	()	;

public	:


	KBParamSetDlg (QString, QDict<KBParamSet> &, KBDocRoot *, KBError &, bool &) ;
       ~KBParamSetDlg () ;

	inline	bool	anyParams	()
	{
		return	m_anyParams	;
	}
}	;

#endif	// _KB_PARAMSETDLG_H
