/***************************************************************************
    file	         : kb_overridedlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_OVERRIDEDLG_H
#define	_KB_OVERRIDEDLG_H

#if	! __KB_RUNTIME


#include	<qlist.h>
#include	<qwidget.h>
#include	<qwidgetstack.h>
#include	<qlayout.h>
#include	<qpushbutton.h>
#include	<qlistview.h>
#include	<qtextedit.h>

#include	"kb_param.h"
#include	"kb_override.h"
#include	"kb_dialog.h"
#include	"kb_attrdlg.h"

#include	"libkbase_exports.h"


/*  KBOverrideItem							*/
/*  --------------							*/
/*  This is a wrapper round a list view item, used to store the		*/
/*  properties of a override item which is being edited.		*/

class	LIBKBASE_API KBOverrideItem : public QListViewItem
{
	KBAttr		*m_attr		;
	KBAttrDlg	*m_attrDlg	;
	QString		m_value		;
	bool		m_enabled	;

	void		update	()	;

public	:

	KBOverrideItem
	(	QListView	*,
		KBObject	*,
		const QString	&,
		const QString	&,
		const QString	&,
		bool		,	
		QWidget		*
	) ;

        virtual ~KBOverrideItem () ;

	KBOverride		*getOverride	(KBNode *, uint ) ;
	void			save		(QTextEdit &    ) ;
	void			setValue	(const QString &) ;
	void			setEnabled	(bool)		  ;

	inline	KBAttrDlg	*getAttrDlg 	()
	{
		return	m_attrDlg ;
	}

	inline	QString		path	()	{ return text(0)   ; }
	inline	QString		attrib	()	{ return text(1)   ; }
	inline	QString		value	()	{ return m_value   ; }
	inline	bool		enabled	()	{ return m_enabled ; }
}	;



/*  KBOverrideDlg							*/
/*  -------------							*/
/*  This class is used as a component in property dialogs to handle	*/
/*  editing of override objects.					*/

class	LIBKBASE_API KBOverrideDlg : public QWidget
{
	Q_OBJECT

	enum	DlgRC
	{
		SyncOK,
		SyncFail,
		Dialog,
		None
	}	;

	KBObject	*m_object	;
	QWidgetStack	m_stack		;

//	QPushButton	m_bAdd		;
//	QPushButton	m_bRemove	;
	QPushButton	m_bEdit		;
	QPushButton	m_bSave		;
	QPushButton	m_bCancel	;
	QPushButton	m_bToggle	;

	QListView	m_lvOverride	;
	QTextEdit	m_textEdit	;

	KBAttrDlg	*m_attrDlg	;

	KBOverrideItem	*m_curItem	;
	KBOverrideItem	*m_editItem	;
	bool		m_adding	;
	uint		m_ident		;

	DlgRC		getAttrDlg	(KBOverrideItem *) ;
	void		saveCurrent	() ;

protected slots :

//	void		clickAdd	() ;
//	void		clickRemove	() ;
	void		clickEdit	() ;
	void		clickSave	() ;
	void		clickCancel	() ;
	void		clickToggle	() ;
	void		selectionChanged(QListViewItem *) ;

public	:

	KBOverrideDlg	(QWidget *, KBObject *) ;
	~KBOverrideDlg	() ;

	void		startUp		() ;
	void		fixUp		() ;
	QString		getText		() ;
}	;


#endif
#endif	// _KB_OVERRIDEDLG_H
