/***************************************************************************
    file	         : kb_labeldlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_attr.h"
#include	"kb_label.h"

#ifndef 	_WIN32
#include 	"kb_labeldlg.moc"
#else
#include 	"kb_labeldlg.h"
#endif



/*  KBLabelPropDlg							*/
/*  KBLabelPropDlg: Constructor for block properties dialog		*/
/*  label	  : KBLabel *	    : Parent label control		*/
/*  caption	  : const char *    : Dialog box caption		*/
/*  attribs	  : QList<KBAttr> & : List of attributes		*/
/*  iniAttr	  : cchar *	    : Initial attribute			*/
/*  (returns)	  : KBLabelPropDlg:					*/

KBLabelPropDlg::KBLabelPropDlg
	(	KBLabel		*label,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
	:
	KBPropDlg   (label, caption, attribs, iniAttr)
{
}

/*  KBLabelPropDlg							*/
/*  ~KBLabelPropDlg: Destructor for label properties dialog		*/
/*  (returns)	   : void	:					*/

KBLabelPropDlg::~KBLabelPropDlg ()
{
}

/*  KBLabelPropDlg							*/
/*  getAttrItem	: Get attribute item for attribute			*/
/*  attr	: KBAttr *	: Attribute				*/
/*  (returns)	: KBAttrItem *	: Associated attribute item		*/

KBAttrItem *KBLabelPropDlg::getAttrItem
	(	KBAttr	*attr
	)
{
	return	KBPropDlg::getAttrItem (attr) ;
}

/*  KBLabelPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBLabelPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	return	KBPropDlg::showProperty (item) ;
}

/*  KBPropDlg								*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBLabelPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	return	KBPropDlg::saveProperty (item) ;
}

/*  labelPropDlg: Run the data control properties dialog		*/
/*  label	: KBLabel *	 : Parent label control			*/
/*  caption	: const char *   : Dialog box caption			*/
/*  attribs	: QList<KBAttr>& : List of attributes			*/
/*  iniAttr	: cchar *	 : Initial attribute			*/
/*  (returns)	: bool		 : Success				*/

bool	labelPropDlg
	(	KBLabel		*label,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
{
	KBLabelPropDlg sDlg (label, caption, attribs, iniAttr) ;
	return	sDlg.exec () ;
}
