/***************************************************************************
    file	         : kb_helppopup.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qfile.h>
#include	<qregexp.h>
#include	<qtextview.h>
#include	<qtextstream.h>


#include	"kb_dialog.h"
#include	"kb_dom.h"
#include	"kb_locator.h"



class	KBHelpPopup : public _KBDialog
{
	QTextView	m_textView	;
	QVBoxLayout	m_layout	;

public	:

	KBHelpPopup	(const QString &, const QString &) ;
}	;


/*  ------------------------------------------------------------------  */

/*  KBHelpPopup								*/
/*  KBHelpPopup	: Constructor for embedded help popup			*/
/*  text	: const QString & : Help text				*/
/*  caption	: const QString & : Caption				*/
/*  (returns)	: KBHelpPopup	  :					*/

KBHelpPopup::KBHelpPopup
	(	const QString	&text,
		const QString	&caption
	)
	:
	_KBDialog	("", true),
	m_textView	(this),
	m_layout	(this)
{
	m_layout  .addWidget (&m_textView) ;
	m_textView.setText   (text) ;

	setCaption	(caption) ;
	showMaximized	() ;
}

/*  ------------------------------------------------------------------  */

/*  helpPopup	: Show embedded version help popup			*/
/*  tag		: const QString & : Help tag				*/
/*  (returns)	: void		  :					*/

void	helpPopup
	(	const QString	&tag
	)
{
	QString	name	= locateFile ("appdata", QString("help/%1.qt").arg(tag)) ;
	QFile	file	(name)	;

	if (!file.open (IO_ReadOnly)) return ;

	QTextStream	stream	(&file) ;
	QDomDocument	doc	;
	QString		text	;
	QString		legend	;

	doc.setContent (stream.read()) ;
	QDomElement	root   = doc.documentElement() ;

	for (QDomNode child = root.firstChild() ; !child.isNull() ; child = child.nextSibling())
	{
		QDomElement e = child.toElement() ;

		if (e.tagName() == "legend")
		{
			legend = e.text() ;
			continue ;
		}

		if (e.tagName() == "qt")
		{
			QTextStream  out (&text, IO_WriteOnly) ;
			e.save (out, 0) ;
			continue ;
		}
	}

	text.replace (QRegExp("<a.*/a>"), ""    ) ;
	text.replace (QRegExp("<h2>"   ),  "<b>") ;
	text.replace (QRegExp("</h2>"  ), "</b>") ;

	KBHelpPopup(text, legend).exec() ;
}
