/***************************************************************************
    file	         : kb_formcopier.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_FORMCOPIER_H
#define  _KB_FORMCOPIER_H

#include	"libkbase_exports.h"

/*  KBFormCopier								*/
/*  ------------								*/
/*  This class is used to the hold information needed when copying and	*/
/*  pasting between forms in design mode.				*/

class LIBKBASE_API	KBFormCopier
{
	QList<KBNode>	m_copied  ;	/* List of copied nodes		*/
	KB::ObjType	m_type	  ;	/* Type of copied nodes		*/

public	:

	inline	KBFormCopier ()
	{
		m_copied.setAutoDelete (true) ;
		m_type = KB::ObjUnknown	;
	}

	/* Cut/Copy/Paste within KBase is accomplished by replicating	*/
	/* chunks of the XML-derived node tree. "clearCopy" is called	*/
	/* before a cut or copy starts in order to clear extant stuff;	*/
	/* "addToCopy" is used to add a new chunk.			*/
	void		clearCopy	()	   ;
	void		addToCopy	(KBNode *, KB::ObjType) ;
	QList<KBNode>	&getCopied  	(KB::ObjType)	;

	bool		anyCopied	(KBNode *&)	;

	static	KBFormCopier *self()	;
}	;


#endif // _KB_FORMCOPIER_H
