/***************************************************************************
    file	         : kb_copybase.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COPYBASE_H
#define	__KB_COPYBASE_H

#include 	"libkbase_exports.h"

#include 	"kb_classes.h"
#include 	"kb_dom.h"


class	KBCopyExec	;


/*  KBCopyBase								*/
/*  ---------								*/
/*  Base class for copiers. Mostly pure virtual.			*/

class LIBKBASE_API	KBCopyBase
{
protected	:

	KBError		m_lError		;

public	:

	virtual	~KBCopyBase	() ;

	virtual	cchar		*tag		()		= 0 ;
	virtual	bool		valid		(KBError     &) = 0 ;
	virtual	void		def		(QDomElement &)	= 0 ;
	virtual	bool		set		(QDomElement &, KBError &) = 0 ;

	virtual	void		getColumnNames	(QStringList &) = 0 ;
	virtual	bool		prepare		(const QDict<QString>   &, KBCopyBase *) = 0 ;
	virtual	int		getNumCols	()		    	   = 0 ;
	virtual	int		getRow		(KBValue *, uint, bool  &) = 0 ;
	virtual	bool		putRow		(KBValue *, uint  ) 	   = 0 ;
	virtual	bool		finish		(QString &)	    	   = 0 ;

	inline	const	KBError	&lastError ()
		{
			return m_lError ;
		}

	virtual	int	execute
		(	KBCopyBase	*,
			KBValue		*,
			int		,
			KBCopyExec 	*
		)	; 
}	;

#endif	// __KB_COPYBASE_H
